/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.di;

import android.content.Context;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import javax.inject.Provider;
import javax.net.SocketFactory;
import okhttp3.OkHttpClient;
import org.sagebionetworks.bridge.android.BridgeConfig;
import org.sagebionetworks.bridge.android.BridgeConfig_Factory;
import org.sagebionetworks.bridge.android.di.BridgeServiceModule;
import org.sagebionetworks.bridge.android.di.BridgeServiceModule_GetAndroidStudyUploadEncryptorFactory;
import org.sagebionetworks.bridge.android.di.BridgeServiceModule_GetApiClientProviderFactory;
import org.sagebionetworks.bridge.android.di.BridgeServiceModule_GetSocketFactoryFactory;
import org.sagebionetworks.bridge.android.di.BridgeServiceModule_ProvidePublicApiFactory;
import org.sagebionetworks.bridge.android.di.BridgeStudyComponent;
import org.sagebionetworks.bridge.android.di.S3Module;
import org.sagebionetworks.bridge.android.di.S3Module_GetS3OkHttp3ClientFactory;
import org.sagebionetworks.bridge.android.manager.AppConfigManager;
import org.sagebionetworks.bridge.android.manager.AppConfigManager_Factory;
import org.sagebionetworks.bridge.android.manager.dao.AccountDAO;
import org.sagebionetworks.bridge.android.manager.dao.AccountDAO_Factory;
import org.sagebionetworks.bridge.android.manager.dao.AppConfigDAO;
import org.sagebionetworks.bridge.android.manager.dao.AppConfigDAO_Factory;
import org.sagebionetworks.bridge.android.manager.dao.ConsentDAO;
import org.sagebionetworks.bridge.android.manager.dao.ConsentDAO_Factory;
import org.sagebionetworks.bridge.android.manager.dao.UploadDAO;
import org.sagebionetworks.bridge.android.manager.dao.UploadDAO_Factory;
import org.sagebionetworks.bridge.data.AndroidStudyUploadEncryptor;
import org.sagebionetworks.bridge.rest.ApiClientProvider;
import org.sagebionetworks.bridge.rest.api.PublicApi;

public final class DaggerBridgeStudyComponent
implements BridgeStudyComponent {
    private Provider<Context> applicationContextProvider;
    private Provider<AccountDAO> accountDAOProvider;
    private Provider<BridgeConfig> bridgeConfigProvider;
    private Provider<SocketFactory> getSocketFactoryProvider;
    private Provider<ApiClientProvider> getApiClientProvider;
    private Provider<AppConfigDAO> appConfigDAOProvider;
    private Provider<PublicApi> providePublicApiProvider;
    private Provider<AppConfigManager> appConfigManagerProvider;
    private Provider<ConsentDAO> consentDAOProvider;
    private Provider<UploadDAO> uploadDAOProvider;
    private Provider<AndroidStudyUploadEncryptor> getAndroidStudyUploadEncryptorProvider;
    private Provider<OkHttpClient> getS3OkHttp3ClientProvider;

    private DaggerBridgeStudyComponent(BridgeServiceModule bridgeServiceModuleParam, S3Module s3ModuleParam, Context applicationContextParam) {
        this.initialize(bridgeServiceModuleParam, s3ModuleParam, applicationContextParam);
    }

    public static BridgeStudyComponent.Builder builder() {
        return new Builder();
    }

    private void initialize(BridgeServiceModule bridgeServiceModuleParam, S3Module s3ModuleParam, Context applicationContextParam) {
        this.applicationContextProvider = InstanceFactory.create((Object)applicationContextParam);
        this.accountDAOProvider = DoubleCheck.provider((Provider)AccountDAO_Factory.create(this.applicationContextProvider));
        this.bridgeConfigProvider = DoubleCheck.provider((Provider)BridgeConfig_Factory.create(this.applicationContextProvider));
        this.getSocketFactoryProvider = DoubleCheck.provider((Provider)BridgeServiceModule_GetSocketFactoryFactory.create(bridgeServiceModuleParam));
        this.getApiClientProvider = DoubleCheck.provider((Provider)BridgeServiceModule_GetApiClientProviderFactory.create(bridgeServiceModuleParam, this.applicationContextProvider, this.bridgeConfigProvider, this.getSocketFactoryProvider));
        this.appConfigDAOProvider = DoubleCheck.provider((Provider)AppConfigDAO_Factory.create(this.applicationContextProvider));
        this.providePublicApiProvider = DoubleCheck.provider((Provider)BridgeServiceModule_ProvidePublicApiFactory.create(this.getApiClientProvider));
        this.appConfigManagerProvider = DoubleCheck.provider((Provider)AppConfigManager_Factory.create(this.appConfigDAOProvider, this.providePublicApiProvider, this.bridgeConfigProvider));
        this.consentDAOProvider = DoubleCheck.provider((Provider)ConsentDAO_Factory.create(this.applicationContextProvider));
        this.uploadDAOProvider = DoubleCheck.provider((Provider)UploadDAO_Factory.create(this.applicationContextProvider));
        this.getAndroidStudyUploadEncryptorProvider = DoubleCheck.provider((Provider)BridgeServiceModule_GetAndroidStudyUploadEncryptorFactory.create(bridgeServiceModuleParam, this.bridgeConfigProvider));
        this.getS3OkHttp3ClientProvider = DoubleCheck.provider((Provider)S3Module_GetS3OkHttp3ClientFactory.create(s3ModuleParam, this.getSocketFactoryProvider));
    }

    @Override
    public AccountDAO getAccountDao() {
        return (AccountDAO)this.accountDAOProvider.get();
    }

    @Override
    public ApiClientProvider getApiClientProvider() {
        return (ApiClientProvider)this.getApiClientProvider.get();
    }

    @Override
    public AppConfigManager getAppConfigManager() {
        return (AppConfigManager)this.appConfigManagerProvider.get();
    }

    @Override
    public BridgeConfig getBridgeConfig() {
        return (BridgeConfig)this.bridgeConfigProvider.get();
    }

    @Override
    public ConsentDAO getConsentDao() {
        return (ConsentDAO)this.consentDAOProvider.get();
    }

    @Override
    public UploadDAO getUploadDAO() {
        return (UploadDAO)this.uploadDAOProvider.get();
    }

    @Override
    public AndroidStudyUploadEncryptor getStudyUploadEncryptor() {
        return (AndroidStudyUploadEncryptor)this.getAndroidStudyUploadEncryptorProvider.get();
    }

    @Override
    public OkHttpClient getS3OkHttp3Client() {
        return (OkHttpClient)this.getS3OkHttp3ClientProvider.get();
    }

    private static final class Builder
    implements BridgeStudyComponent.Builder {
        private BridgeServiceModule bridgeServiceModule;
        private S3Module s3Module;
        private Context applicationContext;

        private Builder() {
        }

        @Override
        public Builder applicationContext(Context context) {
            this.applicationContext = (Context)Preconditions.checkNotNull((Object)context);
            return this;
        }

        @Override
        public BridgeStudyComponent build() {
            if (this.bridgeServiceModule == null) {
                this.bridgeServiceModule = new BridgeServiceModule();
            }
            if (this.s3Module == null) {
                this.s3Module = new S3Module();
            }
            Preconditions.checkBuilderRequirement((Object)this.applicationContext, Context.class);
            return new DaggerBridgeStudyComponent(this.bridgeServiceModule, this.s3Module, this.applicationContext);
        }
    }
}

