/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager;

import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import javax.inject.Inject;
import org.sagebionetworks.bridge.android.BridgeConfig;
import org.sagebionetworks.bridge.android.di.BridgeStudyScope;
import org.sagebionetworks.bridge.android.manager.dao.AppConfigDAO;
import org.sagebionetworks.bridge.android.util.retrofit.RxUtils;
import org.sagebionetworks.bridge.rest.api.PublicApi;
import org.sagebionetworks.bridge.rest.model.AppConfig;
import rx.Single;

@BridgeStudyScope
@AnyThread
public class AppConfigManager {
    @NonNull
    private final AppConfigDAO appConfigDAO;
    @NonNull
    private final PublicApi publicApi;
    @NonNull
    private final BridgeConfig config;

    @Inject
    public AppConfigManager(@NonNull AppConfigDAO appConfigDAO, @NonNull PublicApi publicApi, @NonNull BridgeConfig config) {
        this.appConfigDAO = appConfigDAO;
        this.publicApi = publicApi;
        this.config = config;
    }

    @NonNull
    public Single<AppConfig> getAppConfig() {
        AppConfig cachedAppConfig = this.getCachedAppConfig();
        if (cachedAppConfig != null) {
            return Single.just((Object)cachedAppConfig);
        }
        return this.getRemoteAppConfig();
    }

    @Nullable
    public AppConfig getCachedAppConfig() {
        return this.appConfigDAO.getAppConfig();
    }

    @NonNull
    public Single<AppConfig> getRemoteAppConfig() {
        return RxUtils.toBodySingle(this.publicApi.getAppConfigForStudy(this.config.getStudyId())).doOnSuccess(this.appConfigDAO::cacheAppConfig);
    }
}

