/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.sagebionetworks.bridge.android.R;
import org.sagebionetworks.bridge.android.di.BridgeStudyScope;
import org.sagebionetworks.bridge.android.manager.upload.SchemaKey;
import org.sagebionetworks.bridge.rest.RestUtils;
import org.sagebionetworks.bridge.rest.model.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.jcajce.provider.asymmetric.x509.CertificateFactory;

@BridgeStudyScope
@AnyThread
public class BridgeConfig {
    private static final Logger logger = LoggerFactory.getLogger(BridgeConfig.class);
    public static final String EXTERNAL_ID_SETTINGS_FILENAME = "external_id_settings.json";
    public static final String STUDY_PUBLIC_KEY = "study_public_key.pem";
    public static final String TASK_TO_SCHEMA_FILENAME = "task_to_schema.json";
    public static final String REPORT_CATEGORY_MAPPINGS_FILENAME = "report_mappings.json";
    private static final String KEY_EXTERNAL_ID_EMAIL_FORMAT = "emailFormat";
    private static final String KEY_EXTERNAL_ID_PASSWORD_FORMAT = "passwordFormat";
    private static final Type STRING_TO_STRING_MAP = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type TASK_TO_SCHEMA_TYPE = new TypeToken<Map<String, SchemaKey>>(){}.getType();
    private static final Type REPORT_CATEGORY_MAP_TYPE = new TypeToken<Map<String, ReportCategory>>(){}.getType();
    private final Context applicationContext;
    private final String externalIdEmailFormat;
    private final String externalIdPasswordFormat;
    private final Map<String, SchemaKey> taskToSchemaMap;
    private final Map<String, ReportCategory> taskToReportCategoryMap;

    public String getExternalIdEmailFormat() {
        return this.externalIdEmailFormat;
    }

    @Inject
    public BridgeConfig(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        this.applicationContext = context.getApplicationContext();
        Map tempTaskToSchemaMap = (Map)this.loadJsonAsset(TASK_TO_SCHEMA_FILENAME, TASK_TO_SCHEMA_TYPE);
        this.taskToSchemaMap = tempTaskToSchemaMap != null ? tempTaskToSchemaMap : ImmutableMap.of();
        Map reportMappings = (Map)this.loadJsonAsset(REPORT_CATEGORY_MAPPINGS_FILENAME, REPORT_CATEGORY_MAP_TYPE);
        this.taskToReportCategoryMap = reportMappings != null ? reportMappings : ImmutableMap.of();
        Map externalIdSettings = (Map)this.loadJsonAsset(EXTERNAL_ID_SETTINGS_FILENAME, STRING_TO_STRING_MAP);
        if (externalIdSettings != null) {
            this.externalIdEmailFormat = (String)externalIdSettings.get(KEY_EXTERNAL_ID_EMAIL_FORMAT);
            this.externalIdPasswordFormat = (String)externalIdSettings.get(KEY_EXTERNAL_ID_PASSWORD_FORMAT);
        } else {
            this.externalIdEmailFormat = null;
            this.externalIdPasswordFormat = null;
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private <T> T loadJsonAsset(@NonNull String filename, @NonNull Type typeOfT) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NonNull
    public String getAcceptLanguage() {
        if (Build.VERSION.SDK_INT >= 24) {
            return this.applicationContext.getResources().getConfiguration().getLocales().toLanguageTags();
        }
        Locale uiLocale = this.applicationContext.getResources().getConfiguration().locale;
        if (Build.VERSION.SDK_INT >= 21) {
            return uiLocale.toLanguageTag();
        }
        return MessageFormat.format("{0}-{1}", uiLocale.getLanguage(), uiLocale.getCountry());
    }

    public int getSdkVersion() {
        return 4;
    }

    @NonNull
    public String getBaseUrl() {
        return this.applicationContext.getResources().getString(R.string.osb_base_url);
    }

    @NonNull
    public String getStudyId() {
        return this.applicationContext.getResources().getString(R.string.osb_study_id);
    }

    @NonNull
    public String getStudyName() {
        return this.applicationContext.getResources().getString(R.string.osb_study_name);
    }

    @NonNull
    public int getAppVersion() {
        try {
            PackageInfo pInfo = this.applicationContext.getPackageManager().getPackageInfo(this.applicationContext.getPackageName(), 0);
            return pInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            logger.error("Error retrieving application's version code, using SDK's", (Throwable)e);
            return 4;
        }
    }

    @NonNull
    public String getAppVersionName() {
        try {
            PackageInfo pInfo = this.applicationContext.getPackageManager().getPackageInfo(this.applicationContext.getPackageName(), 0);
            return pInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            logger.error("Error retrieving application's version name, using SDK's", (Throwable)e);
            return "android-sdk v1.2.0";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public X509Certificate getPublicKey() throws IOException, CertificateException {
        try (InputStream publicKeyFile = this.applicationContext.getAssets().open(STUDY_PUBLIC_KEY, 3);){
            X509Certificate x509Certificate = (X509Certificate)new CertificateFactory().engineGenerateCertificate(publicKeyFile);
            return x509Certificate;
        }
        catch (IOException e) {
            logger.error("Could not load public key from /assets/study_public_key.pem", (Throwable)e);
            throw e;
        }
    }

    @NonNull
    public Map<String, SchemaKey> getTaskToSchemaMap() {
        return this.taskToSchemaMap;
    }

    @NonNull
    public Map<String, ReportCategory> getTaskToReportCategoryMap() {
        return this.taskToReportCategoryMap;
    }

    @NonNull
    public final String getUserAgent() {
        ClientInfo clientInfo = new ClientInfo().appName(this.getStudyName()).appVersion(Integer.valueOf(this.getAppVersion())).deviceName(this.getDeviceName()).osName("Android").osVersion(Build.VERSION.RELEASE).sdkName("BridgeAndroidSDK").sdkVersion(Integer.valueOf(this.getSdkVersion()));
        String userAgent = RestUtils.getUserAgent((ClientInfo)clientInfo);
        if (!Strings.isNullOrEmpty((String)userAgent)) {
            return userAgent;
        }
        return this.getStudyName() + "/" + this.getAppVersion() + " (" + this.getDeviceName() + "; Android/" + Build.VERSION.RELEASE + ") BridgeAndroidSDK/" + this.getSdkVersion();
    }

    @NonNull
    public String getDeviceName() {
        String model;
        String manufacturer = Build.MANUFACTURER;
        if (TextUtils.isEmpty((CharSequence)manufacturer)) {
            manufacturer = "Unknown";
        }
        if (TextUtils.isEmpty((CharSequence)(model = Build.MODEL))) {
            model = "Android";
        }
        if (model.startsWith(manufacturer)) {
            return this.capitalize(model);
        }
        return this.capitalize(manufacturer) + " " + model;
    }

    @NonNull
    String capitalize(@Nullable String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }

    public String getEmailForExternalId(String externalId) {
        if (this.externalIdEmailFormat != null) {
            return String.format(this.externalIdEmailFormat, externalId);
        }
        throw new UnsupportedOperationException("Credentials for external ID require asset file external_id_settings.json");
    }

    public String getPasswordForExternalId(String externalId) {
        if (this.externalIdPasswordFormat != null) {
            return String.format(this.externalIdPasswordFormat, externalId);
        }
        throw new UnsupportedOperationException("Credentials for external ID require asset file external_id_settings.json");
    }

    public static enum ReportCategory {
        TIMESTAMP,
        GROUP_BY_DAY,
        SINGLETON;

    }
}

