/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class ParametersUtil {
    public static String urlEncode(String input) {
        if (StringUtils.isBlank((String)input)) {
            return input;
        }
        try {
            return URLEncoder.encode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String generateArgString(Properties options) {
        if (options == null) {
            return null;
        }
        StringBuilder argString = new StringBuilder();
        for (Map.Entry<Object, Object> option : options.entrySet()) {
            String key = String.valueOf(option.getKey());
            String value = String.valueOf(option.getValue());
            if (!StringUtils.isNotBlank((String)key) || !StringUtils.isNotBlank((String)value)) continue;
            if (argString.length() > 0) {
                argString.append(" ");
            }
            argString.append("-").append(key);
            argString.append(" ");
            if (value.indexOf(" ") >= 0 && (0 != value.indexOf("'") || value.length() - 1 != value.lastIndexOf("'"))) {
                argString.append("'").append(value).append("'");
                continue;
            }
            argString.append(value);
        }
        return argString.toString();
    }

    public static String generateNodeFiltersString(Properties nodeFilters) {
        if (nodeFilters == null) {
            return null;
        }
        ArrayList<String> filters = new ArrayList<String>();
        for (Map.Entry<Object, Object> filter : nodeFilters.entrySet()) {
            String key = String.valueOf(filter.getKey());
            String value = String.valueOf(filter.getValue());
            if (!StringUtils.isNotBlank((String)key) || !StringUtils.isNotBlank((String)value)) continue;
            try {
                filters.add(URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return StringUtils.join(filters, (String)"&");
    }
}

