/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.WorkflowState;
import org.rundeck.api.domain.WorkflowStepContextState;
import org.rundeck.api.domain.WorkflowStepState;
import org.rundeck.api.parser.XmlNodeParser;

public class IndexedWorkflowStepStateParser
implements XmlNodeParser<WorkflowStepContextState> {
    private final WorkflowState workflowState;
    private String rundeckNodeName;

    @Override
    public WorkflowStepContextState parseXmlNode(Node node) {
        String stepctx = StringUtils.trimToNull((String)node.valueOf("stepctx"));
        WorkflowStepState foundStep = IndexedWorkflowStepStateParser.lookupContext(stepctx, this.workflowState);
        if (null != foundStep && null != foundStep.getNodeStates() && null != foundStep.getNodeStates().get(this.rundeckNodeName)) {
            return foundStep.getNodeStates().get(this.rundeckNodeName);
        }
        return null;
    }

    public static WorkflowStepState lookupContext(String stepctx, WorkflowState initial) {
        String[] parts = stepctx.split("/");
        WorkflowState current = initial;
        WorkflowStepState currentStep = null;
        for (int i = 0; i < parts.length; ++i) {
            WorkflowStepState workflowStepState;
            String part = parts[i];
            currentStep = workflowStepState = current.getSteps().get(Integer.parseInt(part) - 1);
            if (i >= parts.length - 1) continue;
            current = currentStep.getSubWorkflow();
        }
        return currentStep;
    }

    public IndexedWorkflowStepStateParser(WorkflowState workflowState, String rundeckNodeName) {
        this.workflowState = workflowState;
        this.rundeckNodeName = rundeckNodeName;
    }
}

