/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.domain.RundeckEvent;
import org.rundeck.api.parser.BaseXpathParser;

public class EventParser
extends BaseXpathParser<RundeckEvent> {
    public EventParser(String xpath) {
        super(xpath);
    }

    public EventParser() {
    }

    @Override
    public RundeckEvent parse(Node eventNode) {
        String endedAt;
        RundeckEvent event = new RundeckEvent();
        event.setTitle(StringUtils.trimToNull((String)eventNode.valueOf("title")));
        try {
            event.setStatus(RundeckEvent.EventStatus.valueOf(StringUtils.upperCase((String)eventNode.valueOf("status"))));
        }
        catch (IllegalArgumentException e) {
            event.setStatus(null);
        }
        event.setSummary(StringUtils.trimToNull((String)eventNode.valueOf("summary")));
        RundeckEvent.NodeSummary nodeSummary = new RundeckEvent.NodeSummary();
        nodeSummary.setSucceeded(Integer.valueOf(eventNode.valueOf("node-summary/@succeeded")));
        nodeSummary.setFailed(Integer.valueOf(eventNode.valueOf("node-summary/@failed")));
        nodeSummary.setTotal(Integer.valueOf(eventNode.valueOf("node-summary/@total")));
        event.setNodeSummary(nodeSummary);
        event.setUser(StringUtils.trimToNull((String)eventNode.valueOf("user")));
        event.setProject(StringUtils.trimToNull((String)eventNode.valueOf("project")));
        String startedAt = StringUtils.trimToNull((String)eventNode.valueOf("@starttime"));
        if (startedAt != null) {
            event.setStartedAt(new Date(Long.valueOf(startedAt)));
        }
        if ((endedAt = StringUtils.trimToNull((String)eventNode.valueOf("@endtime"))) != null) {
            event.setEndedAt(new Date(Long.valueOf(endedAt)));
        }
        event.setAbortedBy(StringUtils.trimToNull((String)eventNode.valueOf("abortedby")));
        try {
            event.setExecutionId(Long.valueOf(eventNode.valueOf("execution/@id")));
        }
        catch (NumberFormatException e) {
            event.setExecutionId(null);
        }
        event.setJobId(StringUtils.trimToNull((String)eventNode.valueOf("job/@id")));
        return event;
    }
}

