/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.parser;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;
import org.rundeck.api.parser.XmlNodeParser;

public abstract class BaseXpathParser<T>
implements XmlNodeParser<T> {
    private String xpath;

    public BaseXpathParser() {
    }

    public BaseXpathParser(String xpath) {
        this.xpath = xpath;
    }

    public abstract T parse(Node var1);

    @Override
    public final T parseXmlNode(Node node) {
        return this.parse(this.selectNode(node));
    }

    private Node selectNode(Node node) {
        return BaseXpathParser.selectNodeAndUnwrap(node, this.xpath);
    }

    public static Node selectNodeAndUnwrap(Node node, String xpath) {
        String useXpath = BaseXpathParser.unwrapXpath(node, xpath);
        if (StringUtils.isNotEmpty((String)useXpath)) {
            return node.selectSingleNode(useXpath);
        }
        return node;
    }

    public static String unwrapXpath(Node node, String xpath) {
        boolean rootResult = node.getName() == null && "result".equals(node.getDocument().getRootElement().getName());
        boolean isEmpty = StringUtils.isEmpty((String)xpath);
        String useXpath = xpath;
        if (isEmpty) {
            if (rootResult) {
                useXpath = "result/*";
            }
        } else if (rootResult) {
            if (!(useXpath.startsWith("result") || useXpath.startsWith("/result") || useXpath.startsWith("//"))) {
                useXpath = "result/" + xpath;
            }
        } else if (useXpath.startsWith("result")) {
            useXpath = xpath.substring("result".length());
        } else if (useXpath.startsWith("/result")) {
            useXpath = xpath.substring("/result".length());
        }
        return useXpath;
    }
}

