/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api.domain;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.rundeck.api.domain.RundeckJob;
import org.rundeck.api.domain.RundeckNodeIdentity;

public class RundeckExecution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String url;
    private ExecutionStatus status;
    private RundeckJob job;
    private String startedBy;
    private Date startedAt;
    private Date endedAt;
    private String abortedBy;
    private String description;
    private String argstring;
    private String project;
    private Set<RundeckNodeIdentity> successfulNodes;
    private Set<RundeckNodeIdentity> failedNodes;

    public Long getDurationInMillis() {
        if (this.startedAt == null || this.endedAt == null) {
            return null;
        }
        return this.endedAt.getTime() - this.startedAt.getTime();
    }

    public Long getDurationInSeconds() {
        Long durationInMillis = this.getDurationInMillis();
        return durationInMillis != null ? Long.valueOf(TimeUnit.MILLISECONDS.toSeconds(durationInMillis)) : null;
    }

    public String getDuration() {
        Long durationInMillis = this.getDurationInMillis();
        return durationInMillis != null ? DurationFormatUtils.formatDurationWords((long)durationInMillis, (boolean)true, (boolean)true) : null;
    }

    public String getShortDuration() {
        Long durationInMillis = this.getDurationInMillis();
        return durationInMillis != null ? DurationFormatUtils.formatDurationHMS((long)durationInMillis) : null;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ExecutionStatus status) {
        this.status = status;
    }

    public RundeckJob getJob() {
        return this.job;
    }

    public void setJob(RundeckJob job) {
        this.job = job;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    public Date getStartedAt() {
        return this.startedAt != null ? new Date(this.startedAt.getTime()) : null;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt != null ? new Date(startedAt.getTime()) : null;
    }

    public Date getEndedAt() {
        return this.endedAt != null ? new Date(this.endedAt.getTime()) : null;
    }

    public void setEndedAt(Date endedAt) {
        this.endedAt = endedAt != null ? new Date(endedAt.getTime()) : null;
    }

    public String getAbortedBy() {
        return this.abortedBy;
    }

    public void setAbortedBy(String abortedBy) {
        this.abortedBy = abortedBy;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return "RundeckExecution [id=" + this.id + ", description=" + this.description + ", url=" + this.url + ", status=" + (Object)((Object)this.status) + ", argstring=" + this.argstring + ", startedBy=" + this.startedBy + ", startedAt=" + this.startedAt + ", endedAt=" + this.endedAt + ", durationInSeconds=" + this.getDurationInSeconds() + ", abortedBy=" + this.abortedBy + ", job=" + this.job + ", successfulNodes=" + this.getSuccessfulNodes() + ", failedNodes=" + this.getFailedNodes() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.abortedBy == null ? 0 : this.abortedBy.hashCode());
        result = 31 * result + (this.argstring == null ? 0 : this.argstring.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.endedAt == null ? 0 : this.endedAt.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.job == null ? 0 : this.job.hashCode());
        result = 31 * result + (this.startedAt == null ? 0 : this.startedAt.hashCode());
        result = 31 * result + (this.startedBy == null ? 0 : this.startedBy.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RundeckExecution other = (RundeckExecution)obj;
        if (this.abortedBy == null ? other.abortedBy != null : !this.abortedBy.equals(other.abortedBy)) {
            return false;
        }
        if (this.argstring == null ? other.argstring != null : !this.argstring.equals(other.argstring)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.endedAt == null ? other.endedAt != null : !this.endedAt.equals(other.endedAt)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.job == null ? other.job != null : !this.job.equals(other.job)) {
            return false;
        }
        if (this.startedAt == null ? other.startedAt != null : !this.startedAt.equals(other.startedAt)) {
            return false;
        }
        if (this.startedBy == null ? other.startedBy != null : !this.startedBy.equals(other.startedBy)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }

    public String getArgstring() {
        return this.argstring;
    }

    public void setArgstring(String argstring) {
        this.argstring = argstring;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public Set<RundeckNodeIdentity> getSuccessfulNodes() {
        return this.successfulNodes;
    }

    public void setSuccessfulNodes(Set<RundeckNodeIdentity> successfulNodes) {
        this.successfulNodes = successfulNodes;
    }

    public Set<RundeckNodeIdentity> getFailedNodes() {
        return this.failedNodes;
    }

    public void setFailedNodes(Set<RundeckNodeIdentity> failedNodes) {
        this.failedNodes = failedNodes;
    }

    public static enum ExecutionStatus {
        RUNNING,
        SUCCEEDED,
        FAILED,
        ABORTED,
        FAILED_WITH_RETRY,
        TIMEDOUT;

    }
}

