/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.api;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class NodeFiltersBuilder {
    private final Properties filters = new Properties();

    public NodeFiltersBuilder hostname(String hostname) {
        if (StringUtils.isNotBlank((String)hostname)) {
            this.filters.put("hostname", hostname);
        }
        return this;
    }

    public NodeFiltersBuilder type(String type) {
        if (StringUtils.isNotBlank((String)type)) {
            this.filters.put("type", type);
        }
        return this;
    }

    public NodeFiltersBuilder tags(String tags) {
        if (StringUtils.isNotBlank((String)tags)) {
            this.filters.put("tags", tags);
        }
        return this;
    }

    public NodeFiltersBuilder name(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            this.filters.put("name", name);
        }
        return this;
    }

    public NodeFiltersBuilder osName(String osName) {
        if (StringUtils.isNotBlank((String)osName)) {
            this.filters.put("os-name", osName);
        }
        return this;
    }

    public NodeFiltersBuilder osFamily(String osFamily) {
        if (StringUtils.isNotBlank((String)osFamily)) {
            this.filters.put("os-family", osFamily);
        }
        return this;
    }

    public NodeFiltersBuilder osArch(String osArch) {
        if (StringUtils.isNotBlank((String)osArch)) {
            this.filters.put("os-arch", osArch);
        }
        return this;
    }

    public NodeFiltersBuilder osVersion(String osVersion) {
        if (StringUtils.isNotBlank((String)osVersion)) {
            this.filters.put("os-version", osVersion);
        }
        return this;
    }

    public NodeFiltersBuilder excludeHostname(String hostname) {
        if (StringUtils.isNotBlank((String)hostname)) {
            this.filters.put("exclude-hostname", hostname);
        }
        return this;
    }

    public NodeFiltersBuilder excludeType(String type) {
        if (StringUtils.isNotBlank((String)type)) {
            this.filters.put("exclude-type", type);
        }
        return this;
    }

    public NodeFiltersBuilder excludeTags(String tags) {
        if (StringUtils.isNotBlank((String)tags)) {
            this.filters.put("exclude-tags", tags);
        }
        return this;
    }

    public NodeFiltersBuilder excludeName(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            this.filters.put("exclude-name", name);
        }
        return this;
    }

    public NodeFiltersBuilder excludeOsName(String osName) {
        if (StringUtils.isNotBlank((String)osName)) {
            this.filters.put("exclude-os-name", osName);
        }
        return this;
    }

    public NodeFiltersBuilder excludeOsFamily(String osFamily) {
        if (StringUtils.isNotBlank((String)osFamily)) {
            this.filters.put("exclude-os-family", osFamily);
        }
        return this;
    }

    public NodeFiltersBuilder excludeOsArch(String osArch) {
        if (StringUtils.isNotBlank((String)osArch)) {
            this.filters.put("exclude-os-arch", osArch);
        }
        return this;
    }

    public NodeFiltersBuilder excludeOsVersion(String osVersion) {
        if (StringUtils.isNotBlank((String)osVersion)) {
            this.filters.put("exclude-os-version", osVersion);
        }
        return this;
    }

    public NodeFiltersBuilder excludePrecedence(boolean excludePrecedence) {
        this.filters.put("exclude-precedence", Boolean.toString(excludePrecedence));
        return this;
    }

    public Properties toProperties() {
        Properties filters = new Properties();
        filters.putAll((Map<?, ?>)this.filters);
        return filters;
    }
}

