/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rocksdb.util.Environment;

public class NativeLibraryLoader {
    private static String sharedLibraryName = Environment.getJniLibraryName("rocksdb");
    private static String tempFilePrefix = "librocksdbjni";
    private static String tempFileSuffix = "." + Environment.getJniLibraryExtension();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromJar(String string) throws IOException {
        File file = string == null || string.equals("") ? File.createTempFile(tempFilePrefix, tempFileSuffix) : new File(string + "/" + sharedLibraryName);
        file.deleteOnExit();
        if (!file.exists()) {
            throw new RuntimeException("File " + file.getAbsolutePath() + " does not exist.");
        }
        byte[] byArray = new byte[102400];
        InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream(sharedLibraryName);
        if (inputStream == null) {
            throw new RuntimeException(sharedLibraryName + " was not found inside JAR.");
        }
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        System.load(file.getAbsolutePath());
    }

    private NativeLibraryLoader() {
    }
}

