/*
 * Decompiled with CFR 0.152.
 */
package org.rocko.bpb;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.PathShape;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.util.Property;
import org.rocko.bpb.R;

public class BounceProgressBar
extends View {
    private static final String TAG = BounceProgressBar.class.getSimpleName();
    private int speed;
    private int size;
    private int shape;
    private Drawable src;
    private Paint mPaint;
    private int mWidth;
    private int mHeight;
    private int firstBitmapTop = Integer.MIN_VALUE;
    private int secondBitmapTop = Integer.MIN_VALUE;
    private int thirdBitmapTop = Integer.MIN_VALUE;
    private Matrix firstBitmapMatrix;
    private Matrix secondBitmapMatrix;
    private Matrix thirdBitmapMatrix;
    private Bitmap firstBitmap;
    private Bitmap secondBitmap;
    private Bitmap thirdBitmap;
    private static final int count = 3;
    private float firstDX;
    private float secondDX;
    private float thirdDX;
    private AnimatorSet bouncer;
    private Property<BounceProgressBar, Integer> firstBitmapTopProperty = new Property<BounceProgressBar, Integer>(Integer.class, "firstDrawableTop"){

        public Integer get(BounceProgressBar obj) {
            return obj.firstBitmapTop;
        }

        public void set(BounceProgressBar obj, Integer value) {
            obj.firstBitmapTop = value;
            BounceProgressBar.this.invalidate();
        }
    };
    private Property<BounceProgressBar, Integer> secondBitmapTopProperty = new Property<BounceProgressBar, Integer>(Integer.class, "secondDrawableTop"){

        public Integer get(BounceProgressBar obj) {
            return obj.secondBitmapTop;
        }

        public void set(BounceProgressBar obj, Integer value) {
            obj.secondBitmapTop = value;
            BounceProgressBar.this.invalidate();
        }
    };
    private Property<BounceProgressBar, Integer> thirdBitmapTopProperty = new Property<BounceProgressBar, Integer>(Integer.class, "thirdDrawableTop"){

        public Integer get(BounceProgressBar obj) {
            return obj.thirdBitmapTop;
        }

        public void set(BounceProgressBar obj, Integer value) {
            obj.thirdBitmapTop = value;
            BounceProgressBar.this.invalidate();
        }
    };

    public BounceProgressBar(Context context) {
        this(context, null, 0);
    }

    public BounceProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BounceProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.BounceProgressBar);
        this.speed = a.getInt(R.styleable.BounceProgressBar_speed, 250);
        this.size = a.getDimensionPixelSize(R.styleable.BounceProgressBar_singleSrcSize, 50);
        this.shape = a.getInt(R.styleable.BounceProgressBar_shape, 0);
        this.src = a.getDrawable(R.styleable.BounceProgressBar_src);
        a.recycle();
        if (null == this.src) {
            throw new NullPointerException("BounceProgressBar did not define src Attribute.");
        }
        Bitmap srcBitmap = this.drawable2Bitmap(this.src);
        this.firstBitmap = this.initShapeBitmap(this.shape, srcBitmap, 255);
        this.secondBitmap = this.initShapeBitmap(this.shape, srcBitmap, 205);
        this.thirdBitmap = this.initShapeBitmap(this.shape, srcBitmap, 175);
        srcBitmap.recycle();
        this.mHeight = 4 * this.size;
        this.mWidth = 5 * this.size;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.firstBitmapMatrix = new Matrix();
        this.secondBitmapMatrix = new Matrix();
        this.thirdBitmapMatrix = new Matrix();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int sizeWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int sizeHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int modeWidth = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int modeHeight = View.MeasureSpec.getMode((int)heightMeasureSpec);
        this.setMeasuredDimension(modeWidth == 0x40000000 ? (this.mWidth = sizeWidth) : this.mWidth, modeHeight == 0x40000000 ? (this.mHeight = sizeHeight) : this.mHeight);
        this.firstDX = this.mWidth / 4 - this.size / 2;
        this.secondDX = this.mWidth / 2 - this.size / 2;
        this.thirdDX = 3 * this.mWidth / 4 - this.size / 2;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.bouncer == null || !this.bouncer.isRunning()) {
            ObjectAnimator firstAnimator = this.initDrawableAnimator(this.firstBitmapTopProperty, this.speed, this.size / 2, this.mHeight - this.size);
            ObjectAnimator secondAnimator = this.initDrawableAnimator(this.secondBitmapTopProperty, this.speed, this.size / 2, this.mHeight - this.size);
            secondAnimator.setStartDelay(100L);
            ObjectAnimator thirdAnimator = this.initDrawableAnimator(this.thirdBitmapTopProperty, this.speed, this.size / 2, this.mHeight - this.size);
            thirdAnimator.setStartDelay(200L);
            this.bouncer = new AnimatorSet();
            this.bouncer.playTogether(new Animator[]{firstAnimator, secondAnimator, thirdAnimator});
            this.bouncer.start();
        }
    }

    public void requestLayout() {
        super.requestLayout();
        if (this.bouncer != null) {
            this.bouncer.cancel();
        }
    }

    protected synchronized void onDraw(Canvas canvas) {
        this.firstBitmapMatrix.reset();
        this.firstBitmapMatrix.postTranslate(this.firstDX, (float)this.firstBitmapTop);
        this.secondBitmapMatrix.reset();
        this.secondBitmapMatrix.setTranslate(this.secondDX, (float)this.secondBitmapTop);
        this.thirdBitmapMatrix.reset();
        this.thirdBitmapMatrix.setTranslate(this.thirdDX, (float)this.thirdBitmapTop);
        canvas.drawBitmap(this.firstBitmap, this.firstBitmapMatrix, this.mPaint);
        canvas.drawBitmap(this.secondBitmap, this.secondBitmapMatrix, this.mPaint);
        canvas.drawBitmap(this.thirdBitmap, this.thirdBitmapMatrix, this.mPaint);
    }

    private ObjectAnimator initDrawableAnimator(Property<BounceProgressBar, Integer> property, int duration, int startValue, int endValue) {
        ObjectAnimator animator = ObjectAnimator.ofInt((Object)((Object)this), property, (int[])new int[]{startValue, endValue});
        animator.setDuration((long)duration);
        animator.setRepeatCount(-1);
        animator.setRepeatMode(2);
        animator.setInterpolator((Interpolator)new AccelerateInterpolator());
        return animator;
    }

    private Bitmap initShapeBitmap(int shape, Bitmap srcBitmap, int alpha) {
        BitmapShader bitmapShader = new BitmapShader(srcBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Bitmap bitmap = Bitmap.createBitmap((int)this.size, (int)this.size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        ShapeDrawable shapeDrawable = new ShapeDrawable();
        shapeDrawable.getPaint().setAntiAlias(true);
        shapeDrawable.getPaint().setShader((Shader)bitmapShader);
        shapeDrawable.setBounds(0, 0, this.size, this.size);
        shapeDrawable.setAlpha(alpha);
        switch (shape) {
            case 1: {
                shapeDrawable.setShape((android.graphics.drawable.shapes.Shape)new OvalShape());
                break;
            }
            case 2: {
                Path path = new Path();
                float radian = 0.62831855f;
                float radius = this.size / 2;
                float radius_in = (float)((double)radius * Math.sin(radian / 2.0f) / Math.cos(radian));
                path.moveTo((float)((double)radius * Math.cos(radian / 2.0f)), 0.0f);
                path.lineTo((float)((double)radius * Math.cos(radian / 2.0f) + (double)radius_in * Math.sin(radian)), (float)((double)radius - (double)radius * Math.sin(radian / 2.0f)));
                path.lineTo((float)((double)radius * Math.cos(radian / 2.0f) * 2.0), (float)((double)radius - (double)radius * Math.sin(radian / 2.0f)));
                path.lineTo((float)((double)radius * Math.cos(radian / 2.0f) + (double)radius_in * Math.cos(radian / 2.0f)), (float)((double)radius + (double)radius_in * Math.sin(radian / 2.0f)));
                path.lineTo((float)((double)radius * Math.cos(radian / 2.0f) + (double)radius * Math.sin(radian)), (float)((double)radius + (double)radius * Math.cos(radian)));
                path.lineTo((float)((double)radius * Math.cos(radian / 2.0f)), radius + radius_in);
                path.lineTo((float)((double)radius * Math.cos(radian / 2.0f) - (double)radius * Math.sin(radian)), (float)((double)radius + (double)radius * Math.cos(radian)));
                path.lineTo((float)((double)radius * Math.cos(radian / 2.0f) - (double)radius_in * Math.cos(radian / 2.0f)), (float)((double)radius + (double)radius_in * Math.sin(radian / 2.0f)));
                path.lineTo(0.0f, (float)((double)radius - (double)radius * Math.sin(radian / 2.0f)));
                path.lineTo((float)((double)radius * Math.cos(radian / 2.0f) - (double)radius_in * Math.sin(radian)), (float)((double)radius - (double)radius * Math.sin(radian / 2.0f)));
                path.close();
                shapeDrawable.setShape((android.graphics.drawable.shapes.Shape)new PathShape(path, (float)this.size, (float)this.size));
                break;
            }
            case 3: {
                Path path = new Path();
                path.moveTo((float)(this.size / 2), 0.0f);
                path.lineTo(0.0f, (float)(this.size / 2));
                path.lineTo((float)(this.size / 2), (float)this.size);
                path.lineTo((float)this.size, (float)(this.size / 2));
                path.close();
                shapeDrawable.setShape((android.graphics.drawable.shapes.Shape)new PathShape(path, (float)this.size, (float)this.size));
                break;
            }
            case 4: {
                Path path = new Path();
                Paint paint = new Paint();
                paint.setAntiAlias(true);
                paint.setShader((Shader)bitmapShader);
                Matrix matrix = new Matrix();
                Region region = new Region();
                RectF ovalRect = new RectF((float)(this.size / 4), 0.0f, (float)(this.size - this.size / 4), (float)this.size);
                path.addOval(ovalRect, Path.Direction.CW);
                matrix.postRotate(42.0f, (float)(this.size / 2), (float)(this.size / 2));
                path.transform(matrix, path);
                region.setPath(path, new Region(this.size / 2, 0, this.size, this.size));
                canvas.drawPath(region.getBoundaryPath(), paint);
                matrix.reset();
                path.reset();
                path.addOval(ovalRect, Path.Direction.CW);
                matrix.postRotate(-42.0f, (float)(this.size / 2), (float)(this.size / 2));
                path.transform(matrix, path);
                region.setPath(path, new Region(0, 0, this.size / 2, this.size));
                canvas.drawPath(region.getBoundaryPath(), paint);
                return bitmap;
            }
            case 0: {
                break;
            }
        }
        shapeDrawable.draw(canvas);
        return bitmap;
    }

    private Bitmap drawable2Bitmap(Drawable drawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.size, (int)this.size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, this.size, this.size);
        drawable.draw(canvas);
        return bitmap;
    }

    public void setDrawable(Drawable drawable) {
        this.setDrawable(drawable, this.shape);
    }

    public void setDrawable(Drawable drawable, int shape) {
        this.setBitmap(this.drawable2Bitmap(drawable), shape);
    }

    public void setBitmap(Bitmap bitmap) {
        this.setBitmap(bitmap, this.shape);
    }

    public void setBitmap(Bitmap bitmap, int shape) {
        this.firstBitmap = this.initShapeBitmap(shape, bitmap, 255);
        this.secondBitmap = this.initShapeBitmap(shape, bitmap, 205);
        this.thirdBitmap = this.initShapeBitmap(shape, bitmap, 175);
        this.invalidate();
    }

    public void setSpeed(int speed) {
        this.speed = speed;
        this.requestLayout();
    }

    public static interface Shape {
        public static final int original = 0;
        public static final int circle = 1;
        public static final int pentagon = 2;
        public static final int rhombus = 3;
        public static final int heart = 4;
    }
}

