/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.impl;

import com.binance.api.client.BinanceApiError;
import com.binance.api.client.config.BinanceApiConfig;
import com.binance.api.client.exception.BinanceApiException;
import com.binance.api.client.security.AuthenticationInterceptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class BinanceApiServiceGenerator {
    private static final OkHttpClient sharedClient;
    private static final Converter.Factory converterFactory;
    private static final Converter<ResponseBody, BinanceApiError> errorBodyConverter;

    public static <S> S createService(Class<S> serviceClass) {
        return BinanceApiServiceGenerator.createService(serviceClass, null, null);
    }

    public static <S> S createService(Class<S> serviceClass, String apiKey, String secret) {
        String baseUrl = null;
        baseUrl = !BinanceApiConfig.useTestnet ? BinanceApiConfig.getApiBaseUrl() : BinanceApiConfig.getTestNetBaseUrl();
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory(converterFactory);
        if (StringUtils.isEmpty((CharSequence)apiKey) || StringUtils.isEmpty((CharSequence)secret)) {
            retrofitBuilder.client(sharedClient);
        } else {
            AuthenticationInterceptor interceptor = new AuthenticationInterceptor(apiKey, secret);
            OkHttpClient adaptedClient = sharedClient.newBuilder().addInterceptor((Interceptor)interceptor).build();
            retrofitBuilder.client(adaptedClient);
        }
        Retrofit retrofit = retrofitBuilder.build();
        return (S)retrofit.create(serviceClass);
    }

    public static <T> T executeSync(Call<T> call) {
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                return (T)response.body();
            }
            BinanceApiError apiError = BinanceApiServiceGenerator.getBinanceApiError(response);
            throw new BinanceApiException(apiError);
        }
        catch (IOException e) {
            throw new BinanceApiException(e);
        }
    }

    public static BinanceApiError getBinanceApiError(Response<?> response) throws IOException, BinanceApiException {
        return (BinanceApiError)errorBodyConverter.convert((Object)response.errorBody());
    }

    public static OkHttpClient getSharedClient() {
        return sharedClient;
    }

    static {
        converterFactory = JacksonConverterFactory.create();
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequestsPerHost(500);
        dispatcher.setMaxRequests(500);
        sharedClient = new OkHttpClient.Builder().dispatcher(dispatcher).pingInterval(20L, TimeUnit.SECONDS).build();
        errorBodyConverter = converterFactory.responseBodyConverter(BinanceApiError.class, new Annotation[0], null);
    }
}

