/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.impl;

import com.binance.api.client.domain.OrderSide;
import com.binance.api.client.domain.OrderType;
import com.binance.api.client.domain.SwapRemoveType;
import com.binance.api.client.domain.TimeInForce;
import com.binance.api.client.domain.account.Account;
import com.binance.api.client.domain.account.DepositAddress;
import com.binance.api.client.domain.account.DepositHistory;
import com.binance.api.client.domain.account.DustTransferResponse;
import com.binance.api.client.domain.account.Liquidity;
import com.binance.api.client.domain.account.LiquidityOperationRecord;
import com.binance.api.client.domain.account.LoanQueryResult;
import com.binance.api.client.domain.account.MarginAccount;
import com.binance.api.client.domain.account.MarginNewOrderResponse;
import com.binance.api.client.domain.account.MarginTransaction;
import com.binance.api.client.domain.account.MaxBorrowableQueryResult;
import com.binance.api.client.domain.account.NewOCOResponse;
import com.binance.api.client.domain.account.NewOrderResponse;
import com.binance.api.client.domain.account.NewOrderResponseType;
import com.binance.api.client.domain.account.Order;
import com.binance.api.client.domain.account.OrderList;
import com.binance.api.client.domain.account.Pool;
import com.binance.api.client.domain.account.RepayQueryResult;
import com.binance.api.client.domain.account.SideEffectType;
import com.binance.api.client.domain.account.SubAccountTransfer;
import com.binance.api.client.domain.account.SwapHistory;
import com.binance.api.client.domain.account.SwapQuote;
import com.binance.api.client.domain.account.SwapRecord;
import com.binance.api.client.domain.account.Trade;
import com.binance.api.client.domain.account.TradeHistoryItem;
import com.binance.api.client.domain.account.WithdrawHistory;
import com.binance.api.client.domain.account.WithdrawResult;
import com.binance.api.client.domain.account.request.CancelOrderListResponse;
import com.binance.api.client.domain.account.request.CancelOrderResponse;
import com.binance.api.client.domain.event.ListenKey;
import com.binance.api.client.domain.general.Asset;
import com.binance.api.client.domain.general.ExchangeInfo;
import com.binance.api.client.domain.general.ServerTime;
import com.binance.api.client.domain.market.AggTrade;
import com.binance.api.client.domain.market.BookTicker;
import com.binance.api.client.domain.market.Candlestick;
import com.binance.api.client.domain.market.OrderBook;
import com.binance.api.client.domain.market.TickerPrice;
import com.binance.api.client.domain.market.TickerStatistics;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface BinanceApiService {
    @GET(value="/api/v1/ping")
    public Call<Void> ping();

    @GET(value="/api/v1/time")
    public Call<ServerTime> getServerTime();

    @GET(value="/api/v3/exchangeInfo")
    public Call<ExchangeInfo> getExchangeInfo();

    @GET
    public Call<List<Asset>> getAllAssets(@Url String var1);

    @GET(value="/api/v1/depth")
    public Call<OrderBook> getOrderBook(@Query(value="symbol") String var1, @Query(value="limit") Integer var2);

    @GET(value="/api/v1/trades")
    public Call<List<TradeHistoryItem>> getTrades(@Query(value="symbol") String var1, @Query(value="limit") Integer var2);

    @Headers(value={"APIKEY: #"})
    @GET(value="/api/v1/historicalTrades")
    public Call<List<TradeHistoryItem>> getHistoricalTrades(@Query(value="symbol") String var1, @Query(value="limit") Integer var2, @Query(value="fromId") Long var3);

    @GET(value="/api/v1/aggTrades")
    public Call<List<AggTrade>> getAggTrades(@Query(value="symbol") String var1, @Query(value="fromId") String var2, @Query(value="limit") Integer var3, @Query(value="startTime") Long var4, @Query(value="endTime") Long var5);

    @GET(value="/api/v1/klines")
    public Call<List<Candlestick>> getCandlestickBars(@Query(value="symbol") String var1, @Query(value="interval") String var2, @Query(value="limit") Integer var3, @Query(value="startTime") Long var4, @Query(value="endTime") Long var5);

    @GET(value="/api/v1/ticker/24hr")
    public Call<TickerStatistics> get24HrPriceStatistics(@Query(value="symbol") String var1);

    @GET(value="/api/v1/ticker/24hr")
    public Call<List<TickerStatistics>> getAll24HrPriceStatistics();

    @GET(value="/api/v1/ticker/allPrices")
    public Call<List<TickerPrice>> getLatestPrices();

    @GET(value="/api/v3/ticker/price")
    public Call<TickerPrice> getLatestPrice(@Query(value="symbol") String var1);

    @GET(value="/api/v1/ticker/allBookTickers")
    public Call<List<BookTicker>> getBookTickers();

    @Headers(value={"SIGNED: #"})
    @POST(value="/api/v3/order")
    public Call<NewOrderResponse> newOrder(@Query(value="symbol") String var1, @Query(value="side") OrderSide var2, @Query(value="type") OrderType var3, @Query(value="timeInForce") TimeInForce var4, @Query(value="quantity") String var5, @Query(value="price") String var6, @Query(value="newClientOrderId") String var7, @Query(value="stopPrice") String var8, @Query(value="icebergQty") String var9, @Query(value="newOrderRespType") NewOrderResponseType var10, @Query(value="recvWindow") Long var11, @Query(value="timestamp") Long var12);

    @Headers(value={"SIGNED: #"})
    @POST(value="/api/v3/order")
    public Call<NewOrderResponse> newOrderQuoteQty(@Query(value="symbol") String var1, @Query(value="side") OrderSide var2, @Query(value="type") OrderType var3, @Query(value="timeInForce") TimeInForce var4, @Query(value="quoteOrderQty") String var5, @Query(value="price") String var6, @Query(value="newClientOrderId") String var7, @Query(value="stopPrice") String var8, @Query(value="icebergQty") String var9, @Query(value="newOrderRespType") NewOrderResponseType var10, @Query(value="recvWindow") Long var11, @Query(value="timestamp") Long var12);

    @Headers(value={"SIGNED: #"})
    @POST(value="/api/v3/order/test")
    public Call<Void> newOrderTest(@Query(value="symbol") String var1, @Query(value="side") OrderSide var2, @Query(value="type") OrderType var3, @Query(value="timeInForce") TimeInForce var4, @Query(value="quantity") String var5, @Query(value="price") String var6, @Query(value="newClientOrderId") String var7, @Query(value="stopPrice") String var8, @Query(value="icebergQty") String var9, @Query(value="newOrderRespType") NewOrderResponseType var10, @Query(value="recvWindow") Long var11, @Query(value="timestamp") Long var12);

    @Headers(value={"SIGNED: #"})
    @GET(value="/api/v3/order")
    public Call<Order> getOrderStatus(@Query(value="symbol") String var1, @Query(value="orderId") Long var2, @Query(value="origClientOrderId") String var3, @Query(value="recvWindow") Long var4, @Query(value="timestamp") Long var5);

    @Headers(value={"SIGNED: #"})
    @DELETE(value="/api/v3/order")
    public Call<CancelOrderResponse> cancelOrder(@Query(value="symbol") String var1, @Query(value="orderId") Long var2, @Query(value="origClientOrderId") String var3, @Query(value="newClientOrderId") String var4, @Query(value="recvWindow") Long var5, @Query(value="timestamp") Long var6);

    @Headers(value={"SIGNED: #"})
    @GET(value="/api/v3/openOrders")
    public Call<List<Order>> getOpenOrders(@Query(value="symbol") String var1, @Query(value="recvWindow") Long var2, @Query(value="timestamp") Long var3);

    @Headers(value={"SIGNED: #"})
    @GET(value="/api/v3/allOrders")
    public Call<List<Order>> getAllOrders(@Query(value="symbol") String var1, @Query(value="orderId") Long var2, @Query(value="limit") Integer var3, @Query(value="recvWindow") Long var4, @Query(value="timestamp") Long var5);

    @Headers(value={"SIGNED: #"})
    @POST(value="/api/v3/order/oco")
    public Call<NewOCOResponse> newOCO(@Query(value="symbol") String var1, @Query(value="listClientOrderId") String var2, @Query(value="side") OrderSide var3, @Query(value="quantity") String var4, @Query(value="limitClientOrderId") String var5, @Query(value="price") String var6, @Query(value="limitIcebergQty") String var7, @Query(value="stopClientOrderId") String var8, @Query(value="stopPrice") String var9, @Query(value="stopLimitPrice") String var10, @Query(value="stopIcebergQty") String var11, @Query(value="stopLimitTimeInForce") TimeInForce var12, @Query(value="newOrderRespType") NewOrderResponseType var13, @Query(value="recvWindow") Long var14, @Query(value="timestamp") long var15);

    @Headers(value={"SIGNED: #"})
    @DELETE(value="/api/v3/orderList")
    public Call<CancelOrderListResponse> cancelOrderList(@Query(value="symbol") String var1, @Query(value="orderListId") Long var2, @Query(value="listClientOrderId") String var3, @Query(value="newClientOrderId") String var4, @Query(value="recvWindow") Long var5, @Query(value="timestamp") Long var6);

    @Headers(value={"SIGNED: #"})
    @GET(value="/api/v3/orderList")
    public Call<OrderList> getOrderListStatus(@Query(value="orderListId") Long var1, @Query(value="origClientOrderId") String var2, @Query(value="recvWindow") Long var3, @Query(value="timestamp") Long var4);

    @Headers(value={"SIGNED: #"})
    @GET(value="/api/v3/allOrderList")
    public Call<List<OrderList>> getAllOrderList(@Query(value="fromId") Long var1, @Query(value="startTime") Long var2, @Query(value="endTime") Long var3, @Query(value="limit") Integer var4, @Query(value="recvWindow") Long var5, @Query(value="timestamp") Long var6);

    @Headers(value={"SIGNED: #"})
    @GET(value="/api/v3/account")
    public Call<Account> getAccount(@Query(value="recvWindow") Long var1, @Query(value="timestamp") Long var2);

    @Headers(value={"SIGNED: #"})
    @GET(value="/api/v3/myTrades")
    public Call<List<Trade>> getMyTrades(@Query(value="symbol") String var1, @Query(value="limit") Integer var2, @Query(value="fromId") Long var3, @Query(value="recvWindow") Long var4, @Query(value="timestamp") Long var5);

    @Headers(value={"SIGNED: #"})
    @POST(value="/wapi/v3/withdraw.html")
    public Call<WithdrawResult> withdraw(@Query(value="asset") String var1, @Query(value="address") String var2, @Query(value="amount") String var3, @Query(value="name") String var4, @Query(value="addressTag") String var5, @Query(value="recvWindow") Long var6, @Query(value="timestamp") Long var7);

    @Headers(value={"SIGNED: #"})
    @GET(value="/wapi/v3/depositHistory.html")
    public Call<DepositHistory> getDepositHistory(@Query(value="asset") String var1, @Query(value="recvWindow") Long var2, @Query(value="timestamp") Long var3);

    @Headers(value={"SIGNED: #"})
    @GET(value="/wapi/v3/withdrawHistory.html")
    public Call<WithdrawHistory> getWithdrawHistory(@Query(value="asset") String var1, @Query(value="recvWindow") Long var2, @Query(value="timestamp") Long var3);

    @Headers(value={"SIGNED: #"})
    @GET(value="/wapi/v3/depositAddress.html")
    public Call<DepositAddress> getDepositAddress(@Query(value="asset") String var1, @Query(value="recvWindow") Long var2, @Query(value="timestamp") Long var3);

    @Headers(value={"SIGNED: #"})
    @POST(value="/sapi/v1/asset/dust")
    public Call<DustTransferResponse> dustTransfer(@Query(value="asset") List<String> var1, @Query(value="recvWindow") Long var2, @Query(value="timestamp") Long var3);

    @Headers(value={"SIGNED: #"})
    @GET(value="/sapi/v1/sub-account/transfer/subUserHistory")
    public Call<List<SubAccountTransfer>> getSubAccountTransfers(@Query(value="timestamp") Long var1);

    @Headers(value={"APIKEY: #"})
    @POST(value="/api/v1/userDataStream")
    public Call<ListenKey> startUserDataStream();

    @Headers(value={"APIKEY: #"})
    @PUT(value="/api/v1/userDataStream")
    public Call<Void> keepAliveUserDataStream(@Query(value="listenKey") String var1);

    @Headers(value={"APIKEY: #"})
    @DELETE(value="/api/v1/userDataStream")
    public Call<Void> closeAliveUserDataStream(@Query(value="listenKey") String var1);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @POST(value="/sapi/v1/margin/transfer")
    public Call<MarginTransaction> transfer(@Query(value="asset") String var1, @Query(value="amount") String var2, @Query(value="type") String var3, @Query(value="recvWindow") Long var4, @Query(value="timestamp") Long var5);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @POST(value="/sapi/v1/margin/loan")
    public Call<MarginTransaction> borrow(@Query(value="asset") String var1, @Query(value="amount") String var2, @Query(value="recvWindow") Long var3, @Query(value="timestamp") Long var4);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @GET(value="/sapi/v1/margin/loan")
    public Call<LoanQueryResult> queryLoan(@Query(value="asset") String var1, @Query(value="txId") String var2, @Query(value="timestamp") Long var3);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @GET(value="/sapi/v1/margin/repay")
    public Call<RepayQueryResult> queryRepay(@Query(value="asset") String var1, @Query(value="txId") String var2, @Query(value="timestamp") Long var3);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @GET(value="/sapi/v1/margin/maxBorrowable")
    public Call<MaxBorrowableQueryResult> queryMaxBorrowable(@Query(value="asset") String var1, @Query(value="timestamp") Long var2);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @GET(value="/sapi/v1/margin/repay")
    public Call<RepayQueryResult> queryRepay(@Query(value="asset") String var1, @Query(value="startTime") Long var2, @Query(value="timestamp") Long var3);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @POST(value="/sapi/v1/margin/repay")
    public Call<MarginTransaction> repay(@Query(value="asset") String var1, @Query(value="amount") String var2, @Query(value="recvWindow") Long var3, @Query(value="timestamp") Long var4);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @GET(value="/sapi/v1/margin/account")
    public Call<MarginAccount> getMarginAccount(@Query(value="recvWindow") Long var1, @Query(value="timestamp") Long var2);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @GET(value="/sapi/v1/margin/openOrders")
    public Call<List<Order>> getOpenMarginOrders(@Query(value="symbol") String var1, @Query(value="recvWindow") Long var2, @Query(value="timestamp") Long var3);

    @Headers(value={"SIGNED: #"})
    @POST(value="/sapi/v1/margin/order")
    public Call<MarginNewOrderResponse> newMarginOrder(@Query(value="symbol") String var1, @Query(value="side") OrderSide var2, @Query(value="type") OrderType var3, @Query(value="timeInForce") TimeInForce var4, @Query(value="quantity") String var5, @Query(value="price") String var6, @Query(value="newClientOrderId") String var7, @Query(value="stopPrice") String var8, @Query(value="icebergQty") String var9, @Query(value="newOrderRespType") NewOrderResponseType var10, @Query(value="sideEffectType") SideEffectType var11, @Query(value="recvWindow") Long var12, @Query(value="timestamp") Long var13);

    @Headers(value={"SIGNED: #"})
    @DELETE(value="/sapi/v1/margin/order")
    public Call<CancelOrderResponse> cancelMarginOrder(@Query(value="symbol") String var1, @Query(value="orderId") Long var2, @Query(value="origClientOrderId") String var3, @Query(value="newClientOrderId") String var4, @Query(value="recvWindow") Long var5, @Query(value="timestamp") Long var6);

    @Headers(value={"SIGNED: #"})
    @GET(value="/sapi/v1/margin/order")
    public Call<Order> getMarginOrderStatus(@Query(value="symbol") String var1, @Query(value="orderId") Long var2, @Query(value="origClientOrderId") String var3, @Query(value="recvWindow") Long var4, @Query(value="timestamp") Long var5);

    @Headers(value={"SIGNED: #"})
    @GET(value="/sapi/v1/margin/myTrades")
    public Call<List<Trade>> getMyMarginTrades(@Query(value="symbol") String var1, @Query(value="limit") Integer var2, @Query(value="fromId") Long var3, @Query(value="recvWindow") Long var4, @Query(value="timestamp") Long var5);

    @Headers(value={"APIKEY: #"})
    @POST(value="/sapi/v1/userDataStream")
    public Call<ListenKey> startMarginUserDataStream();

    @Headers(value={"APIKEY: #"})
    @PUT(value="/sapi/v1/userDataStream")
    public Call<Void> keepAliveMarginUserDataStream(@Query(value="listenKey") String var1);

    @Headers(value={"APIKEY: #"})
    @GET(value="/sapi/v1/bswap/pools")
    public Call<List<Pool>> listAllSwapPools();

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @GET(value="/sapi/v1/bswap/liquidity")
    public Call<List<Liquidity>> getPoolLiquidityInfo(@Query(value="poolId") String var1, @Query(value="recvWindow") Long var2, @Query(value="timestamp") Long var3);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @POST(value="/sapi/v1/bswap/liquidityAdd")
    public Call<LiquidityOperationRecord> addLiquidity(@Query(value="poolId") String var1, @Query(value="asset") String var2, @Query(value="quantity") String var3, @Query(value="recvWindow") Long var4, @Query(value="timestamp") Long var5);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @POST(value="/sapi/v1/bswap/liquidityRemove")
    public Call<LiquidityOperationRecord> removeLiquidity(@Query(value="poolId") String var1, @Query(value="type") SwapRemoveType var2, @Query(value="asset") List<String> var3, @Query(value="shareAmount") String var4, @Query(value="recvWindow") Long var5, @Query(value="timestamp") Long var6);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @GET(value="/sapi/v1/bswap/liquidityOps")
    public Call<List<LiquidityOperationRecord>> getPoolLiquidityOperationRecords(@Query(value="poolId") String var1, @Query(value="limit") Integer var2, @Query(value="recvWindow") Long var3, @Query(value="timestamp") Long var4);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @GET(value="/sapi/v1/bswap/liquidityOps")
    public Call<List<LiquidityOperationRecord>> getLiquidityOperationRecord(@Query(value="operationId") String var1, @Query(value="recvWindow") Long var2, @Query(value="timestamp") Long var3);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @GET(value="/sapi/v1/bswap/quote")
    public Call<SwapQuote> requestQuote(@Query(value="quoteAsset") String var1, @Query(value="baseAsset") String var2, @Query(value="quoteQty") String var3, @Query(value="recvWindow") Long var4, @Query(value="timestamp") Long var5);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @POST(value="/sapi/v1/bswap/swap")
    public Call<SwapRecord> swap(@Query(value="quoteAsset") String var1, @Query(value="baseAsset") String var2, @Query(value="quoteQty") String var3, @Query(value="recvWindow") Long var4, @Query(value="timestamp") Long var5);

    @Headers(value={"APIKEY: #", "SIGNED: #"})
    @GET(value="/sapi/v1/bswap/swap")
    public Call<List<SwapHistory>> getSwapHistory(@Query(value="swapId") String var1, @Query(value="recvWindow") Long var2, @Query(value="timestamp") Long var3);
}

