/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.domain.event;

import com.binance.api.client.constant.BinanceApiConstants;
import com.binance.api.client.domain.event.AccountUpdateEvent;
import com.binance.api.client.domain.event.BalanceUpdateEvent;
import com.binance.api.client.domain.event.OrderTradeUpdateEvent;
import com.binance.api.client.domain.event.UserDataUpdateEventDeserializer;
import com.binance.api.client.exception.UnsupportedEventException;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(using=UserDataUpdateEventDeserializer.class)
public class UserDataUpdateEvent {
    private UserDataUpdateEventType eventType;
    private long eventTime;
    private AccountUpdateEvent outboundAccountPositionUpdateEvent;
    private BalanceUpdateEvent balanceUpdateEvent;
    private OrderTradeUpdateEvent orderTradeUpdateEvent;

    public UserDataUpdateEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(UserDataUpdateEventType eventType) {
        this.eventType = eventType;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(long eventTime) {
        this.eventTime = eventTime;
    }

    @Deprecated
    public AccountUpdateEvent getAccountUpdateEvent() {
        return this.outboundAccountPositionUpdateEvent;
    }

    public AccountUpdateEvent getOutboundAccountPositionUpdateEvent() {
        return this.outboundAccountPositionUpdateEvent;
    }

    public void setOutboundAccountPositionUpdateEvent(AccountUpdateEvent accountUpdateEvent) {
        this.outboundAccountPositionUpdateEvent = accountUpdateEvent;
    }

    public BalanceUpdateEvent getBalanceUpdateEvent() {
        return this.balanceUpdateEvent;
    }

    public void setBalanceUpdateEvent(BalanceUpdateEvent balanceUpdateEvent) {
        this.balanceUpdateEvent = balanceUpdateEvent;
    }

    public OrderTradeUpdateEvent getOrderTradeUpdateEvent() {
        return this.orderTradeUpdateEvent;
    }

    public void setOrderTradeUpdateEvent(OrderTradeUpdateEvent orderTradeUpdateEvent) {
        this.orderTradeUpdateEvent = orderTradeUpdateEvent;
    }

    public String toString() {
        ToStringBuilder sb = new ToStringBuilder((Object)this, BinanceApiConstants.TO_STRING_BUILDER_STYLE).append("eventType", (Object)this.eventType).append("eventTime", this.eventTime);
        if (this.eventType == UserDataUpdateEventType.ACCOUNT_POSITION_UPDATE) {
            sb.append("outboundAccountPositionUpdateEvent", (Object)this.outboundAccountPositionUpdateEvent);
        } else if (this.eventType == UserDataUpdateEventType.BALANCE_UPDATE) {
            sb.append("balanceUpdateEvent", (Object)this.balanceUpdateEvent);
        } else {
            sb.append("orderTradeUpdateEvent", (Object)this.orderTradeUpdateEvent);
        }
        return sb.toString();
    }

    public static enum UserDataUpdateEventType {
        ACCOUNT_POSITION_UPDATE("outboundAccountPosition"),
        BALANCE_UPDATE("balanceUpdate"),
        ORDER_TRADE_UPDATE("executionReport");

        private final String eventTypeId;

        private UserDataUpdateEventType(String eventTypeId) {
            this.eventTypeId = eventTypeId;
        }

        public String getEventTypeId() {
            return this.eventTypeId;
        }

        public static UserDataUpdateEventType fromEventTypeId(String eventTypeId) {
            if (UserDataUpdateEventType.ORDER_TRADE_UPDATE.eventTypeId.equals(eventTypeId)) {
                return ORDER_TRADE_UPDATE;
            }
            if (UserDataUpdateEventType.ACCOUNT_POSITION_UPDATE.eventTypeId.equals(eventTypeId)) {
                return ACCOUNT_POSITION_UPDATE;
            }
            if (UserDataUpdateEventType.BALANCE_UPDATE.eventTypeId.equals(eventTypeId)) {
                return BALANCE_UPDATE;
            }
            throw new UnsupportedEventException("Unrecognized user data update event type id: " + eventTypeId);
        }
    }
}

