/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.lang.ref.SoftReference;

public abstract class SoftThreadLocal<T> {
    private final ThreadLocal<SoftReference<T>> threadLocal = ThreadLocal.withInitial(() -> new SoftReference<T>(this.create()));

    public synchronized T get() {
        T item = this.threadLocal.get().get();
        if (item == null) {
            item = this.create();
            this.threadLocal.set(new SoftReference<T>(item));
        }
        return item;
    }

    public void set(T item) {
        this.threadLocal.set(new SoftReference<T>(item));
    }

    protected abstract T create();
}

