/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Parcel;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import dalvik.system.CloseGuard;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;

@Implements(value=SurfaceControl.class, isInAndroidSdk=false, minSdk=18)
public class ShadowSurfaceControl {
    private static final AtomicInteger nativeObject = new AtomicInteger();
    @ReflectorObject
    private SurfaceControlReflector surfaceControlReflector;

    @Resetter
    public static void reset() {
        nativeObject.set(0);
    }

    @Implementation
    protected void finalize() throws Throwable {
        CloseGuard closeGuard = this.surfaceControlReflector.getCloseGuard();
        if (closeGuard != null) {
            closeGuard.close();
        }
        this.surfaceControlReflector.finalize();
    }

    @Implementation(maxSdk=25)
    protected static Number nativeCreate(SurfaceSession session, String name, int w, int h, int format, int flags) {
        return nativeObject.incrementAndGet();
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static long nativeCreate(SurfaceSession session, String name, int w, int h, int format, int flags, long parentObject, int windowType, int ownerUid) {
        return nativeObject.incrementAndGet();
    }

    @Implementation(minSdk=29)
    protected static long nativeCreate(SurfaceSession session, String name, int w, int h, int format, int flags, long parentObject, Parcel metadata) {
        return nativeObject.incrementAndGet();
    }

    void initializeNativeObject() {
        this.surfaceControlReflector.setNativeObject(nativeObject.incrementAndGet());
    }

    @ForType(value=SurfaceControl.class)
    static interface SurfaceControlReflector {
        @Accessor(value="mCloseGuard")
        public CloseGuard getCloseGuard();

        @Accessor(value="mNativeObject")
        public void setNativeObject(long var1);

        @Direct
        public void finalize();
    }
}

