/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;

@Implements(value=Toast.class)
public class ShadowToast {
    private String text;
    private int duration;
    private int gravity;
    private int xOffset;
    private int yOffset;
    private View view;
    private boolean cancelled;
    @RealObject
    Toast toast;

    @Implementation
    protected void __constructor__(Context context) {
    }

    @Implementation
    protected static Toast makeText(Context context, int resId, int duration) {
        return ShadowToast.makeText(context, context.getResources().getString(resId), duration);
    }

    @Implementation
    protected static Toast makeText(Context context, CharSequence text, int duration) {
        Toast toast = new Toast(context);
        toast.setDuration(duration);
        ShadowToast shadowToast = (ShadowToast)Shadow.extract((Object)toast);
        shadowToast.text = text.toString();
        return toast;
    }

    @Implementation
    protected void show() {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.getApplication());
        shadowApplication.getShownToasts().add(this.toast);
    }

    @Implementation
    protected void setText(int resId) {
        this.text = RuntimeEnvironment.getApplication().getString(resId);
    }

    @Implementation
    protected void setText(CharSequence text) {
        this.text = text.toString();
    }

    @Implementation
    protected void setView(View view) {
        this.view = view;
    }

    @Implementation
    protected View getView() {
        return this.view;
    }

    @Implementation
    protected void setGravity(int gravity, int xOffset, int yOffset) {
        this.gravity = gravity;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    @Implementation
    protected int getGravity() {
        return this.gravity;
    }

    @Implementation
    protected int getXOffset() {
        return this.xOffset;
    }

    @Implementation
    protected int getYOffset() {
        return this.yOffset;
    }

    @Implementation
    protected void setDuration(int duration) {
        this.duration = duration;
    }

    @Implementation
    protected int getDuration() {
        return this.duration;
    }

    @Implementation
    protected void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public static void reset() {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.getApplication());
        shadowApplication.getShownToasts().clear();
    }

    public static int shownToastCount() {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.getApplication());
        return shadowApplication.getShownToasts().size();
    }

    public static boolean showedCustomToast(CharSequence message, int layoutResourceIdToCheckForMessage) {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.getApplication());
        for (Toast toast : shadowApplication.getShownToasts()) {
            String text = ((TextView)toast.getView().findViewById(layoutResourceIdToCheckForMessage)).getText().toString();
            if (!text.equals(message.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean showedToast(CharSequence message) {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.getApplication());
        for (Toast toast : shadowApplication.getShownToasts()) {
            ShadowToast shadowToast = (ShadowToast)Shadow.extract((Object)toast);
            String text = shadowToast.text;
            if (text == null || !text.equals(message.toString())) continue;
            return true;
        }
        return false;
    }

    public static String getTextOfLatestToast() {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.getApplication());
        List<Toast> shownToasts = shadowApplication.getShownToasts();
        if (shownToasts.isEmpty()) {
            return null;
        }
        Toast latestToast = shownToasts.get(shownToasts.size() - 1);
        ShadowToast shadowToast = (ShadowToast)Shadow.extract((Object)latestToast);
        return shadowToast.text;
    }

    public static Toast getLatestToast() {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.getApplication());
        List<Toast> shownToasts = shadowApplication.getShownToasts();
        return shownToasts.size() == 0 ? null : shownToasts.get(shownToasts.size() - 1);
    }
}

