/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioAttributes;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemVibrator;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.vibrator.VibrationEffectSegment;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowVibrator;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SystemVibrator.class, isInAndroidSdk=false)
public class ShadowSystemVibrator
extends ShadowVibrator {
    private Handler handler = new Handler(Looper.myLooper());
    private Runnable stopVibratingRunnable = () -> {
        this.vibrating = false;
    };

    @Implementation
    protected boolean hasVibrator() {
        return this.hasVibrator;
    }

    @Implementation(minSdk=26)
    protected boolean hasAmplitudeControl() {
        return this.hasAmplitudeControl;
    }

    @Implementation(maxSdk=17)
    protected void vibrate(long[] pattern, int repeat) {
        this.recordVibratePattern(pattern, repeat);
    }

    @Implementation(minSdk=18, maxSdk=20)
    protected void vibrate(int owningUid, String owningPackage, long[] pattern, int repeat) {
        this.recordVibratePattern(pattern, repeat);
    }

    @Implementation(minSdk=21, maxSdk=25)
    protected void vibrate(int uid, String opPkg, long[] pattern, int repeat, AudioAttributes attributes) {
        this.recordVibratePattern(pattern, repeat);
    }

    @Implementation(maxSdk=17)
    public void vibrate(long milliseconds) {
        this.recordVibrate(milliseconds);
    }

    @Implementation(minSdk=18, maxSdk=20)
    public void vibrate(int owningUid, String owningPackage, long milliseconds) {
        this.recordVibrate(milliseconds);
    }

    @Implementation(minSdk=21, maxSdk=25)
    protected void vibrate(int uid, String opPkg, long milliseconds, AudioAttributes attributes) {
        this.recordVibrate(milliseconds);
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected void vibrate(int uid, String opPkg, VibrationEffect effect, AudioAttributes attributes) {
        this.vibrate(uid, opPkg, effect, null, attributes);
    }

    @Implementation(minSdk=29, maxSdk=30)
    protected void vibrate(int uid, String opPkg, VibrationEffect effect, String reason, AudioAttributes attributes) {
        block5: {
            try {
                Class<?> waveformClass = Class.forName("android.os.VibrationEffect$Waveform");
                Class<?> prebakedClass = Class.forName("android.os.VibrationEffect$Prebaked");
                Class<?> oneShotClass = Class.forName("android.os.VibrationEffect$OneShot");
                if (waveformClass.isInstance(effect)) {
                    this.recordVibratePattern((long[])ReflectionHelpers.callInstanceMethod((Object)effect, (String)"getTimings", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]), (int)((Integer)ReflectionHelpers.callInstanceMethod((Object)effect, (String)"getRepeatIndex", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0])));
                    break block5;
                }
                if (prebakedClass.isInstance(effect)) {
                    this.recordVibratePredefined((Long)ReflectionHelpers.callInstanceMethod((Object)effect, (String)"getDuration", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]), (Integer)ReflectionHelpers.callInstanceMethod((Object)effect, (String)"getId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
                    break block5;
                }
                if (oneShotClass.isInstance(effect)) {
                    long timing = RuntimeEnvironment.getApiLevel() >= 28 ? ((Long)ReflectionHelpers.callInstanceMethod((Object)effect, (String)"getDuration", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0])).longValue() : ((Long)ReflectionHelpers.callInstanceMethod((Object)effect, (String)"getTiming", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0])).longValue();
                    this.recordVibrate(timing);
                    break block5;
                }
                String string = String.valueOf(effect.getClass().getName());
                throw new UnsupportedOperationException(string.length() != 0 ? "unrecognized effect type ".concat(string) : new String("unrecognized effect type "));
            }
            catch (ClassNotFoundException e) {
                String string = String.valueOf(effect.getClass().getName());
                throw new UnsupportedOperationException(string.length() != 0 ? "unrecognized effect type ".concat(string) : new String("unrecognized effect type "), e);
            }
        }
    }

    @Implementation(minSdk=31)
    protected void vibrate(int uid, String opPkg, VibrationEffect effect, String reason, VibrationAttributes attributes) {
        if (!(effect instanceof VibrationEffect.Composed)) {
            String string = String.valueOf(effect.getClass().getName());
            throw new UnsupportedOperationException(string.length() != 0 ? "unrecognized effect type ".concat(string) : new String("unrecognized effect type "));
        }
        VibrationEffect.Composed composedEffect = (VibrationEffect.Composed)effect;
        this.recordVibratePattern(composedEffect.getSegments(), composedEffect.getRepeatIndex());
    }

    private void recordVibratePattern(List<VibrationEffectSegment> segments, int repeatIndex) {
        long[] pattern = new long[segments.size()];
        int i = 0;
        for (VibrationEffectSegment segment : segments) {
            pattern[i] = segment.getDuration();
            ++i;
        }
        this.recordVibratePattern(pattern, repeatIndex);
    }

    private void recordVibratePredefined(long milliseconds, int effectId) {
        this.vibrating = true;
        this.effectId = effectId;
        this.milliseconds = milliseconds;
        this.handler.removeCallbacks(this.stopVibratingRunnable);
        this.handler.postDelayed(this.stopVibratingRunnable, this.milliseconds);
    }

    private void recordVibrate(long milliseconds) {
        this.vibrating = true;
        this.milliseconds = milliseconds;
        this.handler.removeCallbacks(this.stopVibratingRunnable);
        this.handler.postDelayed(this.stopVibratingRunnable, this.milliseconds);
    }

    protected void recordVibratePattern(long[] pattern, int repeat) {
        this.vibrating = true;
        this.pattern = pattern;
        this.repeat = repeat;
        this.handler.removeCallbacks(this.stopVibratingRunnable);
        if (repeat < 0) {
            long endDelayMillis = 0L;
            for (long t : pattern) {
                endDelayMillis += t;
            }
            this.milliseconds = endDelayMillis;
            this.handler.postDelayed(this.stopVibratingRunnable, endDelayMillis);
        }
    }

    @Implementation
    protected void cancel() {
        this.cancelled = true;
        this.vibrating = false;
        this.handler.removeCallbacks(this.stopVibratingRunnable);
    }
}

