/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.os.ParcelFileDescriptor;
import android.util.ArraySet;
import android.util.SparseArray;
import android.util.TypedValue;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.Fs;
import org.robolectric.res.android.ApkAssetsCookie;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.AssetDir;
import org.robolectric.res.android.AssetPath;
import org.robolectric.res.android.AttributeResolution10;
import org.robolectric.res.android.CppApkAssets;
import org.robolectric.res.android.CppAssetManager;
import org.robolectric.res.android.CppAssetManager2;
import org.robolectric.res.android.DynamicRefTable;
import org.robolectric.res.android.Ref;
import org.robolectric.res.android.Registries;
import org.robolectric.res.android.ResStringPool;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.android.ResXMLParser;
import org.robolectric.res.android.ResXMLTree;
import org.robolectric.res.android.ResourceTypes;
import org.robolectric.res.android.Util;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowArscApkAssets9;
import org.robolectric.shadows.ShadowAssetManager;
import org.robolectric.shadows.ShadowVMRuntime;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=AssetManager.class, minSdk=29, shadowPicker=ShadowAssetManager.Picker.class)
public class ShadowArscAssetManager10
extends ShadowAssetManager.ArscBase {
    private static final int STYLE_NUM_ENTRIES = 7;
    private static final int STYLE_TYPE = 0;
    private static final int STYLE_DATA = 1;
    private static final int STYLE_ASSET_COOKIE = 2;
    private static final int STYLE_RESOURCE_ID = 3;
    private static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    private static final int STYLE_DENSITY = 5;
    private static final int STYLE_SOURCE_STYLE_RESOURCE_ID = 6;
    private static CppAssetManager2 systemCppAssetManager2;
    private static long systemCppAssetManager2Ref;
    private static boolean inNonSystemConstructor;
    private static ApkAssets[] cachedSystemApkAssets;
    private static ArraySet<ApkAssets> cachedSystemApkAssetsSet;
    @RealObject
    AssetManager realAssetManager;

    @Implementation(maxSdk=29)
    protected static void createSystemAssetsInZygoteLocked() {
        ShadowAssetManager._AssetManager28_ _assetManagerStatic_ = (ShadowAssetManager._AssetManager28_)Reflector.reflector(ShadowAssetManager._AssetManager28_.class);
        AssetManager sSystem = _assetManagerStatic_.getSystem();
        if (sSystem != null) {
            return;
        }
        if (systemCppAssetManager2 == null) {
            ((AssetManagerReflector)Reflector.reflector(AssetManagerReflector.class)).createSystemAssetsInZygoteLocked();
            cachedSystemApkAssets = _assetManagerStatic_.getSystemApkAssets();
            cachedSystemApkAssetsSet = _assetManagerStatic_.getSystemApkAssetsSet();
        } else {
            _assetManagerStatic_.setSystemApkAssets(cachedSystemApkAssets);
            _assetManagerStatic_.setSystemApkAssetsSet(cachedSystemApkAssetsSet);
            sSystem = (AssetManager)ReflectionHelpers.callConstructor(AssetManager.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)true)});
            sSystem.setApkAssets(cachedSystemApkAssets, false);
            ReflectionHelpers.setStaticField(AssetManager.class, (String)"sSystem", (Object)sSystem);
        }
    }

    @Resetter
    public static void reset() {
        if (!ShadowArscAssetManager10.useLegacy() && RuntimeEnvironment.getApiLevel() >= 28) {
            ShadowAssetManager._AssetManager28_ _assetManagerStatic_ = (ShadowAssetManager._AssetManager28_)Reflector.reflector(ShadowAssetManager._AssetManager28_.class);
            _assetManagerStatic_.setSystemApkAssetsSet(null);
            _assetManagerStatic_.setSystemApkAssets(null);
            _assetManagerStatic_.setSystem(null);
        }
    }

    static int ApkAssetsCookieToJavaCookie(ApkAssetsCookie cookie) {
        return cookie.intValue() != -1 ? cookie.intValue() + 1 : -1;
    }

    static ApkAssetsCookie JavaCookieToApkAssetsCookie(int cookie) {
        return ApkAssetsCookie.forInt((int)(cookie > 0 ? cookie - 1 : -1));
    }

    @Implementation(minSdk=28, maxSdk=29)
    protected static void nativeVerifySystemIdmaps() {
    }

    @Implementation(minSdk=29, maxSdk=30)
    protected static String[] nativeCreateIdmapsForStaticOverlaysTargetingAndroid() {
        return new String[0];
    }

    static int CopyValue(ApkAssetsCookie cookie, ResourceTypes.Res_value value, int ref, int type_spec_flags, ResTable_config config, TypedValue out_typed_value) {
        out_typed_value.type = value.dataType;
        out_typed_value.assetCookie = ShadowArscAssetManager10.ApkAssetsCookieToJavaCookie(cookie);
        out_typed_value.data = value.data;
        out_typed_value.string = null;
        out_typed_value.resourceId = ref;
        out_typed_value.changingConfigurations = type_spec_flags;
        if (config != null) {
            out_typed_value.density = config.density;
        }
        return ShadowArscAssetManager10.ApkAssetsCookieToJavaCookie(cookie);
    }

    @Override
    Collection<Path> getAllAssetDirs() {
        ApkAssets[] apkAssetsArray = ((ShadowAssetManager._AssetManager28_)Reflector.reflector(ShadowAssetManager._AssetManager28_.class, (Object)this.realAssetManager)).getApkAssets();
        ArrayList<Path> assetDirs = new ArrayList<Path>();
        for (ApkAssets apkAssets : apkAssetsArray) {
            long apk_assets_native_ptr = ((ShadowArscApkAssets9)Shadow.extract((Object)apkAssets)).getNativePtr();
            CppApkAssets cppApkAssets = (CppApkAssets)Registries.NATIVE_APK_ASSETS_REGISTRY.getNativeObject(apk_assets_native_ptr);
            if (new File(cppApkAssets.GetPath()).isFile()) {
                assetDirs.add(Fs.forJar((Path)Paths.get(cppApkAssets.GetPath(), new String[0])).getPath("assets", new String[0]));
                continue;
            }
            assetDirs.add(Paths.get(cppApkAssets.GetPath(), new String[0]));
        }
        return assetDirs;
    }

    @Override
    List<AssetPath> getAssetPaths() {
        return ShadowArscAssetManager10.AssetManagerForJavaObject(this.realAssetManager).getAssetPaths();
    }

    static CppAssetManager2 NdkAssetManagerForJavaObject(AssetManager jassetmanager) {
        long assetmanager_handle = (Long)ReflectionHelpers.getField((Object)jassetmanager, (String)"mObject");
        CppAssetManager2 am = (CppAssetManager2)Registries.NATIVE_ASSET_MANAGER_REGISTRY.getNativeObject(assetmanager_handle);
        if (am == null) {
            throw new IllegalStateException("AssetManager has been finalized!");
        }
        return am;
    }

    static CppAssetManager2 AssetManagerForJavaObject(AssetManager jassetmanager) {
        return ShadowArscAssetManager10.NdkAssetManagerForJavaObject(jassetmanager);
    }

    static CppAssetManager2 AssetManagerFromLong(long ptr) {
        return (CppAssetManager2)Registries.NATIVE_ASSET_MANAGER_REGISTRY.getNativeObject(ptr);
    }

    static ParcelFileDescriptor ReturnParcelFileDescriptor(Asset asset, long[] out_offsets) throws FileNotFoundException {
        Ref length;
        Ref start_offset = new Ref((Object)0L);
        FileDescriptor fd = asset.openFileDescriptor(start_offset, length = new Ref((Object)0L));
        if (fd == null) {
            throw new FileNotFoundException("This file can not be opened as a file descriptor; it is probably compressed");
        }
        long[] offsets = out_offsets;
        if (offsets == null) {
            return null;
        }
        offsets[0] = (Long)start_offset.get();
        offsets[1] = (Long)length.get();
        return ParcelFileDescriptor.open((File)asset.getFile(), (int)0x10000000);
    }

    @Implementation(minSdk=28)
    protected void __constructor__(boolean sentinel) {
        inNonSystemConstructor = true;
        try {
            Shadow.invokeConstructor(AssetManager.class, (Object)this.realAssetManager, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)sentinel)});
        }
        finally {
            inNonSystemConstructor = false;
        }
    }

    @Implementation(minSdk=28)
    protected static int getGlobalAssetCount() {
        return Asset.getGlobalCount();
    }

    @Implementation(minSdk=28)
    protected static String getAssetAllocations() {
        String alloc = Asset.getAssetAllocations();
        if (alloc.length() <= 0) {
            return null;
        }
        return alloc;
    }

    @Implementation(minSdk=28)
    protected static int getGlobalAssetManagerCount() {
        return CppAssetManager.getGlobalCount();
    }

    @Implementation(minSdk=28)
    protected static long nativeCreate() {
        long cppAssetManagerRef;
        if (inNonSystemConstructor) {
            CppAssetManager2 appAssetManager = new CppAssetManager2();
            cppAssetManagerRef = Registries.NATIVE_ASSET_MANAGER_REGISTRY.register((Object)appAssetManager);
        } else {
            if (systemCppAssetManager2 == null) {
                systemCppAssetManager2 = new CppAssetManager2();
                systemCppAssetManager2Ref = Registries.NATIVE_ASSET_MANAGER_REGISTRY.register((Object)systemCppAssetManager2);
            }
            cppAssetManagerRef = systemCppAssetManager2Ref;
        }
        return cppAssetManagerRef;
    }

    @Implementation(minSdk=28)
    protected static void nativeDestroy(long ptr) {
        if (ptr == systemCppAssetManager2Ref) {
            return;
        }
        Registries.NATIVE_ASSET_MANAGER_REGISTRY.unregister(ptr);
    }

    @Implementation(minSdk=28)
    protected static void nativeSetApkAssets(long ptr, ApkAssets[] apk_assets_array, boolean invalidate_caches) {
        Util.ATRACE_NAME((String)"AssetManager::SetApkAssets");
        int apk_assets_len = apk_assets_array.length;
        ArrayList<CppApkAssets> apk_assets = new ArrayList<CppApkAssets>();
        for (int i = 0; i < apk_assets_len; ++i) {
            ApkAssets apkAssets = apk_assets_array[i];
            if (apkAssets == null) {
                throw new NullPointerException(String.format("ApkAssets at index %d is null", i));
            }
            long apk_assets_native_ptr = ((ShadowArscApkAssets9)Shadow.extract((Object)apkAssets)).getNativePtr();
            apk_assets.add((CppApkAssets)Registries.NATIVE_APK_ASSETS_REGISTRY.getNativeObject(apk_assets_native_ptr));
        }
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        assetmanager.SetApkAssets(apk_assets, invalidate_caches);
    }

    @Implementation(minSdk=28)
    protected static void nativeSetConfiguration(long ptr, int mcc, int mnc, String locale, int orientation, int touchscreen, int density, int keyboard, int keyboard_hidden, int navigation, int screen_width, int screen_height, int smallest_screen_width_dp, int screen_width_dp, int screen_height_dp, int screen_layout, int ui_mode, int color_mode, int major_version) {
        Util.ATRACE_NAME((String)"AssetManager::SetConfiguration");
        ResTable_config configuration = new ResTable_config();
        configuration.mcc = (short)mcc;
        configuration.mnc = (short)mnc;
        configuration.orientation = (byte)orientation;
        configuration.touchscreen = (byte)touchscreen;
        configuration.density = (short)density;
        configuration.keyboard = (byte)keyboard;
        configuration.inputFlags = (byte)keyboard_hidden;
        configuration.navigation = (byte)navigation;
        configuration.screenWidth = (short)screen_width;
        configuration.screenHeight = (short)screen_height;
        configuration.smallestScreenWidthDp = (short)smallest_screen_width_dp;
        configuration.screenWidthDp = (short)screen_width_dp;
        configuration.screenHeightDp = (short)screen_height_dp;
        configuration.screenLayout = (byte)screen_layout;
        configuration.uiMode = (byte)ui_mode;
        configuration.colorMode = (byte)color_mode;
        configuration.sdkVersion = (short)major_version;
        if (locale != null) {
            String locale_utf8 = locale;
            Util.CHECK((locale_utf8 != null ? 1 : 0) != 0);
            configuration.setBcp47Locale(locale_utf8);
        }
        int kScreenLayoutRoundMask = 768;
        int kScreenLayoutRoundShift = 8;
        configuration.screenLayout2 = (byte)((screen_layout & kScreenLayoutRoundMask) >> kScreenLayoutRoundShift);
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        assetmanager.SetConfiguration(configuration);
    }

    @Implementation(minSdk=28, maxSdk=29)
    protected static SparseArray<String> nativeGetAssignedPackageIdentifiers(long ptr) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        SparseArray sparse_array = new SparseArray();
        if (sparse_array == null) {
            return null;
        }
        assetmanager.ForEachPackage((package_name, package_id) -> {
            String jpackage_name = package_name;
            if (jpackage_name == null) {
                return;
            }
            sparse_array.put((int)package_id, (Object)jpackage_name);
        });
        return sparse_array;
    }

    @Implementation(minSdk=30)
    protected static SparseArray<String> nativeGetAssignedPackageIdentifiers(long ptr, boolean includeOverlays, boolean includeLoaders) {
        return ShadowArscAssetManager10.nativeGetAssignedPackageIdentifiers(ptr);
    }

    @Implementation(minSdk=28)
    protected static String[] nativeList(long ptr, String path) throws IOException {
        String path_utf8 = path;
        if (path_utf8 == null) {
            return null;
        }
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        AssetDir asset_dir = assetmanager.OpenDir(path_utf8);
        if (asset_dir == null) {
            throw new FileNotFoundException(path_utf8);
        }
        int file_count = asset_dir.getFileCount();
        String[] array = new String[file_count];
        for (int i = 0; i < file_count; ++i) {
            String java_string;
            array[i] = java_string = asset_dir.getFileName(i).string();
        }
        return array;
    }

    @Implementation(minSdk=28)
    protected static long nativeOpenAsset(long ptr, String asset_path, int access_mode) throws FileNotFoundException {
        String asset_path_utf8 = asset_path;
        if (asset_path_utf8 == null) {
            return 0L;
        }
        Util.ATRACE_NAME((String)String.format("AssetManager::OpenAsset(%s)", asset_path_utf8));
        if (access_mode != Asset.AccessMode.ACCESS_UNKNOWN.mode() && access_mode != Asset.AccessMode.ACCESS_RANDOM.mode() && access_mode != Asset.AccessMode.ACCESS_STREAMING.mode() && access_mode != Asset.AccessMode.ACCESS_BUFFER.mode()) {
            throw new IllegalArgumentException("Bad access mode");
        }
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        Asset asset = assetmanager.Open(asset_path_utf8, Asset.AccessMode.fromInt((int)access_mode));
        if (!Util.isTruthy((Object)asset)) {
            throw new FileNotFoundException(asset_path_utf8);
        }
        return Registries.NATIVE_ASSET_REGISTRY.register((Object)asset);
    }

    @Implementation(minSdk=28)
    protected static ParcelFileDescriptor nativeOpenAssetFd(long ptr, String asset_path, long[] out_offsets) throws IOException {
        String asset_path_utf8 = asset_path;
        if (asset_path_utf8 == null) {
            return null;
        }
        Util.ATRACE_NAME((String)String.format("AssetManager::OpenAssetFd(%s)", asset_path_utf8));
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        Asset asset = assetmanager.Open(asset_path_utf8, Asset.AccessMode.ACCESS_RANDOM);
        if (!Util.isTruthy((Object)asset)) {
            throw new FileNotFoundException(asset_path_utf8);
        }
        return ShadowArscAssetManager10.ReturnParcelFileDescriptor(asset, out_offsets);
    }

    @Implementation(minSdk=28)
    protected static long nativeOpenNonAsset(long ptr, int jcookie, String asset_path, int access_mode) throws FileNotFoundException {
        ApkAssetsCookie cookie = ShadowArscAssetManager10.JavaCookieToApkAssetsCookie(jcookie);
        String asset_path_utf8 = asset_path;
        if (asset_path_utf8 == null) {
            return 0L;
        }
        Util.ATRACE_NAME((String)String.format("AssetManager::OpenNonAsset(%s)", asset_path_utf8));
        if (access_mode != Asset.AccessMode.ACCESS_UNKNOWN.mode() && access_mode != Asset.AccessMode.ACCESS_RANDOM.mode() && access_mode != Asset.AccessMode.ACCESS_STREAMING.mode() && access_mode != Asset.AccessMode.ACCESS_BUFFER.mode()) {
            throw new IllegalArgumentException("Bad access mode");
        }
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        Asset asset = cookie.intValue() != -1 ? assetmanager.OpenNonAsset(asset_path_utf8, cookie, Asset.AccessMode.fromInt((int)access_mode)) : assetmanager.OpenNonAsset(asset_path_utf8, Asset.AccessMode.fromInt((int)access_mode));
        if (!Util.isTruthy((Object)asset)) {
            throw new FileNotFoundException(asset_path_utf8);
        }
        return Registries.NATIVE_ASSET_REGISTRY.register((Object)asset);
    }

    @Implementation(minSdk=28)
    protected static ParcelFileDescriptor nativeOpenNonAssetFd(long ptr, int jcookie, String asset_path, long[] out_offsets) throws IOException {
        ApkAssetsCookie cookie = ShadowArscAssetManager10.JavaCookieToApkAssetsCookie(jcookie);
        String asset_path_utf8 = asset_path;
        if (asset_path_utf8 == null) {
            return null;
        }
        Util.ATRACE_NAME((String)String.format("AssetManager::OpenNonAssetFd(%s)", asset_path_utf8));
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        Asset asset = cookie.intValue() != -1 ? assetmanager.OpenNonAsset(asset_path_utf8, cookie, Asset.AccessMode.ACCESS_RANDOM) : assetmanager.OpenNonAsset(asset_path_utf8, Asset.AccessMode.ACCESS_RANDOM);
        if (!Util.isTruthy((Object)asset)) {
            throw new FileNotFoundException(asset_path_utf8);
        }
        return ShadowArscAssetManager10.ReturnParcelFileDescriptor(asset, out_offsets);
    }

    @Implementation(minSdk=28)
    protected static long nativeOpenXmlAsset(long ptr, int jcookie, String asset_path) throws FileNotFoundException {
        Asset asset;
        ApkAssetsCookie cookie = ShadowArscAssetManager10.JavaCookieToApkAssetsCookie(jcookie);
        String asset_path_utf8 = asset_path;
        if (asset_path_utf8 == null) {
            return 0L;
        }
        Util.ATRACE_NAME((String)String.format("AssetManager::OpenXmlAsset(%s)", asset_path_utf8));
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        if (cookie.intValue() != -1) {
            asset = assetmanager.OpenNonAsset(asset_path_utf8, cookie, Asset.AccessMode.ACCESS_RANDOM);
        } else {
            Ref cookieRef = new Ref((Object)cookie);
            asset = assetmanager.OpenNonAsset(asset_path_utf8, Asset.AccessMode.ACCESS_RANDOM, cookieRef);
            cookie = (ApkAssetsCookie)cookieRef.get();
        }
        if (!Util.isTruthy((Object)asset)) {
            throw new FileNotFoundException(asset_path_utf8);
        }
        DynamicRefTable dynamic_ref_table = assetmanager.GetDynamicRefTableForCookie(cookie);
        ResXMLTree xml_tree = new ResXMLTree(dynamic_ref_table);
        int err = xml_tree.setTo(asset.getBuffer(true), (int)asset.getLength(), true);
        if (err != 0) {
            throw new FileNotFoundException("Corrupt XML binary file");
        }
        return Registries.NATIVE_RES_XML_TREES.register((Object)xml_tree);
    }

    @Implementation(minSdk=28)
    protected static int nativeGetResourceValue(long ptr, int resid, short density, TypedValue typed_value, boolean resolve_references) {
        Ref flags;
        Ref selected_config;
        Ref value;
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        ApkAssetsCookie cookie = assetmanager.GetResource(resid, false, density, value = new Ref(null), selected_config = new Ref(null), flags = new Ref((Object)0));
        if (cookie.intValue() == -1) {
            return ShadowArscAssetManager10.ApkAssetsCookieToJavaCookie(ApkAssetsCookie.K_INVALID_COOKIE);
        }
        Ref ref = new Ref((Object)resid);
        if (resolve_references && (cookie = assetmanager.ResolveReference(cookie, value, selected_config, flags, ref)).intValue() == -1) {
            return ShadowArscAssetManager10.ApkAssetsCookieToJavaCookie(ApkAssetsCookie.K_INVALID_COOKIE);
        }
        return ShadowArscAssetManager10.CopyValue(cookie, (ResourceTypes.Res_value)value.get(), (Integer)ref.get(), (Integer)flags.get(), (ResTable_config)selected_config.get(), typed_value);
    }

    @Implementation(minSdk=28)
    protected static int nativeGetResourceBagValue(long ptr, int resid, int bag_entry_id, TypedValue typed_value) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        CppAssetManager2.ResolvedBag bag = assetmanager.GetBag(resid);
        if (bag == null) {
            return ShadowArscAssetManager10.ApkAssetsCookieToJavaCookie(ApkAssetsCookie.K_INVALID_COOKIE);
        }
        Ref type_spec_flags = new Ref((Object)bag.type_spec_flags);
        ApkAssetsCookie cookie = ApkAssetsCookie.K_INVALID_COOKIE;
        ResourceTypes.Res_value bag_value = null;
        for (CppAssetManager2.ResolvedBag.Entry entry : bag.entries) {
            if (entry.key != bag_entry_id) continue;
            cookie = entry.cookie;
            bag_value = entry.value;
        }
        if (cookie.intValue() == -1) {
            return ShadowArscAssetManager10.ApkAssetsCookieToJavaCookie(ApkAssetsCookie.K_INVALID_COOKIE);
        }
        Ref value = new Ref(bag_value);
        Ref selected_config = new Ref(null);
        Ref ref = new Ref((Object)resid);
        if ((cookie = assetmanager.ResolveReference(cookie, value, selected_config, type_spec_flags, ref)).intValue() == -1) {
            return ShadowArscAssetManager10.ApkAssetsCookieToJavaCookie(ApkAssetsCookie.K_INVALID_COOKIE);
        }
        return ShadowArscAssetManager10.CopyValue(cookie, (ResourceTypes.Res_value)value.get(), (Integer)ref.get(), (Integer)type_spec_flags.get(), null, typed_value);
    }

    @Implementation(minSdk=28)
    protected static int[] nativeGetStyleAttributes(long ptr, int resid) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        CppAssetManager2.ResolvedBag bag = assetmanager.GetBag(resid);
        if (bag == null) {
            return null;
        }
        int[] array = new int[bag.entry_count];
        for (int i = 0; i < bag.entry_count; ++i) {
            int attr_resid;
            array[i] = attr_resid = bag.entries[i].key;
        }
        return array;
    }

    @Implementation(minSdk=28)
    protected static String[] nativeGetResourceStringArray(long ptr, int resid) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        CppAssetManager2.ResolvedBag bag = assetmanager.GetBag(resid);
        if (bag == null) {
            return null;
        }
        String[] array = new String[bag.entry_count];
        if (array == null) {
            return null;
        }
        for (int i = 0; i < bag.entry_count; ++i) {
            String str_utf16;
            Ref ref;
            CppAssetManager2.ResolvedBag.Entry entry = bag.entries[i];
            Ref value = new Ref((Object)entry.value);
            Ref selected_config = new Ref(null);
            Ref flags = new Ref((Object)0);
            ApkAssetsCookie cookie = assetmanager.ResolveReference(entry.cookie, value, selected_config, flags, ref = new Ref((Object)0));
            if (cookie.intValue() == -1) {
                return null;
            }
            if (((ResourceTypes.Res_value)value.get()).dataType != 3) continue;
            CppApkAssets apk_assets = (CppApkAssets)assetmanager.GetApkAssets().get(cookie.intValue());
            ResStringPool pool = apk_assets.GetLoadedArsc().GetStringPool();
            String java_string = null;
            String str_utf8 = pool.stringAt(((ResourceTypes.Res_value)value.get()).data);
            java_string = str_utf8 != null ? str_utf8 : (str_utf16 = pool.stringAt(((ResourceTypes.Res_value)value.get()).data));
            array[i] = java_string;
        }
        return array;
    }

    @Implementation(minSdk=28)
    protected static int[] nativeGetResourceStringArrayInfo(long ptr, int resid) {
        int[] array;
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        CppAssetManager2.ResolvedBag bag = assetmanager.GetBag(resid);
        if (bag == null) {
            return null;
        }
        int[] buffer = array = new int[bag.entry_count * 2];
        for (int i = 0; i < bag.entry_count; ++i) {
            Ref ref;
            CppAssetManager2.ResolvedBag.Entry entry = bag.entries[i];
            Ref value = new Ref((Object)entry.value);
            Ref selected_config = new Ref(null);
            Ref flags = new Ref((Object)0);
            ApkAssetsCookie cookie = assetmanager.ResolveReference(entry.cookie, value, selected_config, flags, ref = new Ref((Object)0));
            if (cookie.intValue() == -1) {
                return null;
            }
            int string_index = -1;
            if (((ResourceTypes.Res_value)value.get()).dataType == 3) {
                string_index = ((ResourceTypes.Res_value)value.get()).data;
            }
            buffer[i * 2] = ShadowArscAssetManager10.ApkAssetsCookieToJavaCookie(cookie);
            buffer[i * 2 + 1] = string_index;
        }
        return array;
    }

    @Implementation(minSdk=28)
    protected static int[] nativeGetResourceIntArray(long ptr, int resid) {
        int[] array;
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        CppAssetManager2.ResolvedBag bag = assetmanager.GetBag(resid);
        if (bag == null) {
            return null;
        }
        int[] buffer = array = new int[bag.entry_count];
        for (int i = 0; i < bag.entry_count; ++i) {
            Ref ref;
            CppAssetManager2.ResolvedBag.Entry entry = bag.entries[i];
            Ref value = new Ref((Object)entry.value);
            Ref selected_config = new Ref(null);
            Ref flags = new Ref((Object)0);
            ApkAssetsCookie cookie = assetmanager.ResolveReference(entry.cookie, value, selected_config, flags, ref = new Ref((Object)0));
            if (cookie.intValue() == -1) {
                return null;
            }
            if (((ResourceTypes.Res_value)value.get()).dataType < 16 || ((ResourceTypes.Res_value)value.get()).dataType > 31) continue;
            buffer[i] = ((ResourceTypes.Res_value)value.get()).data;
        }
        return array;
    }

    @Implementation(minSdk=28)
    protected static int nativeGetResourceArraySize(long ptr, int resid) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        CppAssetManager2.ResolvedBag bag = assetmanager.GetBag(resid);
        if (bag == null) {
            return -1;
        }
        return bag.entry_count;
    }

    @Implementation(minSdk=28)
    protected static int nativeGetResourceArray(long ptr, int resid, int[] out_data) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        CppAssetManager2.ResolvedBag bag = assetmanager.GetBag(resid);
        if (bag == null) {
            return -1;
        }
        int out_data_length = out_data.length;
        if (bag.entry_count > out_data_length * 7) {
            throw new IllegalArgumentException("Input array is not large enough");
        }
        int[] buffer = out_data;
        if (buffer == null) {
            return -1;
        }
        int[] cursor = buffer;
        for (int i = 0; i < bag.entry_count; ++i) {
            Ref ref;
            CppAssetManager2.ResolvedBag.Entry entry = bag.entries[i];
            Ref value = new Ref((Object)entry.value);
            Ref selected_config = new Ref((Object)new ResTable_config());
            ((ResTable_config)selected_config.get()).density = 0;
            Ref flags = new Ref((Object)bag.type_spec_flags);
            ApkAssetsCookie cookie = assetmanager.ResolveReference(entry.cookie, value, selected_config, flags, ref = new Ref((Object)0));
            if (cookie.intValue() == -1) {
                return -1;
            }
            if (((ResourceTypes.Res_value)value.get()).dataType == 1 && ((ResourceTypes.Res_value)value.get()).data == 0) {
                value.set((Object)ResourceTypes.Res_value.NULL_VALUE);
            }
            int offset = i * 7;
            cursor[offset + 0] = ((ResourceTypes.Res_value)value.get()).dataType;
            cursor[offset + 1] = ((ResourceTypes.Res_value)value.get()).data;
            cursor[offset + 2] = ShadowArscAssetManager10.ApkAssetsCookieToJavaCookie(cookie);
            cursor[offset + 3] = (Integer)ref.get();
            cursor[offset + 4] = (Integer)flags.get();
            cursor[offset + 5] = ((ResTable_config)selected_config.get()).density;
        }
        return bag.entry_count;
    }

    @Implementation(minSdk=28)
    protected static int nativeGetResourceIdentifier(long ptr, String name, String def_type, String def_package) {
        String name_utf8 = name;
        if (name_utf8 == null) {
            return 0;
        }
        String type = null;
        if (def_type != null) {
            String type_utf8 = def_type;
            Util.CHECK((type_utf8 != null ? 1 : 0) != 0);
            type = type_utf8;
        }
        String package_ = null;
        if (def_package != null) {
            String package_utf8 = def_package;
            Util.CHECK((package_utf8 != null ? 1 : 0) != 0);
            package_ = package_utf8;
        }
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        return assetmanager.GetResourceId(name_utf8, type, package_);
    }

    @Implementation(minSdk=28)
    protected static String nativeGetResourceName(long ptr, int resid) {
        CppAssetManager2.ResourceName name;
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        if (!assetmanager.GetResourceName(resid, name = new CppAssetManager2.ResourceName())) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (name.package_ != null) {
            result.append(name.package_);
        }
        if (name.type != null) {
            if (result.length() != 0) {
                result.append(":");
            }
            result.append(name.type);
        }
        if (name.entry != null) {
            if (result.length() != 0) {
                result.append("/");
            }
            result.append(name.entry);
        }
        return result.toString();
    }

    @Implementation(minSdk=28)
    protected static String nativeGetResourcePackageName(long ptr, int resid) {
        CppAssetManager2.ResourceName name;
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        if (!assetmanager.GetResourceName(resid, name = new CppAssetManager2.ResourceName())) {
            return null;
        }
        if (name.package_ != null) {
            return name.package_;
        }
        return null;
    }

    @Implementation(minSdk=28)
    protected static String nativeGetResourceTypeName(long ptr, int resid) {
        CppAssetManager2.ResourceName name;
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        if (!assetmanager.GetResourceName(resid, name = new CppAssetManager2.ResourceName())) {
            return null;
        }
        if (name.type != null) {
            return name.type;
        }
        return null;
    }

    @Implementation(minSdk=28)
    protected static String nativeGetResourceEntryName(long ptr, int resid) {
        CppAssetManager2.ResourceName name;
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        if (!assetmanager.GetResourceName(resid, name = new CppAssetManager2.ResourceName())) {
            return null;
        }
        if (name.entry != null) {
            return name.entry;
        }
        return null;
    }

    @Implementation(minSdk=28)
    protected static String[] nativeGetLocales(long ptr, boolean exclude_system) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        Set locales = assetmanager.GetResourceLocales(exclude_system, true);
        String[] array = new String[locales.size()];
        int idx = 0;
        for (String locale : locales) {
            String java_string = locale;
            if (java_string == null) {
                return null;
            }
            array[idx++] = java_string;
        }
        return array;
    }

    static Configuration ConstructConfigurationObject(ResTable_config config) {
        Configuration result = new Configuration();
        result.smallestScreenWidthDp = config.smallestScreenWidthDp;
        result.screenWidthDp = config.screenWidthDp;
        result.screenHeightDp = config.screenHeightDp;
        return result;
    }

    @Implementation(minSdk=28)
    protected static Configuration[] nativeGetSizeConfigurations(long ptr) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        Set configurations = assetmanager.GetResourceConfigurations(true, false);
        Configuration[] array = new Configuration[configurations.size()];
        int idx = 0;
        for (ResTable_config configuration : configurations) {
            Configuration java_configuration = ShadowArscAssetManager10.ConstructConfigurationObject(configuration);
            array[idx++] = java_configuration;
        }
        return array;
    }

    @Implementation(minSdk=28)
    protected static void nativeApplyStyle(long ptr, long theme_ptr, int def_style_attr, int def_style_resid, long xml_parser_ptr, int[] java_attrs, long out_values_ptr, long out_indices_ptr) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        CppAssetManager2.Theme theme = (CppAssetManager2.Theme)Registries.NATIVE_THEME9_REGISTRY.getNativeObject(theme_ptr);
        Util.CHECK((theme.GetAssetManager() == assetmanager ? 1 : 0) != 0);
        ResXMLParser xml_parser = xml_parser_ptr == 0L ? null : (ResXMLParser)Registries.NATIVE_RES_XML_PARSERS.getNativeObject(xml_parser_ptr);
        ShadowVMRuntime shadowVMRuntime = (ShadowVMRuntime)Shadow.extract((Object)VMRuntime.getRuntime());
        int[] out_values = (int[])shadowVMRuntime.getObjectForAddress(out_values_ptr);
        int[] out_indices = (int[])shadowVMRuntime.getObjectForAddress(out_indices_ptr);
        int attrs_len = java_attrs.length;
        int[] attrs = java_attrs;
        AttributeResolution10.ApplyStyle((CppAssetManager2.Theme)theme, (ResXMLParser)xml_parser, (int)def_style_attr, (int)def_style_resid, (int[])attrs, (int)attrs_len, (int[])out_values, (int[])out_indices);
    }

    @Implementation(minSdk=28)
    protected static boolean nativeResolveAttrs(long ptr, long theme_ptr, int def_style_attr, int def_style_resid, int[] java_values, int[] java_attrs, int[] out_java_values, int[] out_java_indices) {
        int out_indices_len;
        int[] out_values;
        int out_values_len = out_java_values.length;
        int attrs_len = java_attrs.length;
        if (out_values_len < attrs_len * 7) {
            throw new IndexOutOfBoundsException("outValues too small");
        }
        int[] attrs = java_attrs;
        if (attrs == null) {
            return false;
        }
        int[] values = null;
        int values_len = 0;
        if (java_values != null) {
            values_len = java_values.length;
            values = java_values;
            if (values == null) {
                return false;
            }
        }
        if ((out_values = out_java_values) == null) {
            return false;
        }
        int[] out_indices = null;
        if (out_java_indices != null && (out_indices_len = out_java_indices.length) > attrs_len && (out_indices = out_java_indices) == null) {
            return false;
        }
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        CppAssetManager2.Theme theme = (CppAssetManager2.Theme)Registries.NATIVE_THEME9_REGISTRY.getNativeObject(theme_ptr);
        Util.CHECK((theme.GetAssetManager() == assetmanager ? 1 : 0) != 0);
        boolean result = AttributeResolution10.ResolveAttrs((CppAssetManager2.Theme)theme, (int)def_style_attr, (int)def_style_resid, (int[])values, (int)values_len, (int[])attrs, (int)attrs_len, (int[])out_values, (int[])out_indices);
        return result;
    }

    @Implementation(minSdk=28)
    protected static boolean nativeRetrieveAttributes(long ptr, long xml_parser_ptr, int[] java_attrs, int[] out_java_values, int[] out_java_indices) {
        int out_indices_len;
        int out_values_len = out_java_values.length;
        int attrs_len = java_attrs.length;
        if (out_values_len < attrs_len * 7) {
            throw new IndexOutOfBoundsException("outValues too small");
        }
        int[] attrs = java_attrs;
        if (attrs == null) {
            return false;
        }
        int[] out_values = out_java_values;
        if (out_values == null) {
            return false;
        }
        int[] out_indices = null;
        if (out_java_indices != null && (out_indices_len = out_java_indices.length) > attrs_len && (out_indices = out_java_indices) == null) {
            return false;
        }
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        ResXMLParser xml_parser = (ResXMLParser)Registries.NATIVE_RES_XML_PARSERS.getNativeObject(xml_parser_ptr);
        boolean result = AttributeResolution10.RetrieveAttributes((CppAssetManager2)assetmanager, (ResXMLParser)xml_parser, (int[])attrs, (int)attrs_len, (int[])out_values, (int[])out_indices);
        return result;
    }

    @Implementation(minSdk=28)
    protected static long nativeThemeCreate(long ptr) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        return Registries.NATIVE_THEME9_REGISTRY.register((Object)assetmanager.NewTheme());
    }

    @Implementation(minSdk=28, maxSdk=30)
    protected static void nativeThemeDestroy(long theme_ptr) {
        Registries.NATIVE_THEME9_REGISTRY.unregister(theme_ptr);
    }

    @Implementation(minSdk=28)
    protected static void nativeThemeApplyStyle(long ptr, long theme_ptr, int resid, boolean force) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        CppAssetManager2.Theme theme = (CppAssetManager2.Theme)Registries.NATIVE_THEME9_REGISTRY.getNativeObject(theme_ptr);
        Util.CHECK((theme.GetAssetManager() == assetmanager ? 1 : 0) != 0);
        theme.ApplyStyle(resid, force);
    }

    @Implementation(minSdk=28, maxSdk=28)
    protected static void nativeThemeCopy(long dst_theme_ptr, long src_theme_ptr) {
        CppAssetManager2.Theme src_theme;
        CppAssetManager2.Theme dst_theme = (CppAssetManager2.Theme)Registries.NATIVE_THEME9_REGISTRY.getNativeObject(dst_theme_ptr);
        if (!dst_theme.SetTo(src_theme = (CppAssetManager2.Theme)Registries.NATIVE_THEME9_REGISTRY.getNativeObject(src_theme_ptr))) {
            throw new IllegalArgumentException("Themes are from different AssetManagers");
        }
    }

    @Implementation(minSdk=29)
    protected static void nativeThemeCopy(long dst_asset_manager_ptr, long dst_theme_ptr, long src_asset_manager_ptr, long src_theme_ptr) {
        CppAssetManager2.Theme dst_theme = (CppAssetManager2.Theme)Registries.NATIVE_THEME9_REGISTRY.getNativeObject(dst_theme_ptr);
        CppAssetManager2.Theme src_theme = (CppAssetManager2.Theme)Registries.NATIVE_THEME9_REGISTRY.getNativeObject(src_theme_ptr);
        if (dst_asset_manager_ptr != src_asset_manager_ptr) {
            CppAssetManager2 dst_assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(dst_asset_manager_ptr);
            Util.CHECK((dst_theme.GetAssetManager() == dst_assetmanager ? 1 : 0) != 0);
            CppAssetManager2 src_assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(src_asset_manager_ptr);
            Util.CHECK((src_theme.GetAssetManager() == src_assetmanager ? 1 : 0) != 0);
            dst_theme.SetTo(src_theme);
        } else {
            dst_theme.SetTo(src_theme);
        }
    }

    @Implementation(minSdk=28, maxSdk=30)
    protected static void nativeThemeClear(long themePtr) {
        ((CppAssetManager2.Theme)Registries.NATIVE_THEME9_REGISTRY.getNativeObject(themePtr)).Clear();
    }

    @Implementation(minSdk=28)
    protected static int nativeThemeGetAttributeValue(long ptr, long theme_ptr, int resid, TypedValue typed_value, boolean resolve_references) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        CppAssetManager2.Theme theme = (CppAssetManager2.Theme)Registries.NATIVE_THEME9_REGISTRY.getNativeObject(theme_ptr);
        Util.CHECK((theme.GetAssetManager() == assetmanager ? 1 : 0) != 0);
        Ref value = new Ref(null);
        Ref flags = new Ref(null);
        ApkAssetsCookie cookie = theme.GetAttribute(resid, value, flags);
        if (cookie.intValue() == -1) {
            return ShadowArscAssetManager10.ApkAssetsCookieToJavaCookie(ApkAssetsCookie.K_INVALID_COOKIE);
        }
        Ref ref = new Ref((Object)0);
        if (resolve_references) {
            Ref selected_config = new Ref(null);
            cookie = theme.GetAssetManager().ResolveReference(cookie, value, selected_config, flags, ref);
            if (cookie.intValue() == -1) {
                return ShadowArscAssetManager10.ApkAssetsCookieToJavaCookie(ApkAssetsCookie.K_INVALID_COOKIE);
            }
        }
        return ShadowArscAssetManager10.CopyValue(cookie, (ResourceTypes.Res_value)value.get(), (Integer)ref.get(), (Integer)flags.get(), null, typed_value);
    }

    @Implementation(minSdk=28)
    protected static void nativeThemeDump(long ptr, long theme_ptr, int priority, String tag, String prefix) {
        CppAssetManager2 assetmanager = ShadowArscAssetManager10.AssetManagerFromLong(ptr);
        CppAssetManager2.Theme theme = (CppAssetManager2.Theme)Registries.NATIVE_THEME9_REGISTRY.getNativeObject(theme_ptr);
        Util.CHECK((theme.GetAssetManager() == assetmanager ? 1 : 0) != 0);
    }

    @Implementation(minSdk=28)
    protected static int nativeThemeGetChangingConfigurations(long theme_ptr) {
        CppAssetManager2.Theme theme = (CppAssetManager2.Theme)Registries.NATIVE_THEME9_REGISTRY.getNativeObject(theme_ptr);
        return theme.GetChangingConfigurations();
    }

    @Implementation(minSdk=28)
    protected static void nativeAssetDestroy(long asset_ptr) {
        Registries.NATIVE_ASSET_REGISTRY.unregister(asset_ptr);
    }

    @Implementation(minSdk=28)
    protected static int nativeAssetReadChar(long asset_ptr) {
        byte[] b;
        Asset asset = (Asset)Registries.NATIVE_ASSET_REGISTRY.getNativeObject(asset_ptr);
        int res = asset.read(b = new byte[1], 1);
        return res == 1 ? b[0] & 0xFF : -1;
    }

    @Implementation(minSdk=28)
    protected static int nativeAssetRead(long asset_ptr, byte[] java_buffer, int offset, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int buffer_len = java_buffer.length;
        if (offset < 0 || offset >= buffer_len || len < 0 || len > buffer_len || offset > buffer_len - len) {
            throw new IndexOutOfBoundsException();
        }
        Asset asset = (Asset)Registries.NATIVE_ASSET_REGISTRY.getNativeObject(asset_ptr);
        int res = asset.read(java_buffer, offset, len);
        if (res < 0) {
            throw new IOException();
        }
        return res > 0 ? res : -1;
    }

    @Implementation(minSdk=28)
    protected static long nativeAssetSeek(long asset_ptr, long offset, int whence) {
        Asset asset = (Asset)Registries.NATIVE_ASSET_REGISTRY.getNativeObject(asset_ptr);
        return asset.seek(offset, whence > 0 ? 2 : (whence < 0 ? 0 : 1));
    }

    @Implementation(minSdk=28)
    protected static long nativeAssetGetLength(long asset_ptr) {
        Asset asset = (Asset)Registries.NATIVE_ASSET_REGISTRY.getNativeObject(asset_ptr);
        return asset.getLength();
    }

    @Implementation(minSdk=28)
    protected static long nativeAssetGetRemainingLength(long asset_ptr) {
        Asset asset = (Asset)Registries.NATIVE_ASSET_REGISTRY.getNativeObject(asset_ptr);
        return asset.getRemainingLength();
    }

    @ForType(value=AssetManager.class)
    static interface AssetManagerReflector {
        @Static
        @Direct
        public void createSystemAssetsInZygoteLocked();
    }
}

