

package org.robolectric.shadows;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.PendingIntent;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ShadowUsageStatsManager_UsageSessionObserver extends ShadowUsageStatsManager.UsageSessionObserver {

  private final int observerId;

  private final ImmutableList<String> packageNames;

  private final Duration sessionStepDuration;

  private final Duration thresholdDuration;

  private final PendingIntent sessionStepTriggeredIntent;

  private final PendingIntent sessionEndedIntent;

  AutoValue_ShadowUsageStatsManager_UsageSessionObserver(
      int observerId,
      ImmutableList<String> packageNames,
      @Nullable Duration sessionStepDuration,
      @Nullable Duration thresholdDuration,
      PendingIntent sessionStepTriggeredIntent,
      PendingIntent sessionEndedIntent) {
    this.observerId = observerId;
    if (packageNames == null) {
      throw new NullPointerException("Null packageNames");
    }
    this.packageNames = packageNames;
    this.sessionStepDuration = sessionStepDuration;
    this.thresholdDuration = thresholdDuration;
    if (sessionStepTriggeredIntent == null) {
      throw new NullPointerException("Null sessionStepTriggeredIntent");
    }
    this.sessionStepTriggeredIntent = sessionStepTriggeredIntent;
    if (sessionEndedIntent == null) {
      throw new NullPointerException("Null sessionEndedIntent");
    }
    this.sessionEndedIntent = sessionEndedIntent;
  }

  @Override
  public int getObserverId() {
    return observerId;
  }

  @NonNull
  @Override
  public ImmutableList<String> getPackageNames() {
    return packageNames;
  }

  @Nullable
  @Override
  public Duration getSessionStepDuration() {
    return sessionStepDuration;
  }

  @Nullable
  @Override
  public Duration getThresholdDuration() {
    return thresholdDuration;
  }

  @NonNull
  @Override
  public PendingIntent getSessionStepTriggeredIntent() {
    return sessionStepTriggeredIntent;
  }

  @NonNull
  @Override
  public PendingIntent getSessionEndedIntent() {
    return sessionEndedIntent;
  }

  @Override
  public String toString() {
    return "UsageSessionObserver{"
         + "observerId=" + observerId + ", "
         + "packageNames=" + packageNames + ", "
         + "sessionStepDuration=" + sessionStepDuration + ", "
         + "thresholdDuration=" + thresholdDuration + ", "
         + "sessionStepTriggeredIntent=" + sessionStepTriggeredIntent + ", "
         + "sessionEndedIntent=" + sessionEndedIntent
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ShadowUsageStatsManager.UsageSessionObserver) {
      ShadowUsageStatsManager.UsageSessionObserver that = (ShadowUsageStatsManager.UsageSessionObserver) o;
      return (this.observerId == that.getObserverId())
           && (this.packageNames.equals(that.getPackageNames()))
           && ((this.sessionStepDuration == null) ? (that.getSessionStepDuration() == null) : this.sessionStepDuration.equals(that.getSessionStepDuration()))
           && ((this.thresholdDuration == null) ? (that.getThresholdDuration() == null) : this.thresholdDuration.equals(that.getThresholdDuration()))
           && (this.sessionStepTriggeredIntent.equals(that.getSessionStepTriggeredIntent()))
           && (this.sessionEndedIntent.equals(that.getSessionEndedIntent()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= observerId;
    h$ *= 1000003;
    h$ ^= packageNames.hashCode();
    h$ *= 1000003;
    h$ ^= (sessionStepDuration == null) ? 0 : sessionStepDuration.hashCode();
    h$ *= 1000003;
    h$ ^= (thresholdDuration == null) ? 0 : thresholdDuration.hashCode();
    h$ *= 1000003;
    h$ ^= sessionStepTriggeredIntent.hashCode();
    h$ *= 1000003;
    h$ ^= sessionEndedIntent.hashCode();
    return h$;
  }

}
