/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.util.Locale;
import libcore.icu.LocaleData;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=LocaleData.class, isInAndroidSdk=false)
public class ShadowLocaleData {
    public static final String REAL_CLASS_NAME = "libcore.icu.LocaleData";

    @Implementation
    public static LocaleData get(Locale locale) {
        LocaleData localeData = (LocaleData)Shadow.newInstanceOf((String)REAL_CLASS_NAME);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ShadowLocaleData.setEnUsLocaleData(localeData);
        return localeData;
    }

    private static void setEnUsLocaleData(LocaleData localeData) {
        localeData.amPm = new String[]{"AM", "PM"};
        localeData.eras = new String[]{"BC", "AD"};
        localeData.firstDayOfWeek = 1;
        localeData.minimalDaysInFirstWeek = 1;
        localeData.longMonthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        localeData.shortMonthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        _LocaleData_ localDataReflector = (_LocaleData_)Reflector.reflector(_LocaleData_.class, (Object)localeData);
        if (RuntimeEnvironment.getApiLevel() >= 17) {
            localeData.tinyMonthNames = new String[]{"J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"};
            localeData.tinyStandAloneMonthNames = localeData.tinyMonthNames;
            localeData.tinyWeekdayNames = new String[]{"", "S", "M", "T", "W", "T", "F", "S"};
            localeData.tinyStandAloneWeekdayNames = localeData.tinyWeekdayNames;
            if (RuntimeEnvironment.getApiLevel() <= 30) {
                localDataReflector.setYesterday("Yesterday");
            }
            localeData.today = "Today";
            localeData.tomorrow = "Tomorrow";
        }
        localeData.longStandAloneMonthNames = localeData.longMonthNames;
        localeData.shortStandAloneMonthNames = localeData.shortMonthNames;
        localeData.longWeekdayNames = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        localeData.shortWeekdayNames = new String[]{"", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        localeData.longStandAloneWeekdayNames = localeData.longWeekdayNames;
        localeData.shortStandAloneWeekdayNames = localeData.shortWeekdayNames;
        localeData.fullTimeFormat = "h:mm:ss a zzzz";
        localeData.longTimeFormat = "h:mm:ss a z";
        localeData.mediumTimeFormat = "h:mm:ss a";
        localeData.shortTimeFormat = "h:mm a";
        if (RuntimeEnvironment.getApiLevel() >= 23) {
            localeData.timeFormat_hm = "h:mm a";
            localeData.timeFormat_Hm = "HH:mm";
        } else if (RuntimeEnvironment.getApiLevel() >= 18) {
            localDataReflector.setTimeFormat12("h:mm a");
            localDataReflector.setTimeFormat24("HH:mm");
        }
        localeData.fullDateFormat = "EEEE, MMMM d, y";
        localeData.longDateFormat = "MMMM d, y";
        localeData.mediumDateFormat = "MMM d, y";
        localeData.shortDateFormat = "M/d/yy";
        if (RuntimeEnvironment.getApiLevel() >= 19 && RuntimeEnvironment.getApiLevel() < 23) {
            localDataReflector.setShortDateFormat4("M/d/yyyy");
        }
        localeData.zeroDigit = (char)48;
        localeData.decimalSeparator = (char)46;
        localeData.groupingSeparator = (char)44;
        localeData.patternSeparator = (char)59;
        if (RuntimeEnvironment.getApiLevel() >= 22) {
            localeData.percent = "%";
        } else {
            localDataReflector.setPercent('%');
        }
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            localeData.perMill = "\u2030";
        } else {
            localDataReflector.setPerMill('\u2030');
        }
        localeData.monetarySeparator = (char)46;
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            localeData.minusSign = "-";
        } else {
            localDataReflector.setMinusSign('-');
        }
        localeData.exponentSeparator = "E";
        localeData.infinity = "\u221e";
        localeData.NaN = "NaN";
        if (RuntimeEnvironment.getApiLevel() <= 30) {
            localDataReflector.setCurrencySymbol("$");
            localDataReflector.setInternationalCurrencySymbol("USD");
        }
        localeData.numberPattern = "#,##0.###";
        localeData.integerPattern = "#,##0";
        localeData.currencyPattern = "\u00a4#,##0.00;(\u00a4#,##0.00)";
        localeData.percentPattern = "#,##0%";
    }

    @ForType(value=LocaleData.class)
    static interface _LocaleData_ {
        @Accessor(value="minusSign")
        public void setMinusSign(char var1);

        @Accessor(value="percent")
        public void setPercent(char var1);

        @Accessor(value="perMill")
        public void setPerMill(char var1);

        @Accessor(value="timeFormat12")
        public void setTimeFormat12(String var1);

        @Accessor(value="timeFormat24")
        public void setTimeFormat24(String var1);

        @Accessor(value="shortDateFormat4")
        public void setShortDateFormat4(String var1);

        @Accessor(value="yesterday")
        public void setYesterday(String var1);

        @Accessor(value="currencySymbol")
        public void setCurrencySymbol(String var1);

        @Accessor(value="internationalCurrencySymbol")
        public void setInternationalCurrencySymbol(String var1);
    }
}

