/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.appwidget.AppWidgetProviderInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.UserHandle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetService;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=AppWidgetManager.class)
public class ShadowAppWidgetManager {
    @RealObject
    private AppWidgetManager realAppWidgetManager;
    private Context context;
    private final Map<Integer, WidgetInfo> widgetInfos = new HashMap<Integer, WidgetInfo>();
    private int nextWidgetId = 1;
    private boolean alwaysRecreateViewsDuringUpdate = false;
    private boolean allowedToBindWidgets;
    private boolean requestPinAppWidgetSupported = false;
    private boolean validWidgetProviderComponentName = true;
    private final ArrayList<AppWidgetProviderInfo> installedProviders = new ArrayList();
    private Multimap<UserHandle, AppWidgetProviderInfo> installedProvidersForProfile = HashMultimap.create();

    @Implementation(maxSdk=19)
    protected void __constructor__(Context context) {
        this.context = context;
    }

    @Implementation(minSdk=21)
    protected void __constructor__(Context context, IAppWidgetService service) {
        this.context = context;
    }

    @Implementation
    protected void updateAppWidget(int[] appWidgetIds, RemoteViews views) {
        for (int appWidgetId : appWidgetIds) {
            this.updateAppWidget(appWidgetId, views);
        }
    }

    @Implementation
    protected void updateAppWidget(int appWidgetId, RemoteViews views) {
        WidgetInfo widgetInfo = this.widgetInfos.get(appWidgetId);
        if (this.canReapplyRemoteViews(widgetInfo, views)) {
            views.reapply(this.context, widgetInfo.view);
        } else {
            widgetInfo.view = views.apply(this.context, (ViewGroup)new FrameLayout(this.context));
            widgetInfo.layoutId = this.getRemoteViewsToApply(views).getLayoutId();
        }
        widgetInfo.lastRemoteViews = views;
    }

    private boolean canReapplyRemoteViews(WidgetInfo widgetInfo, RemoteViews views) {
        if (this.alwaysRecreateViewsDuringUpdate) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 25 && !ShadowAppWidgetManager.hasLandscapeAndPortraitLayouts(views)) {
            return widgetInfo.layoutId == views.getLayoutId();
        }
        RemoteViews remoteViewsToApply = this.getRemoteViewsToApply(views);
        if (Build.VERSION.SDK_INT >= 25) {
            return widgetInfo.layoutId == remoteViewsToApply.getLayoutId();
        }
        return widgetInfo.view != null && widgetInfo.view.getId() == remoteViewsToApply.getLayoutId();
    }

    private RemoteViews getRemoteViewsToApply(RemoteViews views) {
        return ((RemoteViewsReflector)Reflector.reflector(RemoteViewsReflector.class, (Object)views)).getRemoteViewsToApply(this.context);
    }

    private static boolean hasLandscapeAndPortraitLayouts(RemoteViews views) {
        return ((RemoteViewsReflector)Reflector.reflector(RemoteViewsReflector.class, (Object)views)).hasLandscapeAndPortraitLayouts();
    }

    @Implementation
    protected int[] getAppWidgetIds(ComponentName provider) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (int id2 : this.widgetInfos.keySet()) {
            WidgetInfo widgetInfo = this.widgetInfos.get(id2);
            if (!provider.equals((Object)widgetInfo.providerComponent)) continue;
            idList.add(id2);
        }
        int[] ids = new int[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            ids[i] = (Integer)idList.get(i);
        }
        return ids;
    }

    @Implementation
    protected List<AppWidgetProviderInfo> getInstalledProviders() {
        return new ArrayList<AppWidgetProviderInfo>(this.installedProviders);
    }

    @Implementation(minSdk=21)
    protected List<AppWidgetProviderInfo> getInstalledProvidersForProfile(UserHandle profile) {
        return ImmutableList.copyOf((Collection)this.installedProvidersForProfile.get((Object)profile));
    }

    @Implementation(minSdk=26)
    protected List<AppWidgetProviderInfo> getInstalledProvidersForPackage(String packageName, UserHandle profile) {
        return ImmutableList.copyOf((Collection)this.installedProvidersForProfile.get((Object)profile).stream().filter(providerInfo -> providerInfo.provider.getPackageName().equals(packageName)).collect(Collectors.toList()));
    }

    public void addInstalledProvider(AppWidgetProviderInfo appWidgetProviderInfo) {
        this.installedProviders.add(appWidgetProviderInfo);
    }

    public boolean removeInstalledProvider(AppWidgetProviderInfo appWidgetProviderInfo) {
        return this.installedProviders.remove(appWidgetProviderInfo);
    }

    public void addInstalledProvidersForProfile(UserHandle userHandle, AppWidgetProviderInfo appWidgetProviderInfo) {
        this.installedProvidersForProfile.put((Object)userHandle, (Object)appWidgetProviderInfo);
    }

    public void addBoundWidget(int appWidgetId, AppWidgetProviderInfo providerInfo) {
        this.addInstalledProvider(providerInfo);
        this.bindAppWidgetId(appWidgetId, providerInfo.provider);
        this.widgetInfos.get((Object)Integer.valueOf((int)appWidgetId)).info = providerInfo;
    }

    @Deprecated
    public void putWidgetInfo(int appWidgetId, AppWidgetProviderInfo expectedWidgetInfo) {
        this.addBoundWidget(appWidgetId, expectedWidgetInfo);
    }

    @Implementation
    protected AppWidgetProviderInfo getAppWidgetInfo(int appWidgetId) {
        WidgetInfo widgetInfo = this.widgetInfos.get(appWidgetId);
        if (widgetInfo == null) {
            return null;
        }
        return widgetInfo.info;
    }

    @Implementation
    protected Bundle getAppWidgetOptions(int appWidgetId) {
        WidgetInfo widgetInfo = this.widgetInfos.get(appWidgetId);
        if (widgetInfo == null) {
            return Bundle.EMPTY;
        }
        return (Bundle)widgetInfo.options.clone();
    }

    @Implementation
    protected void updateAppWidgetOptions(int appWidgetId, Bundle options) {
        WidgetInfo widgetInfo = this.widgetInfos.get(appWidgetId);
        if (widgetInfo != null && options != null) {
            widgetInfo.options.putAll(options);
            if (widgetInfo.appWidgetProvider != null) {
                widgetInfo.appWidgetProvider.onAppWidgetOptionsChanged(this.context, this.realAppWidgetManager, appWidgetId, (Bundle)options.clone());
            }
        }
    }

    @HiddenApi
    @Implementation
    public void bindAppWidgetId(int appWidgetId, ComponentName provider) {
        this.bindAppWidgetId(appWidgetId, provider, null);
    }

    @HiddenApi
    @Implementation(minSdk=17)
    protected void bindAppWidgetId(int appWidgetId, ComponentName provider, Bundle options) {
        WidgetInfo widgetInfo = new WidgetInfo(provider);
        this.widgetInfos.put(appWidgetId, widgetInfo);
        if (options != null) {
            widgetInfo.options = (Bundle)options.clone();
        }
        for (AppWidgetProviderInfo appWidgetProviderInfo : this.installedProviders) {
            if (provider == null || !provider.equals((Object)appWidgetProviderInfo.provider)) continue;
            widgetInfo.info = appWidgetProviderInfo;
        }
    }

    @Implementation
    protected boolean bindAppWidgetIdIfAllowed(int appWidgetId, ComponentName provider) {
        return this.bindAppWidgetIdIfAllowed(appWidgetId, provider, null);
    }

    @Implementation(minSdk=17)
    protected boolean bindAppWidgetIdIfAllowed(int appWidgetId, ComponentName provider, Bundle options) {
        if (this.validWidgetProviderComponentName) {
            this.bindAppWidgetId(appWidgetId, provider, options);
            return this.allowedToBindWidgets;
        }
        throw new IllegalArgumentException("not an appwidget provider");
    }

    @Implementation(minSdk=26)
    protected boolean isRequestPinAppWidgetSupported() {
        return this.requestPinAppWidgetSupported;
    }

    @Implementation(minSdk=26)
    protected boolean requestPinAppWidget(ComponentName provider, Bundle extras, PendingIntent successCallback) {
        if (this.requestPinAppWidgetSupported) {
            int myWidgetId = this.nextWidgetId++;
            this.bindAppWidgetId(myWidgetId, provider);
            if (successCallback != null) {
                try {
                    successCallback.send(this.context.getApplicationContext(), 0, new Intent().putExtra("appWidgetId", myWidgetId));
                }
                catch (PendingIntent.CanceledException e) {
                    throw new RuntimeException(e);
                }
            }
            return true;
        }
        return false;
    }

    public void reconstructWidgetViewAsIfPhoneWasRotated(int appWidgetId) {
        WidgetInfo widgetInfo = this.widgetInfos.get(appWidgetId);
        widgetInfo.view = widgetInfo.lastRemoteViews.apply(this.context, (ViewGroup)new FrameLayout(this.context));
    }

    public int createWidget(Class<? extends AppWidgetProvider> appWidgetProviderClass, int widgetLayoutId) {
        return this.createWidgets(appWidgetProviderClass, widgetLayoutId, 1)[0];
    }

    public int[] createWidgets(Class<? extends AppWidgetProvider> appWidgetProviderClass, int widgetLayoutId, int howManyToCreate) {
        AppWidgetProvider appWidgetProvider = (AppWidgetProvider)ReflectionHelpers.callConstructor(appWidgetProviderClass, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        int[] newWidgetIds = new int[howManyToCreate];
        for (int i = 0; i < howManyToCreate; ++i) {
            int myWidgetId;
            ++this.nextWidgetId;
            RemoteViews remoteViews = new RemoteViews(this.context.getPackageName(), widgetLayoutId);
            View widgetView = remoteViews.apply(this.context, (ViewGroup)new FrameLayout(this.context));
            WidgetInfo widgetInfo = new WidgetInfo(widgetView, widgetLayoutId, this.context, appWidgetProvider);
            widgetInfo.lastRemoteViews = remoteViews;
            this.widgetInfos.put(myWidgetId, widgetInfo);
            newWidgetIds[i] = myWidgetId;
        }
        appWidgetProvider.onUpdate(this.context, this.realAppWidgetManager, newWidgetIds);
        return newWidgetIds;
    }

    public View getViewFor(int widgetId) {
        return this.widgetInfos.get((Object)Integer.valueOf((int)widgetId)).view;
    }

    public AppWidgetProvider getAppWidgetProviderFor(int widgetId) {
        return this.widgetInfos.get((Object)Integer.valueOf((int)widgetId)).appWidgetProvider;
    }

    public void setAlwaysRecreateViewsDuringUpdate(boolean alwaysRecreate) {
        this.alwaysRecreateViewsDuringUpdate = alwaysRecreate;
    }

    public boolean getAlwaysRecreateViewsDuringUpdate() {
        return this.alwaysRecreateViewsDuringUpdate;
    }

    public void setAllowedToBindAppWidgets(boolean allowed) {
        this.allowedToBindWidgets = allowed;
    }

    public void setRequestPinAppWidgetSupported(boolean supported) {
        this.requestPinAppWidgetSupported = supported;
    }

    public void setValidWidgetProviderComponentName(boolean validWidgetProviderComponentName) {
        this.validWidgetProviderComponentName = validWidgetProviderComponentName;
    }

    @ForType(value=RemoteViews.class)
    static interface RemoteViewsReflector {
        @Direct
        public RemoteViews getRemoteViewsToApply(Context var1);

        @Direct
        public boolean hasLandscapeAndPortraitLayouts();
    }

    private static class WidgetInfo {
        View view;
        int layoutId;
        final AppWidgetProvider appWidgetProvider;
        RemoteViews lastRemoteViews;
        final ComponentName providerComponent;
        AppWidgetProviderInfo info;
        Bundle options = new Bundle();

        public WidgetInfo(View view, int layoutId, Context context, AppWidgetProvider appWidgetProvider) {
            this.view = view;
            this.layoutId = layoutId;
            this.appWidgetProvider = appWidgetProvider;
            this.providerComponent = new ComponentName(context, appWidgetProvider.getClass());
        }

        public WidgetInfo(ComponentName providerComponent) {
            this.providerComponent = providerComponent;
            this.appWidgetProvider = null;
        }
    }
}

