/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.util;

import com.almworks.sqlite4java.SQLite;
import com.almworks.sqlite4java.SQLiteException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLiteLibraryLoader {
    private static SQLiteLibraryLoader instance;
    private static final String SQLITE4JAVA = "sqlite4java";
    private static final String OS_WIN = "win32";
    private static final String OS_LINUX = "linux";
    private static final String OS_MAC = "osx";
    private final LibraryNameMapper libraryNameMapper;
    private boolean loaded;
    private static final LibraryNameMapper DEFAULT_MAPPER;

    public SQLiteLibraryLoader() {
        this(DEFAULT_MAPPER);
    }

    public SQLiteLibraryLoader(LibraryNameMapper mapper) {
        this.libraryNameMapper = mapper;
    }

    public static synchronized void load() {
        if (instance == null) {
            instance = new SQLiteLibraryLoader();
        }
        instance.doLoad();
    }

    public void doLoad() {
        if (this.loaded) {
            return;
        }
        long startTime = System.currentTimeMillis();
        File tempDir = Files.createTempDir();
        tempDir.deleteOnExit();
        File extractedLibraryPath = new File(tempDir, this.getLibName());
        try (FileOutputStream outputStream = new FileOutputStream(extractedLibraryPath);){
            this.getLibraryByteSource().copyTo((OutputStream)outputStream);
        }
        catch (IOException e) {
            String string2 = String.valueOf(extractedLibraryPath);
            throw new RuntimeException(new StringBuilder(35 + String.valueOf(string2).length()).append("Cannot extract SQLite library into ").append(string2).toString(), e);
        }
        this.loadFromDirectory(tempDir);
        this.logWithTime("SQLite natives prepared in", startTime);
    }

    public String getLibClasspathResourceName() {
        String string2 = this.getNativesResourcesPathPart();
        String string3 = this.getLibName();
        return new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("sqlite4java/").append(string2).append("/").append(string3).toString();
    }

    private ByteSource getLibraryByteSource() {
        return Resources.asByteSource((URL)Resources.getResource((String)this.getLibClasspathResourceName()));
    }

    private void logWithTime(String message, long startTime) {
        long l = System.currentTimeMillis() - startTime;
        this.log(new StringBuilder(21 + String.valueOf(message).length()).append(message).append(" ").append(l).toString());
    }

    private void log(String message) {
        org.robolectric.util.Logger.debug((String)message, (Object[])new Object[0]);
    }

    @VisibleForTesting
    public boolean isLoaded() {
        return this.loaded;
    }

    private void loadFromDirectory(File libPath) {
        Logger.getLogger("com.almworks.sqlite4java").setLevel(Level.WARNING);
        SQLite.setLibraryPath((String)libPath.getAbsolutePath());
        try {
            String string2 = SQLite.getLibraryVersion();
            String string3 = SQLite.getSQLiteVersion();
            this.log(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("SQLite version: library ").append(string2).append(" / core ").append(string3).toString());
        }
        catch (SQLiteException e) {
            throw new RuntimeException(e);
        }
        this.loaded = true;
    }

    private String getLibName() {
        return this.libraryNameMapper.mapLibraryName(SQLITE4JAVA);
    }

    private String getNativesResourcesPathPart() {
        String prefix = this.getOsPrefix();
        String suffix = this.getArchitectureSuffix(prefix);
        if (suffix != null) {
            return new StringBuilder(1 + String.valueOf(prefix).length() + String.valueOf(suffix).length()).append(prefix).append("-").append(suffix).toString();
        }
        return prefix;
    }

    private String getOsPrefix() {
        String name = System.getProperty("os.name").toLowerCase(Locale.US);
        if (name.contains("win")) {
            return OS_WIN;
        }
        if (name.contains(OS_LINUX)) {
            return OS_LINUX;
        }
        if (name.contains("mac")) {
            return OS_MAC;
        }
        throw new UnsupportedOperationException(new StringBuilder(46 + String.valueOf(name).length()).append("Platform '").append(name).append("' is not supported by SQLite library").toString());
    }

    private String getArchitectureSuffix(String prefix) {
        String arch = System.getProperty("os.arch").toLowerCase(Locale.US).replaceAll("\\W", "");
        switch (prefix) {
            case "osx": {
                return null;
            }
            case "linux": {
                switch (arch) {
                    case "i386": 
                    case "x86": {
                        return "i386";
                    }
                    case "x86_64": 
                    case "amd64": {
                        return "amd64";
                    }
                }
                break;
            }
            case "win32": {
                switch (arch) {
                    case "x86": {
                        return "x86";
                    }
                    case "x86_64": 
                    case "amd64": {
                        return "x64";
                    }
                }
            }
        }
        throw new UnsupportedOperationException(new StringBuilder(50 + String.valueOf(arch).length()).append("Architecture '").append(arch).append("' is not supported by SQLite library").toString());
    }

    static {
        DEFAULT_MAPPER = System::mapLibraryName;
    }

    public static interface LibraryNameMapper {
        public String mapLibraryName(String var1);
    }
}

