/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SystemApi;
import android.app.WallpaperInfo;
import android.app.WallpaperManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.Logger;
import org.xmlpull.v1.XmlPullParserException;

@Implements(value=WallpaperManager.class)
public class ShadowWallpaperManager {
    private static final String TAG = "ShadowWallpaperManager";
    private Bitmap lockScreenImage = null;
    private Bitmap homeScreenImage = null;
    private boolean isWallpaperAllowed = true;
    private boolean isWallpaperSupported = true;
    private WallpaperInfo wallpaperInfo = null;
    private final List<WallpaperCommandRecord> wallpaperCommandRecords = new ArrayList<WallpaperCommandRecord>();

    @Implementation
    protected void sendWallpaperCommand(IBinder windowToken, String action, int x, int y, int z, Bundle extras) {
        this.wallpaperCommandRecords.add(new WallpaperCommandRecord(windowToken, action, x, y, z, extras));
    }

    @Implementation(minSdk=28)
    protected int setBitmap(Bitmap fullImage, Rect visibleCropHint, boolean allowBackup, int which) {
        if (which == 2) {
            this.lockScreenImage = fullImage;
            this.wallpaperInfo = null;
            return 1;
        }
        if (which == 1) {
            this.homeScreenImage = fullImage;
            this.wallpaperInfo = null;
            return 1;
        }
        return 0;
    }

    @Nullable
    public Bitmap getBitmap(int which) {
        if (which == 2) {
            return this.lockScreenImage;
        }
        if (which == 1) {
            return this.homeScreenImage;
        }
        return null;
    }

    @Implementation(minSdk=28)
    @Nullable
    protected ParcelFileDescriptor getWallpaperFile(int which) {
        if (which == 1 && this.homeScreenImage != null) {
            return ShadowWallpaperManager.createParcelFileDescriptorFromBitmap(this.homeScreenImage, "home_wallpaper");
        }
        if (which == 2 && this.lockScreenImage != null) {
            return ShadowWallpaperManager.createParcelFileDescriptorFromBitmap(this.lockScreenImage, "lock_screen_wallpaper");
        }
        return null;
    }

    @Implementation(minSdk=24)
    protected boolean isSetWallpaperAllowed() {
        return this.isWallpaperAllowed;
    }

    public void setIsSetWallpaperAllowed(boolean allowed) {
        this.isWallpaperAllowed = allowed;
    }

    @Implementation(minSdk=23)
    protected boolean isWallpaperSupported() {
        return this.isWallpaperSupported;
    }

    public void setIsWallpaperSupported(boolean supported) {
        this.isWallpaperSupported = supported;
    }

    @Implementation(minSdk=24)
    protected int setStream(InputStream bitmapData, Rect visibleCropHint, boolean allowBackup, int which) {
        if (which == 2) {
            this.lockScreenImage = BitmapFactory.decodeStream((InputStream)bitmapData);
            return 1;
        }
        if (which == 1) {
            this.homeScreenImage = BitmapFactory.decodeStream((InputStream)bitmapData);
            return 1;
        }
        return 0;
    }

    @SystemApi
    @Implementation(minSdk=23)
    protected boolean setWallpaperComponent(ComponentName wallpaperService) throws IOException, XmlPullParserException {
        ShadowWallpaperManager.enforceWallpaperComponentPermission();
        Intent wallpaperServiceIntent = new Intent().setComponent(wallpaperService);
        List resolveInfoList = RuntimeEnvironment.application.getPackageManager().queryIntentServices(wallpaperServiceIntent, 128);
        if (resolveInfoList.size() != 1) {
            String string2 = String.valueOf(wallpaperService);
            throw new IllegalArgumentException(new StringBuilder(42 + String.valueOf(string2).length()).append("Can't locate the given wallpaper service: ").append(string2).toString());
        }
        this.wallpaperInfo = new WallpaperInfo((Context)RuntimeEnvironment.application, (ResolveInfo)resolveInfoList.get(0));
        this.lockScreenImage = null;
        this.homeScreenImage = null;
        return true;
    }

    @Implementation(minSdk=23)
    protected WallpaperInfo getWallpaperInfo() {
        return this.wallpaperInfo;
    }

    public List<WallpaperCommandRecord> getWallpaperCommandRecords() {
        return Collections.unmodifiableList(this.wallpaperCommandRecords);
    }

    private static void enforceWallpaperComponentPermission() {
        if (RuntimeEnvironment.application.checkSelfPermission("android.permission.SET_WALLPAPER_COMPONENT") != 0) {
            throw new SecurityException("Permission android.permission.SET_WALLPAPER_COMPONENT isn't granted.");
        }
    }

    private static ParcelFileDescriptor createParcelFileDescriptorFromBitmap(Bitmap image, String fileName) {
        ParcelFileDescriptor parcelFileDescriptor;
        File tmpFile = new File(RuntimeEnvironment.application.getCacheDir(), fileName);
        FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
        try {
            image.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)fileOutputStream);
            parcelFileDescriptor = ParcelFileDescriptor.open((File)tmpFile, (int)0x10000000);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Logger.error((String)"Fail to close file output stream when reading wallpaper from file", (Throwable)e);
                return null;
            }
        }
        fileOutputStream.close();
        return parcelFileDescriptor;
    }

    public static class WallpaperCommandRecord {
        public final IBinder windowToken;
        public final String action;
        public final int x;
        public final int y;
        public final int z;
        public final Bundle extras;

        WallpaperCommandRecord(IBinder windowToken, String action, int x, int y, int z, Bundle extras) {
            this.windowToken = windowToken;
            this.action = action;
            this.x = x;
            this.y = y;
            this.z = z;
            this.extras = extras;
        }
    }
}

