/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import android.app.IActivityManager;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.UserHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplicationPackageManager;
import org.robolectric.shadows.ShadowUserManager;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ActivityManager.class, looseSignatures=true)
public class ShadowActivityManager {
    private int memoryClass = 16;
    private String backgroundPackage;
    private ActivityManager.MemoryInfo memoryInfo;
    private final List<ActivityManager.AppTask> appTasks = new CopyOnWriteArrayList<ActivityManager.AppTask>();
    private final List<ActivityManager.RunningTaskInfo> tasks = new CopyOnWriteArrayList<ActivityManager.RunningTaskInfo>();
    private final List<ActivityManager.RunningServiceInfo> services = new CopyOnWriteArrayList<ActivityManager.RunningServiceInfo>();
    private static List<ActivityManager.RunningAppProcessInfo> processes = new CopyOnWriteArrayList<ActivityManager.RunningAppProcessInfo>();
    @RealObject
    private ActivityManager realObject;
    private Boolean isLowRamDeviceOverride = null;
    private int lockTaskModeState = 0;
    private boolean isBackgroundRestricted;
    private final Deque<Object> appExitInfoList = new ArrayDeque<Object>();
    private ConfigurationInfo configurationInfo;

    public ShadowActivityManager() {
        ActivityManager.RunningAppProcessInfo processInfo = new ActivityManager.RunningAppProcessInfo();
        ShadowActivityManager.fillInProcessInfo(processInfo);
        processInfo.processName = RuntimeEnvironment.application.getPackageName();
        processInfo.pkgList = new String[]{RuntimeEnvironment.application.getPackageName()};
        processes.add(processInfo);
    }

    @Implementation
    protected int getMemoryClass() {
        return this.memoryClass;
    }

    @Implementation
    protected static boolean isUserAMonkey() {
        return false;
    }

    @Implementation(minSdk=17)
    @HiddenApi
    protected static int getCurrentUser() {
        return UserHandle.myUserId();
    }

    @Implementation
    protected List<ActivityManager.RunningTaskInfo> getRunningTasks(int maxNum) {
        return this.tasks;
    }

    @Implementation(minSdk=21)
    protected List<ActivityManager.AppTask> getAppTasks() {
        return this.appTasks;
    }

    @Implementation
    protected List<ActivityManager.RunningServiceInfo> getRunningServices(int maxNum) {
        return this.services;
    }

    @Implementation
    protected List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() {
        if (processes.isEmpty()) {
            return null;
        }
        return processes;
    }

    @Implementation
    protected static void getMyMemoryState(ActivityManager.RunningAppProcessInfo inState) {
        ShadowActivityManager.fillInProcessInfo(inState);
        for (ActivityManager.RunningAppProcessInfo info : processes) {
            if (info.pid != Process.myPid()) continue;
            inState.importance = info.importance;
            inState.lru = info.lru;
            inState.importanceReasonCode = info.importanceReasonCode;
            inState.importanceReasonPid = info.importanceReasonPid;
            inState.lastTrimLevel = info.lastTrimLevel;
            inState.pkgList = info.pkgList;
            inState.processName = info.processName;
        }
    }

    private static void fillInProcessInfo(ActivityManager.RunningAppProcessInfo processInfo) {
        processInfo.pid = Process.myPid();
        processInfo.uid = Process.myUid();
    }

    @HiddenApi
    @Implementation(minSdk=17)
    protected boolean switchUser(int userid) {
        ShadowUserManager shadowUserManager = (ShadowUserManager)Shadow.extract((Object)RuntimeEnvironment.application.getSystemService("user"));
        shadowUserManager.switchUser(userid);
        return true;
    }

    @Implementation(minSdk=29)
    protected boolean switchUser(UserHandle userHandle) {
        return this.switchUser(userHandle.getIdentifier());
    }

    @Implementation
    protected void killBackgroundProcesses(String packageName) {
        this.backgroundPackage = packageName;
    }

    @Implementation
    protected void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        if (this.memoryInfo != null) {
            outInfo.availMem = this.memoryInfo.availMem;
            outInfo.lowMemory = this.memoryInfo.lowMemory;
            outInfo.threshold = this.memoryInfo.threshold;
            outInfo.totalMem = this.memoryInfo.totalMem;
        }
    }

    @Implementation
    protected ConfigurationInfo getDeviceConfigurationInfo() {
        return this.configurationInfo == null ? new ConfigurationInfo() : this.configurationInfo;
    }

    public void setDeviceConfigurationInfo(ConfigurationInfo configurationInfo) {
        this.configurationInfo = configurationInfo;
    }

    public void setTasks(List<ActivityManager.RunningTaskInfo> tasks) {
        this.tasks.clear();
        this.tasks.addAll(tasks);
    }

    public void setAppTasks(List<ActivityManager.AppTask> appTasks) {
        this.appTasks.clear();
        this.appTasks.addAll(appTasks);
    }

    public void setServices(List<ActivityManager.RunningServiceInfo> services) {
        this.services.clear();
        this.services.addAll(services);
    }

    public void setProcesses(List<ActivityManager.RunningAppProcessInfo> processes) {
        ShadowActivityManager.processes.clear();
        ShadowActivityManager.processes.addAll(processes);
    }

    public String getBackgroundPackage() {
        return this.backgroundPackage;
    }

    public void setMemoryClass(int memoryClass) {
        this.memoryClass = memoryClass;
    }

    public void setMemoryInfo(ActivityManager.MemoryInfo memoryInfo) {
        this.memoryInfo = memoryInfo;
    }

    @Implementation(minSdk=26)
    protected static IActivityManager getService() {
        return (IActivityManager)ReflectionHelpers.createNullProxy(IActivityManager.class);
    }

    @Implementation(minSdk=19)
    protected boolean isLowRamDevice() {
        if (this.isLowRamDeviceOverride != null) {
            return this.isLowRamDeviceOverride;
        }
        return (Boolean)Shadow.directlyOn((Object)this.realObject, ActivityManager.class, (String)"isLowRamDevice", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public void setIsLowRamDevice(boolean isLowRamDevice) {
        this.isLowRamDeviceOverride = isLowRamDevice;
    }

    @Implementation(minSdk=23)
    protected int getLockTaskModeState() {
        return this.lockTaskModeState;
    }

    @Implementation(minSdk=21)
    protected boolean isInLockTaskMode() {
        return this.getLockTaskModeState() != 0;
    }

    public void setLockTaskModeState(int lockTaskModeState) {
        this.lockTaskModeState = lockTaskModeState;
    }

    @Resetter
    public static void reset() {
        processes.clear();
    }

    @Implementation(minSdk=28)
    protected boolean isBackgroundRestricted() {
        return this.isBackgroundRestricted;
    }

    public void setBackgroundRestricted(boolean isBackgroundRestricted) {
        this.isBackgroundRestricted = isBackgroundRestricted;
    }

    @Implementation(minSdk=30)
    protected Object getHistoricalProcessExitReasons(Object packageName, Object pid, Object maxNum) {
        return this.appExitInfoList.stream().filter(appExitInfo -> (Integer)pid == 0 || ((ApplicationExitInfo)appExitInfo).getPid() == ((Integer)pid).intValue()).limit((Integer)maxNum == 0 ? (long)this.appExitInfoList.size() : (long)((Integer)maxNum).intValue()).collect(Collectors.toCollection(ArrayList::new));
    }

    public void addApplicationExitInfo(String processName, int pid, int reason, int status) {
        ApplicationExitInfo appExitInfo = new ApplicationExitInfo();
        appExitInfo.setProcessName(processName);
        appExitInfo.setPid(pid);
        appExitInfo.setReason(reason);
        appExitInfo.setStatus(status);
        this.appExitInfoList.addFirst(appExitInfo);
    }

    @Implementation
    protected boolean clearApplicationUserData(String packageName, IPackageDataObserver observer) {
        RuntimeEnvironment.application.getPackageManager().clearApplicationUserData(packageName, observer);
        return true;
    }

    public boolean isApplicationUserDataCleared() {
        PackageManager packageManager = RuntimeEnvironment.application.getPackageManager();
        return ((ShadowApplicationPackageManager)Shadow.extract((Object)packageManager)).getClearedApplicationUserDataPackages().contains(RuntimeEnvironment.application.getPackageName());
    }
}

