/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.FrameMetrics;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

public final class FrameMetricsBuilder {
    private static final int FLAGS_INDEX = 0;
    private static final int INTENDED_VSYNC_INDEX = 1;
    private static final int VSYNC_INDEX = 2;
    private static final int FRAME_STATS_COUNT = 16;
    private final Map<Integer, Long> metricsMap = new HashMap<Integer, Long>();
    private long syncDelayTimeNanos = 0L;

    public FrameMetricsBuilder setMetric(int metric, long value) {
        if (metric == 9 && (value > 1L || value < 0L)) {
            throw new IllegalArgumentException("For boolean metric FIRST_DRAW_FRAME, use 0 or 1 to represent false and true");
        }
        this.metricsMap.put(metric, value);
        return this;
    }

    public FrameMetricsBuilder setSyncDelayTimeNanos(long syncDelayTimeNanos) {
        this.syncDelayTimeNanos = syncDelayTimeNanos;
        return this;
    }

    public FrameMetrics build() throws Exception {
        int metric;
        FrameMetrics metrics = (FrameMetrics)ReflectionHelpers.callConstructor(FrameMetrics.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        long[] timingData = new long[16];
        timingData[0] = this.getMetric(9);
        timingData[1] = this.getMetric(10);
        timingData[2] = this.getMetric(11);
        for (metric = 0; metric <= 4; ++metric) {
            timingData[this.getEndIndexForMetric((int)metric)] = timingData[this.getStartIndexForMetric(metric)] + this.getMetric(metric);
        }
        timingData[this.getStartIndexForMetric((int)5)] = timingData[this.getEndIndexForMetric(4)] + this.syncDelayTimeNanos;
        for (metric = 5; metric < 8; ++metric) {
            timingData[this.getEndIndexForMetric((int)metric)] = timingData[this.getStartIndexForMetric(metric)] + this.getMetric(metric);
        }
        ((FrameMetricsReflector)Reflector.reflector(FrameMetricsReflector.class, (Object)metrics)).setTimingData(timingData);
        return metrics;
    }

    private int getStartIndexForMetric(int metric) {
        return ((FrameMetricsReflector)Reflector.reflector(FrameMetricsReflector.class)).getDurations()[2 * metric];
    }

    private int getEndIndexForMetric(int metric) {
        return ((FrameMetricsReflector)Reflector.reflector(FrameMetricsReflector.class)).getDurations()[2 * metric + 1];
    }

    private long getMetric(int metric) {
        if (this.metricsMap.containsKey(metric)) {
            return this.metricsMap.get(metric);
        }
        return 0L;
    }

    @ForType(value=FrameMetrics.class)
    private static interface FrameMetricsReflector {
        @Accessor(value="mTimingData")
        public void setTimingData(long[] var1);

        @Accessor(value="DURATIONS")
        @Static
        public int[] getDurations();

        @Accessor(value="FRAME_INFO_FLAG_FIRST_DRAW")
        public int getFrameInfoFlagFirstDraw();
    }
}

