/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Trace;
import android.util.Log;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Queue;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Trace.class)
public class ShadowTrace {
    private static final String TAG = "ShadowTrace";
    private static final ThreadLocal<Deque<String>> currentSections = ThreadLocal.withInitial(() -> new ArrayDeque());
    private static final ThreadLocal<Queue<String>> previousSections = ThreadLocal.withInitial(() -> new ArrayDeque());
    private static final boolean CRASH_ON_INCORRECT_USAGE_DEFAULT = true;
    private static boolean crashOnIncorrectUsage = true;
    private static boolean appTracingAllowed = true;
    private static boolean isEnabled = true;
    private static final long TRACE_TAG_APP = 4096L;
    private static final int MAX_SECTION_NAME_LEN = 127;

    @Implementation(minSdk=18)
    protected static void beginSection(String sectionName) {
        if (Trace.isTagEnabled((long)4096L)) {
            if (crashOnIncorrectUsage) {
                if (sectionName.length() > 127) {
                    throw new IllegalArgumentException("sectionName is too long");
                }
            } else {
                if (sectionName == null) {
                    Log.w((String)TAG, (String)"Section name cannot be null");
                    return;
                }
                if (sectionName.length() > 127) {
                    Log.w((String)TAG, (String)"Section name is too long");
                    return;
                }
            }
            currentSections.get().addFirst(sectionName);
        }
    }

    @Implementation(minSdk=18)
    protected static void endSection() {
        if (Trace.isTagEnabled((long)4096L)) {
            if (currentSections.get().isEmpty()) {
                Log.e((String)TAG, (String)"Trying to end a trace section that was never started");
                return;
            }
            previousSections.get().offer(currentSections.get().removeFirst());
        }
    }

    @Implementation(minSdk=18)
    protected static boolean isTagEnabled(long traceTag) {
        if (traceTag == 4096L) {
            return appTracingAllowed;
        }
        return (Boolean)Shadow.directlyOn(Trace.class, (String)"isTagEnabled", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)traceTag)});
    }

    @Implementation(minSdk=18)
    protected static void setAppTracingAllowed(boolean appTracingAllowed) {
        ShadowTrace.appTracingAllowed = appTracingAllowed;
    }

    @Implementation(minSdk=29)
    protected static boolean isEnabled() {
        return isEnabled;
    }

    public static void setEnabled(boolean enabled) {
        isEnabled = enabled;
    }

    public static Deque<String> getCurrentSections() {
        return new ArrayDeque<String>((Collection)currentSections.get());
    }

    public static Queue<String> getPreviousSections() {
        return new ArrayDeque<String>((Collection)previousSections.get());
    }

    public static void doNotUseSetCrashOnIncorrectUsage(boolean crashOnIncorrectUsage) {
        ShadowTrace.crashOnIncorrectUsage = crashOnIncorrectUsage;
    }

    @Resetter
    public static void reset() {
        currentSections.get().clear();
        previousSections.get().clear();
        isEnabled = true;
        crashOnIncorrectUsage = true;
    }
}

