/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SystemProperties;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SystemProperties.class, isInAndroidSdk=false)
public class ShadowSystemProperties {
    private static Properties buildProperties = null;

    @Implementation
    protected static String native_get(String key) {
        return ShadowSystemProperties.native_get(key, "");
    }

    @Implementation
    protected static String native_get(String key, String def) {
        String value = ShadowSystemProperties.getProperty(key);
        return value == null ? def : value;
    }

    @Implementation
    protected static int native_get_int(String key, int def) {
        String stringValue = ShadowSystemProperties.getProperty(key);
        return stringValue == null ? def : Integer.parseInt(stringValue);
    }

    @Implementation
    protected static long native_get_long(String key, long def) {
        String stringValue = ShadowSystemProperties.getProperty(key);
        return stringValue == null ? def : Long.parseLong(stringValue);
    }

    @Implementation
    protected static boolean native_get_boolean(String key, boolean def) {
        String stringValue = ShadowSystemProperties.getProperty(key);
        return stringValue == null ? def : Boolean.parseBoolean(stringValue);
    }

    @Implementation
    protected static void native_set(String key, String val) {
        if (val == null) {
            ShadowSystemProperties.loadProperties().remove(key);
        } else {
            ShadowSystemProperties.loadProperties().setProperty(key, val);
        }
    }

    public static void override(String key, String val) {
        SystemProperties.set((String)key, (String)val);
    }

    private static synchronized String getProperty(String key) {
        return ShadowSystemProperties.loadProperties().getProperty(key);
    }

    private static synchronized Properties loadProperties() {
        if (buildProperties == null) {
            ClassLoader cl = SystemProperties.class.getClassLoader();
            URL urlFromCl = cl.getResource("build.prop");
            try (InputStream is = cl.getResourceAsStream("build.prop");){
                Preconditions.checkNotNull((Object)is, (Object)"could not find build.prop");
                buildProperties = new Properties();
                buildProperties.load(is);
                ShadowSystemProperties.setDefaults(buildProperties);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to load build.prop", e);
            }
        }
        return buildProperties;
    }

    private static void setDefaults(Properties buildProperties) {
        buildProperties.setProperty("ro.build.fingerprint", "robolectric");
        buildProperties.setProperty("ro.product.device", "robolectric");
        buildProperties.setProperty("ro.product.name", "robolectric");
        buildProperties.setProperty("ro.product.model", "robolectric");
        buildProperties.setProperty("ro.hardware", "robolectric");
        buildProperties.setProperty("ro.build.characteristics", "robolectric");
        buildProperties.setProperty("ro.product.cpu.abi", "unknown");
        buildProperties.setProperty("ro.product.cpu.abi2", "unknown");
        buildProperties.setProperty("ro.product.cpu.abilist", "armeabi-v7a");
        buildProperties.setProperty("ro.product.cpu.abilist32", "armeabi-v7a,armeabi");
        buildProperties.setProperty("ro.product.cpu.abilist64", "armeabi-v7a,armeabi");
    }

    @Resetter
    public static synchronized void reset() {
        ReflectionHelpers.setStaticField(SystemProperties.class, (String)"sChangeCallbacks", new ArrayList());
        buildProperties = null;
    }
}

