/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.location.Criteria;
import android.location.GnssStatus;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.location.OnNmeaMessageListener;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.Process;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowSettings;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=LocationManager.class, looseSignatures=true)
public class ShadowLocationManager {
    @Nullable
    private static Constructor<LocationProvider> locationProviderConstructor;
    @RealObject
    private LocationManager realLocationManager;
    @GuardedBy(value="providers")
    private final HashSet<ProviderEntry> providers = new HashSet();
    @GuardedBy(value="gpsStatusListeners")
    private final HashSet<GpsStatus.Listener> gpsStatusListeners = new HashSet();
    @GuardedBy(value="gnssStatusCallbacks")
    private final Map<GnssStatus.Callback, Handler> gnssStatusCallbacks = new LinkedHashMap<GnssStatus.Callback, Handler>();
    @GuardedBy(value="nmeaMessageListeners")
    private final Map<OnNmeaMessageListener, Handler> nmeaMessageListeners = new LinkedHashMap<OnNmeaMessageListener, Handler>();

    public ShadowLocationManager() {
        this.providers.add(new ProviderEntry("gps", new ProviderProperties(true, true, false, false, true, true, true, 3, 1)));
        this.providers.add(new ProviderEntry("network", new ProviderProperties(false, false, false, false, true, true, true, 1, 2)));
        this.providers.add(new ProviderEntry("passive", new ProviderProperties(false, false, false, false, false, false, false, 1, 2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected List<String> getAllProviders() {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            ArrayList<String> allProviders = new ArrayList<String>(this.providers.size());
            for (ProviderEntry providerEntry : this.providers) {
                allProviders.add(providerEntry.name);
            }
            return allProviders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    @Nullable
    protected LocationProvider getProvider(String name) {
        if (RuntimeEnvironment.getApiLevel() < 19) {
            return null;
        }
        ProviderEntry providerEntry = this.getProviderEntry(name);
        if (providerEntry == null) {
            return null;
        }
        try {
            Class<ShadowLocationManager> clazz = ShadowLocationManager.class;
            synchronized (ShadowLocationManager.class) {
                if (locationProviderConstructor == null) {
                    locationProviderConstructor = LocationProvider.class.getConstructor(String.class, com.android.internal.location.ProviderProperties.class);
                    locationProviderConstructor.setAccessible(true);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return locationProviderConstructor.newInstance(name, providerEntry.createRealProperties());
            }
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Implementation
    protected List<String> getProviders(boolean enabledOnly) {
        return this.getProviders(null, enabledOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected List<String> getProviders(@Nullable Criteria criteria, boolean enabled) {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            ArrayList<String> matchingProviders = new ArrayList<String>(this.providers.size());
            for (ProviderEntry providerEntry : this.providers) {
                if (enabled && !this.isProviderEnabled(providerEntry.name) || criteria != null && !providerEntry.meetsCriteria(criteria)) continue;
                matchingProviders.add(providerEntry.name);
            }
            return matchingProviders;
        }
    }

    @Implementation
    @Nullable
    protected String getBestProvider(Criteria criteria, boolean enabled) {
        List<String> providers = this.getProviders(criteria, enabled);
        if (providers.isEmpty()) {
            providers = this.getProviders(null, enabled);
        }
        if (!providers.isEmpty()) {
            if (providers.contains("gps")) {
                return "gps";
            }
            if (providers.contains("network")) {
                return "network";
            }
            return providers.get(0);
        }
        return null;
    }

    @Implementation
    protected boolean isProviderEnabled(String provider) {
        if (RuntimeEnvironment.getApiLevel() >= 28 && !this.isLocationEnabled()) {
            return false;
        }
        ProviderEntry entry = this.getProviderEntry(provider);
        return entry != null && entry.isEnabled();
    }

    public void removeProvider(String name) {
        this.removeProviderEntry(name);
    }

    public void setProviderProperties(String name, @Nullable ProviderProperties properties) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.getOrCreateProviderEntry(name).properties = properties;
    }

    public void setProviderEnabled(String name, boolean enabled) {
        this.getOrCreateProviderEntry(name).setEnabled(enabled);
    }

    @Implementation(minSdk=28)
    protected boolean isLocationEnabledForUser(UserHandle userHandle) {
        return this.isLocationEnabled();
    }

    private boolean isLocationEnabled() {
        return this.getLocationMode() != 0;
    }

    @Implementation(minSdk=28)
    protected void setLocationEnabledForUser(boolean enabled, UserHandle userHandle) {
        this.setLocationModeInternal(enabled ? 3 : 0);
    }

    public void setLocationEnabled(boolean enabled) {
        this.setLocationEnabledForUser(enabled, Process.myUserHandle());
    }

    private int getLocationMode() {
        return Settings.Secure.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"location_mode", (int)0);
    }

    public void setLocationMode(int locationMode) {
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            throw new AssertionError((Object)"Tests may not set location mode directly on P and above. Instead, use setLocationEnabled() and setProviderEnabled() in combination to achieve the desired result.");
        }
        this.setLocationModeInternal(locationMode);
    }

    private void setLocationModeInternal(int locationMode) {
        Settings.Secure.putInt((ContentResolver)this.getContext().getContentResolver(), (String)"location_mode", (int)locationMode);
    }

    @Implementation
    @Nullable
    protected Location getLastKnownLocation(String provider) {
        ProviderEntry providerEntry = this.getProviderEntry(provider);
        if (providerEntry == null) {
            return null;
        }
        return providerEntry.lastLocation;
    }

    public void setLastKnownLocation(String provider, @Nullable Location location) {
        this.getOrCreateProviderEntry(provider).lastLocation = location;
    }

    @Implementation
    protected void requestSingleUpdate(String provider, LocationListener listener, @Nullable Looper looper) {
        LocationRequest request = new LocationRequest(provider, 0L, 0.0f, true);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    @Implementation
    protected void requestSingleUpdate(Criteria criteria, LocationListener listener, @Nullable Looper looper) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        LocationRequest request = new LocationRequest(bestProvider, 0L, 0.0f, true);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    @Implementation
    protected void requestSingleUpdate(String provider, PendingIntent intent) {
        LocationRequest request = new LocationRequest(provider, 0L, 0.0f, true);
        this.requestLocationUpdates(request, null, null, intent);
    }

    @Implementation
    protected void requestSingleUpdate(Criteria criteria, PendingIntent intent) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        LocationRequest request = new LocationRequest(bestProvider, 0L, 0.0f, true);
        this.requestLocationUpdates(request, null, null, intent);
    }

    @Implementation
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener) {
        LocationRequest request = new LocationRequest(provider, minTime, minDistance, false);
        this.requestLocationUpdates(request, listener, null, null);
    }

    @Implementation
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener, @Nullable Looper looper) {
        LocationRequest request = new LocationRequest(provider, minTime, minDistance, false);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    @Implementation
    protected void requestLocationUpdates(long minTime, float minDistance, Criteria criteria, LocationListener listener, @Nullable Looper looper) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        LocationRequest request = new LocationRequest(bestProvider, minTime, minDistance, false);
        this.requestLocationUpdates(request, listener, looper, null);
    }

    @Implementation
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, PendingIntent intent) {
        LocationRequest request = new LocationRequest(provider, minTime, minDistance, false);
        this.requestLocationUpdates(request, null, null, intent);
    }

    @Implementation
    protected void requestLocationUpdates(long minTime, float minDistance, Criteria criteria, PendingIntent intent) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        LocationRequest request = new LocationRequest(bestProvider, minTime, minDistance, false);
        this.requestLocationUpdates(request, null, null, intent);
    }

    @Implementation(minSdk=21)
    protected void requestLocationUpdates(@Nullable Object oRequest, Object listener, @Nullable Object looper) {
        android.location.LocationRequest ogRequest = (android.location.LocationRequest)oRequest;
        if (ogRequest == null) {
            ogRequest = new android.location.LocationRequest();
        }
        LocationRequest request = new LocationRequest(ogRequest.getProvider(), ogRequest.getFastestInterval(), ogRequest.getSmallestDisplacement(), ogRequest.getNumUpdates() == 1);
        this.requestLocationUpdates(request, (LocationListener)listener, (Looper)looper, null);
    }

    @Implementation(minSdk=21)
    protected void requestLocationUpdates(@Nullable Object oRequest, Object intent) {
        android.location.LocationRequest ogRequest = (android.location.LocationRequest)oRequest;
        if (ogRequest == null) {
            ogRequest = new android.location.LocationRequest();
        }
        LocationRequest request = new LocationRequest(ogRequest.getProvider(), ogRequest.getFastestInterval(), ogRequest.getSmallestDisplacement(), ogRequest.getNumUpdates() == 1);
        this.requestLocationUpdates(request, null, null, (PendingIntent)intent);
    }

    private void requestLocationUpdates(LocationRequest request, @Nullable LocationListener locationListener, @Nullable Looper looper, @Nullable PendingIntent pendingIntent) {
        if (locationListener == null && pendingIntent == null) {
            throw new IllegalArgumentException("must supply listener or pending intent");
        }
        if (locationListener != null && looper == null) {
            looper = Looper.getMainLooper();
        }
        this.getOrCreateProviderEntry(request.provider).addListener(locationListener, looper, pendingIntent, request);
    }

    @Implementation
    protected void removeUpdates(LocationListener listener) {
        this.removeListener(listener, null);
    }

    @Implementation
    protected void removeUpdates(PendingIntent pendingIntent) {
        this.removeListener(null, pendingIntent);
    }

    @Implementation(minSdk=28)
    protected boolean injectLocation(Location location) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected boolean addGpsStatusListener(GpsStatus.Listener listener) {
        HashSet<GpsStatus.Listener> hashSet = this.gpsStatusListeners;
        synchronized (hashSet) {
            this.gpsStatusListeners.add(listener);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void removeGpsStatusListener(GpsStatus.Listener listener) {
        HashSet<GpsStatus.Listener> hashSet = this.gpsStatusListeners;
        synchronized (hashSet) {
            this.gpsStatusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GpsStatus.Listener> getGpsStatusListeners() {
        HashSet<GpsStatus.Listener> hashSet = this.gpsStatusListeners;
        synchronized (hashSet) {
            return new ArrayList<GpsStatus.Listener>(this.gpsStatusListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected boolean registerGnssStatusCallback(GnssStatus.Callback callback, Handler handler) {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        Map<GnssStatus.Callback, Handler> map = this.gnssStatusCallbacks;
        synchronized (map) {
            this.gnssStatusCallbacks.put(callback, handler);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected void unregisterGnssStatusCallback(GnssStatus.Callback callback) {
        Map<GnssStatus.Callback, Handler> map = this.gnssStatusCallbacks;
        synchronized (map) {
            this.gnssStatusCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGnssStatus(GnssStatus status) {
        LinkedHashMap<GnssStatus.Callback, Handler> callbacks;
        Map<GnssStatus.Callback, Handler> map = this.gnssStatusCallbacks;
        synchronized (map) {
            callbacks = new LinkedHashMap<GnssStatus.Callback, Handler>(this.gnssStatusCallbacks);
        }
        for (Map.Entry entry : callbacks.entrySet()) {
            ((Handler)entry.getValue()).post(() -> ((GnssStatus.Callback)callback.getKey()).onSatelliteStatusChanged(status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected boolean addNmeaListener(OnNmeaMessageListener listener, Handler handler) {
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        Map<OnNmeaMessageListener, Handler> map = this.nmeaMessageListeners;
        synchronized (map) {
            this.nmeaMessageListeners.put(listener, handler);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected void removeNmeaListener(OnNmeaMessageListener listener) {
        Map<OnNmeaMessageListener, Handler> map = this.nmeaMessageListeners;
        synchronized (map) {
            this.nmeaMessageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNmeaMessage(String message, long timestamp) {
        LinkedHashMap<OnNmeaMessageListener, Handler> listeners;
        Map<OnNmeaMessageListener, Handler> map = this.nmeaMessageListeners;
        synchronized (map) {
            listeners = new LinkedHashMap<OnNmeaMessageListener, Handler>(this.nmeaMessageListeners);
        }
        for (Map.Entry entry : listeners.entrySet()) {
            ((Handler)entry.getValue()).post(() -> ((OnNmeaMessageListener)listener.getKey()).onNmeaMessage(message, timestamp));
        }
    }

    @Deprecated
    public List<LocationListener> getRequestLocationUpdateListeners() {
        return new ArrayList<LocationListener>(this.getLocationUpdateListeners());
    }

    public void simulateLocation(Location location) {
        ProviderEntry passiveProviderEntry;
        if (location == null) {
            throw new NullPointerException();
        }
        ProviderEntry providerEntry = this.getOrCreateProviderEntry(location.getProvider());
        if (!"passive".equals(providerEntry.name)) {
            providerEntry.simulateLocation(location);
        }
        if ((passiveProviderEntry = this.getProviderEntry("passive")) != null) {
            passiveProviderEntry.simulateLocation(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<LocationListener> getLocationUpdateListeners() {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            ArrayList<LocationListener> listeners = new ArrayList<LocationListener>(this.providers.size());
            for (ProviderEntry providerEntry : this.providers) {
                for (ProviderEntry.ListenerEntry listenerEntry : providerEntry.listeners) {
                    if (listenerEntry.locationListener == null || listeners.contains(listenerEntry.locationListener)) continue;
                    listeners.add(listenerEntry.locationListener);
                }
            }
            return listeners;
        }
    }

    @Deprecated
    public List<LocationListener> getLocationUpdateListeners(String provider) {
        ProviderEntry providerEntry = this.getProviderEntry(provider);
        if (providerEntry == null) {
            return Collections.emptyList();
        }
        ArrayList<LocationListener> listeners = new ArrayList<LocationListener>(providerEntry.listeners.size());
        for (ProviderEntry.ListenerEntry listenerEntry : providerEntry.listeners) {
            if (listenerEntry.locationListener == null) continue;
            listeners.add(listenerEntry.locationListener);
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<PendingIntent> getLocationUpdatePendingIntents() {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            ArrayList<PendingIntent> pendingIntents = new ArrayList<PendingIntent>(this.providers.size());
            for (ProviderEntry providerEntry : this.providers) {
                for (ProviderEntry.ListenerEntry listenerEntry : providerEntry.listeners) {
                    if (listenerEntry.pendingIntent == null || pendingIntents.contains(listenerEntry.pendingIntent)) continue;
                    pendingIntents.add(listenerEntry.pendingIntent);
                }
            }
            return pendingIntents;
        }
    }

    @Deprecated
    public List<PendingIntent> getLocationUpdatePendingIntents(String provider) {
        ProviderEntry providerEntry = this.getProviderEntry(provider);
        if (providerEntry == null) {
            return Collections.emptyList();
        }
        ArrayList<PendingIntent> listeners = new ArrayList<PendingIntent>(providerEntry.listeners.size());
        for (ProviderEntry.ListenerEntry listenerEntry : providerEntry.listeners) {
            if (listenerEntry.pendingIntent == null) continue;
            listeners.add(listenerEntry.pendingIntent);
        }
        return listeners;
    }

    private Context getContext() {
        return (Context)ReflectionHelpers.getField((Object)this.realLocationManager, (String)"mContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListener(@Nullable LocationListener locationListener, @Nullable PendingIntent pendingIntent) {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            for (ProviderEntry providerEntry : this.providers) {
                providerEntry.removeListener(locationListener, pendingIntent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderEntry getOrCreateProviderEntry(String name) {
        if (name == null) {
            throw new IllegalArgumentException("cannot use a null provider");
        }
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            ProviderEntry providerEntry = this.getProviderEntry(name);
            if (providerEntry == null) {
                providerEntry = new ProviderEntry(name, null);
                this.providers.add(providerEntry);
            }
            return providerEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ProviderEntry getProviderEntry(String name) {
        if (name == null) {
            return null;
        }
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            for (ProviderEntry providerEntry : this.providers) {
                if (!name.equals(providerEntry.name)) continue;
                return providerEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProviderEntry(String name) {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            ProviderEntry providerEntry = this.getProviderEntry(name);
            this.providers.remove(providerEntry);
        }
    }

    private static float distanceBetween(Location location1, Location location2) {
        double earthRadius = 3958.75;
        double latDifference = Math.toRadians(location2.getLatitude() - location1.getLatitude());
        double lonDifference = Math.toRadians(location2.getLongitude() - location1.getLongitude());
        double a = Math.sin(latDifference / 2.0) * Math.sin(latDifference / 2.0) + Math.cos(Math.toRadians(location1.getLatitude())) * Math.cos(Math.toRadians(location2.getLatitude())) * Math.sin(lonDifference / 2.0) * Math.sin(lonDifference / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double dist = Math.abs(earthRadius * c);
        int meterConversion = 1609;
        return (float)(dist * (double)meterConversion);
    }

    private static class LocationRequest {
        private final String provider;
        private final long minTime;
        private final float minDistance;
        private final boolean singleShot;

        private LocationRequest(String provider, long minTime, float minDistance, boolean singleShot) {
            this.provider = provider;
            this.minTime = minTime;
            this.minDistance = minDistance;
            this.singleShot = singleShot;
        }
    }

    private final class ProviderEntry {
        private final String name;
        private final CopyOnWriteArraySet<ListenerEntry> listeners;
        @Nullable
        private volatile ProviderProperties properties;
        private boolean enabled;
        private Location lastLocation;

        private ProviderEntry(@Nullable String name, ProviderProperties properties) {
            this.name = name;
            this.listeners = new CopyOnWriteArraySet();
            this.properties = properties;
            switch (name) {
                case "passive": {
                    this.enabled = true;
                    break;
                }
                case "gps": {
                    this.enabled = true;
                    break;
                }
                case "network": {
                    this.enabled = false;
                    break;
                }
                default: {
                    this.enabled = false;
                }
            }
        }

        public boolean isEnabled() {
            if ("passive".equals(this.name) || RuntimeEnvironment.getApiLevel() >= 29) {
                return this.enabled;
            }
            String allowedProviders = Settings.Secure.getString((ContentResolver)ShadowLocationManager.this.getContext().getContentResolver(), (String)"location_providers_allowed");
            if (TextUtils.isEmpty((CharSequence)allowedProviders)) {
                return false;
            }
            return Arrays.asList(allowedProviders.split(",")).contains(this.name);
        }

        public void setEnabled(boolean enabled) {
            int oldLocationMode;
            if ("passive".equals(this.name)) {
                this.enabled = enabled;
                return;
            }
            int newLocationMode = oldLocationMode = ShadowLocationManager.this.getLocationMode();
            if (RuntimeEnvironment.getApiLevel() < 28) {
                if ("gps".equals(this.name)) {
                    if (enabled) {
                        switch (oldLocationMode) {
                            case 0: {
                                newLocationMode = 1;
                                break;
                            }
                            case 2: {
                                newLocationMode = 3;
                                break;
                            }
                        }
                    } else {
                        switch (oldLocationMode) {
                            case 1: {
                                newLocationMode = 0;
                                break;
                            }
                            case 3: {
                                newLocationMode = 2;
                                break;
                            }
                        }
                    }
                } else if ("network".equals(this.name)) {
                    if (enabled) {
                        switch (oldLocationMode) {
                            case 0: {
                                newLocationMode = 2;
                                break;
                            }
                            case 1: {
                                newLocationMode = 3;
                                break;
                            }
                        }
                    } else {
                        switch (oldLocationMode) {
                            case 2: {
                                newLocationMode = 0;
                                break;
                            }
                            case 3: {
                                newLocationMode = 1;
                                break;
                            }
                        }
                    }
                }
            }
            if (newLocationMode != oldLocationMode) {
                ShadowLocationManager.this.setLocationModeInternal(newLocationMode);
            } else if (RuntimeEnvironment.getApiLevel() >= 29) {
                this.enabled = enabled;
                ShadowSettings.ShadowSecure.updateEnabledProviders(ShadowLocationManager.this.getContext().getContentResolver(), this.name, enabled);
            } else {
                ShadowSettings.ShadowSecure.updateEnabledProviders(ShadowLocationManager.this.getContext().getContentResolver(), this.name, enabled);
            }
            for (ListenerEntry listener : this.listeners) {
                if (enabled) {
                    listener.invokeOnProviderEnabled(this.name);
                    continue;
                }
                listener.invokeOnProviderDisabled(this.name);
            }
        }

        public void simulateLocation(Location location) {
            this.lastLocation = new Location(location);
            for (ListenerEntry listenerEntry : this.listeners) {
                listenerEntry.simulateLocation(location);
            }
        }

        public boolean meetsCriteria(Criteria criteria) {
            if ("passive".equals(this.name)) {
                return false;
            }
            ProviderProperties myProperties = this.properties;
            if (myProperties == null) {
                return false;
            }
            return myProperties.meetsCriteria(criteria);
        }

        public com.android.internal.location.ProviderProperties createRealProperties() {
            ProviderProperties myProperties = this.properties;
            if (myProperties == null) {
                return null;
            }
            return new com.android.internal.location.ProviderProperties(myProperties.requiresNetwork, myProperties.requiresSatellite, myProperties.requiresCell, myProperties.hasMonetaryCost, myProperties.supportsAltitude, myProperties.supportsSpeed, myProperties.supportsBearing, myProperties.powerRequirement, myProperties.accuracy);
        }

        public void addListener(@Nullable LocationListener locationListener, Looper looper, @Nullable PendingIntent pendingIntent, LocationRequest request) {
            ListenerEntry entry = locationListener != null ? new ListenerEntry(locationListener, looper, request) : (pendingIntent != null ? new ListenerEntry(pendingIntent, request) : null);
            if (entry != null) {
                this.listeners.add(entry);
            }
        }

        public void removeListener(@Nullable LocationListener locationListener, @Nullable PendingIntent pendingIntent) {
            for (ListenerEntry listenerEntry : this.listeners) {
                if (listenerEntry.locationListener != locationListener || !Objects.equals(listenerEntry.pendingIntent, pendingIntent)) continue;
                this.listeners.remove(listenerEntry);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProviderEntry)) {
                return false;
            }
            ProviderEntry that = (ProviderEntry)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }

        private final class ListenerEntry {
            private final PendingIntent pendingIntent;
            private final LocationListener locationListener;
            private final Handler handler;
            private final LocationRequest locationRequest;
            @Nullable
            Location lastDeliveredLocation;

            private ListenerEntry(PendingIntent pendingIntent, LocationRequest locationRequest) {
                this.pendingIntent = pendingIntent;
                this.locationListener = null;
                this.handler = null;
                this.locationRequest = locationRequest;
            }

            private ListenerEntry(LocationListener locationListener, Looper looper, LocationRequest locationRequest) {
                this.locationListener = locationListener;
                this.pendingIntent = null;
                this.handler = new Handler(looper);
                this.locationRequest = locationRequest;
            }

            public void simulateLocation(Location location) {
                if (this.lastDeliveredLocation != null) {
                    if (location.getTime() - this.lastDeliveredLocation.getTime() < this.locationRequest.minTime) {
                        return;
                    }
                    if (ShadowLocationManager.distanceBetween(location, this.lastDeliveredLocation) < this.locationRequest.minDistance) {
                        return;
                    }
                }
                this.lastDeliveredLocation = new Location(location);
                if (this.locationRequest.singleShot) {
                    ProviderEntry.this.listeners.remove(this);
                }
                if (this.locationListener != null) {
                    this.handler.post(() -> this.locationListener.onLocationChanged(new Location(location)));
                } else if (this.pendingIntent != null) {
                    Intent intent = new Intent();
                    intent.putExtra("location", (Parcelable)new Location(location));
                    try {
                        this.pendingIntent.send(ShadowLocationManager.this.getContext(), 0, intent);
                    }
                    catch (PendingIntent.CanceledException e) {
                        ProviderEntry.this.removeListener(null, this.pendingIntent);
                    }
                }
            }

            public void invokeOnProviderEnabled(String provider) {
                if (this.locationListener != null) {
                    this.handler.post(() -> this.locationListener.onProviderEnabled(provider));
                } else if (this.pendingIntent != null) {
                    Intent intent = new Intent();
                    intent.putExtra("providerEnabled", true);
                    try {
                        this.pendingIntent.send(ShadowLocationManager.this.getContext(), 0, intent);
                    }
                    catch (PendingIntent.CanceledException e) {
                        ProviderEntry.this.removeListener(null, this.pendingIntent);
                    }
                }
            }

            public void invokeOnProviderDisabled(String provider) {
                if (this.locationListener != null) {
                    this.handler.post(() -> this.locationListener.onProviderDisabled(provider));
                } else if (this.pendingIntent != null) {
                    Intent intent = new Intent();
                    intent.putExtra("providerEnabled", false);
                    try {
                        this.pendingIntent.send(ShadowLocationManager.this.getContext(), 0, intent);
                    }
                    catch (PendingIntent.CanceledException e) {
                        ProviderEntry.this.removeListener(null, this.pendingIntent);
                    }
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof ListenerEntry)) {
                    return false;
                }
                ListenerEntry that = (ListenerEntry)o;
                return Objects.equals(this.pendingIntent, that.pendingIntent) && Objects.equals(this.locationListener, that.locationListener);
            }

            public int hashCode() {
                return Objects.hash(this.pendingIntent, this.locationListener);
            }
        }
    }

    public static class ProviderProperties {
        private final boolean requiresNetwork;
        private final boolean requiresSatellite;
        private final boolean requiresCell;
        private final boolean hasMonetaryCost;
        private final boolean supportsAltitude;
        private final boolean supportsSpeed;
        private final boolean supportsBearing;
        private final int powerRequirement;
        private final int accuracy;

        public ProviderProperties(boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
            this.requiresNetwork = requiresNetwork;
            this.requiresSatellite = requiresSatellite;
            this.requiresCell = requiresCell;
            this.hasMonetaryCost = hasMonetaryCost;
            this.supportsAltitude = supportsAltitude;
            this.supportsSpeed = supportsSpeed;
            this.supportsBearing = supportsBearing;
            this.powerRequirement = powerRequirement;
            this.accuracy = accuracy;
        }

        public ProviderProperties(Criteria criteria) {
            this.requiresNetwork = false;
            this.requiresSatellite = false;
            this.requiresCell = false;
            this.hasMonetaryCost = criteria.isCostAllowed();
            this.supportsAltitude = criteria.isAltitudeRequired();
            this.supportsSpeed = criteria.isSpeedRequired();
            this.supportsBearing = criteria.isBearingRequired();
            this.powerRequirement = criteria.getPowerRequirement();
            this.accuracy = criteria.getAccuracy();
        }

        private boolean meetsCriteria(Criteria criteria) {
            if (criteria.getAccuracy() != 0 && criteria.getAccuracy() < this.accuracy) {
                return false;
            }
            if (criteria.getPowerRequirement() != 0 && criteria.getPowerRequirement() < this.powerRequirement) {
                return false;
            }
            if (criteria.isAltitudeRequired() && !this.supportsAltitude) {
                return false;
            }
            if (criteria.isSpeedRequired() && !this.supportsSpeed) {
                return false;
            }
            if (criteria.isBearingRequired() && !this.supportsBearing) {
                return false;
            }
            return criteria.isCostAllowed() || !this.hasMonetaryCost;
        }
    }
}

