/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.IBluetooth;
import android.content.Context;
import android.os.Handler;
import android.os.ParcelUuid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowBluetoothGatt;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=BluetoothDevice.class)
public class ShadowBluetoothDevice {
    private static BluetoothSocket bluetoothSocket = null;
    @RealObject
    private BluetoothDevice realBluetoothDevice;
    private String name;
    private ParcelUuid[] uuids;
    private int bondState = 10;
    private boolean createdBond = false;
    private boolean fetchUuidsWithSdpResult = false;
    private int fetchUuidsWithSdpCount = 0;
    private int type = 0;
    private final List<BluetoothGatt> bluetoothGatts = new ArrayList<BluetoothGatt>();
    private Boolean pairingConfirmation = null;
    private byte[] pin = null;
    private String alias;
    private boolean shouldThrowOnGetAliasName = false;
    private BluetoothClass bluetoothClass = null;

    public static BluetoothDevice newInstance(String address) {
        return (BluetoothDevice)ReflectionHelpers.callConstructor(BluetoothDevice.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)address)});
    }

    @Resetter
    public static void reset() {
        bluetoothSocket = null;
    }

    @Implementation
    protected static IBluetooth getService() {
        try {
            return (IBluetooth)Shadow.directlyOn(BluetoothDevice.class, (String)"getService", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setThrowOnGetAliasName(boolean shouldThrow) {
        this.shouldThrowOnGetAliasName = shouldThrow;
    }

    @Implementation
    protected String getName() {
        return this.name;
    }

    @Implementation
    protected String getAlias() {
        return this.alias;
    }

    @Implementation
    protected String getAliasName() throws ReflectiveOperationException {
        if (this.shouldThrowOnGetAliasName) {
            throw new ReflectiveOperationException("Exception on getAliasName");
        }
        String name = this.getAlias();
        return name != null ? name : this.getName();
    }

    public void setType(int type) {
        this.type = type;
    }

    @Implementation(minSdk=18)
    protected int getType() {
        return this.type;
    }

    public void setUuids(ParcelUuid[] uuids) {
        this.uuids = uuids;
    }

    @Implementation
    protected ParcelUuid[] getUuids() {
        return this.uuids;
    }

    public void setBondState(int bondState) {
        this.bondState = bondState;
    }

    @Implementation
    protected int getBondState() {
        return this.bondState;
    }

    public void setCreatedBond(boolean createdBond) {
        this.createdBond = createdBond;
    }

    @Implementation
    protected boolean createBond() {
        return this.createdBond;
    }

    @Implementation
    protected boolean setPin(byte[] pin) {
        this.pin = pin;
        return true;
    }

    public byte[] getPin() {
        return this.pin;
    }

    @Implementation
    public boolean setPairingConfirmation(boolean confirm) {
        this.pairingConfirmation = confirm;
        return true;
    }

    public Boolean getPairingConfirmation() {
        return this.pairingConfirmation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected BluetoothSocket createRfcommSocketToServiceRecord(UUID uuid) throws IOException {
        Class<ShadowBluetoothDevice> clazz = ShadowBluetoothDevice.class;
        synchronized (ShadowBluetoothDevice.class) {
            if (bluetoothSocket == null) {
                bluetoothSocket = (BluetoothSocket)Shadow.newInstanceOf(BluetoothSocket.class);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bluetoothSocket;
        }
    }

    public void setFetchUuidsWithSdpResult(boolean fetchUuidsWithSdpResult) {
        this.fetchUuidsWithSdpResult = fetchUuidsWithSdpResult;
    }

    @Implementation
    protected boolean fetchUuidsWithSdp() {
        ++this.fetchUuidsWithSdpCount;
        return this.fetchUuidsWithSdpResult;
    }

    public int getFetchUuidsWithSdpCount() {
        return this.fetchUuidsWithSdpCount;
    }

    @Implementation(minSdk=18)
    protected BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback) {
        return this.connectGatt(callback);
    }

    @Implementation(minSdk=23)
    protected BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport) {
        return this.connectGatt(callback);
    }

    @Implementation(minSdk=26)
    protected BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport, int phy, Handler handler) {
        return this.connectGatt(callback);
    }

    private BluetoothGatt connectGatt(BluetoothGattCallback callback) {
        BluetoothGatt bluetoothGatt = ShadowBluetoothGatt.newInstance(this.realBluetoothDevice);
        this.bluetoothGatts.add(bluetoothGatt);
        ShadowBluetoothGatt shadowBluetoothGatt = (ShadowBluetoothGatt)Shadow.extract((Object)bluetoothGatt);
        shadowBluetoothGatt.setGattCallback(callback);
        return bluetoothGatt;
    }

    public List<BluetoothGatt> getBluetoothGatts() {
        return this.bluetoothGatts;
    }

    public void simulateGattConnectionChange(int status, int newState) {
        for (BluetoothGatt bluetoothGatt : this.bluetoothGatts) {
            ShadowBluetoothGatt shadowBluetoothGatt = (ShadowBluetoothGatt)Shadow.extract((Object)bluetoothGatt);
            BluetoothGattCallback gattCallback = shadowBluetoothGatt.getGattCallback();
            gattCallback.onConnectionStateChange(bluetoothGatt, status, newState);
        }
    }

    @Implementation
    public BluetoothClass getBluetoothClass() {
        return this.bluetoothClass;
    }

    public void setBluetoothClass(BluetoothClass bluetoothClass) {
        this.bluetoothClass = bluetoothClass;
    }
}

