/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.content.res.ResourcesImpl;
import android.graphics.drawable.Drawable;
import android.os.ParcelFileDescriptor;
import android.util.LongSparseArray;
import android.util.TypedValue;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.Plural;
import org.robolectric.res.PluralRules;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.TypedResource;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAssetManager;
import org.robolectric.shadows.ShadowLegacyAssetManager;
import org.robolectric.shadows.ShadowResources;
import org.robolectric.shadows.ShadowResourcesImpl;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ResourcesImpl.class, isInAndroidSdk=false, minSdk=24, shadowPicker=ShadowResourcesImpl.Picker.class)
public class ShadowArscResourcesImpl
extends ShadowResourcesImpl {
    private static List<LongSparseArray<?>> resettableArrays;
    @RealObject
    ResourcesImpl realResourcesImpl;

    @Resetter
    public static void reset() {
        if (RuntimeEnvironment.useLegacyResources()) {
            ShadowResourcesImpl.reset();
        }
    }

    private static List<LongSparseArray<?>> obtainResettableArrays() {
        Field[] allFields;
        ArrayList resettableArrays = new ArrayList();
        for (Field field : allFields = Resources.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(LongSparseArray.class)) continue;
            field.setAccessible(true);
            try {
                LongSparseArray longSparseArray = (LongSparseArray)field.get(null);
                if (longSparseArray == null) continue;
                resettableArrays.add(longSparseArray);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return resettableArrays;
    }

    @Implementation(maxSdk=23)
    public String getQuantityString(int id2, int quantity, Object ... formatArgs) throws Resources.NotFoundException {
        String raw = this.getQuantityString(id2, quantity);
        return String.format(Locale.ENGLISH, raw, formatArgs);
    }

    @Implementation(maxSdk=23)
    public String getQuantityString(int resId, int quantity) throws Resources.NotFoundException {
        ShadowLegacyAssetManager shadowAssetManager = ShadowAssetManager.legacyShadowOf(this.realResourcesImpl.getAssets());
        TypedResource typedResource = shadowAssetManager.getResourceTable().getValue(resId, shadowAssetManager.config);
        if (typedResource != null && typedResource instanceof PluralRules) {
            PluralRules pluralRules = (PluralRules)typedResource;
            Plural plural = pluralRules.find(quantity);
            if (plural == null) {
                return null;
            }
            TypedResource resolvedTypedResource = shadowAssetManager.resolve(new TypedResource((Object)plural.getString(), ResType.CHAR_SEQUENCE, pluralRules.getXmlContext()), shadowAssetManager.config, resId);
            return resolvedTypedResource == null ? null : resolvedTypedResource.asString();
        }
        return null;
    }

    @Implementation(maxSdk=23)
    public InputStream openRawResource(int id2) throws Resources.NotFoundException {
        return (InputStream)Shadow.directlyOn((Object)this.realResourcesImpl, ResourcesImpl.class, (String)"openRawResource", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)id2)});
    }

    @Implementation(maxSdk=23)
    public AssetFileDescriptor openRawResourceFd(int id2) throws Resources.NotFoundException {
        InputStream inputStream = this.openRawResource(id2);
        if (!(inputStream instanceof FileInputStream)) {
            return null;
        }
        FileInputStream fis = (FileInputStream)inputStream;
        try {
            return new AssetFileDescriptor(ParcelFileDescriptor.dup((FileDescriptor)fis.getFD()), 0L, fis.getChannel().size());
        }
        catch (IOException e) {
            throw this.newNotFoundException(id2);
        }
    }

    private Resources.NotFoundException newNotFoundException(int id2) {
        ResourceTable resourceTable = ShadowAssetManager.legacyShadowOf(this.realResourcesImpl.getAssets()).getResourceTable();
        ResName resName = resourceTable.getResName(id2);
        if (resName == null) {
            String string = String.valueOf(Integer.toHexString(id2));
            return new Resources.NotFoundException(string.length() != 0 ? "resource ID #0x".concat(string) : new String("resource ID #0x"));
        }
        return new Resources.NotFoundException(resName.getFullyQualifiedName());
    }

    @Implementation(maxSdk=25)
    public Drawable loadDrawable(Resources wrapper, TypedValue value, int id2, Resources.Theme theme, boolean useCache) throws Resources.NotFoundException {
        Drawable drawable2 = (Drawable)Shadow.directlyOn((Object)this.realResourcesImpl, ResourcesImpl.class, (String)"loadDrawable", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Resources.class, (Object)wrapper), ReflectionHelpers.ClassParameter.from(TypedValue.class, (Object)value), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)id2), ReflectionHelpers.ClassParameter.from(Resources.Theme.class, (Object)theme), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)useCache)});
        ShadowResources.setCreatedFromResId(wrapper, id2, drawable2);
        return drawable2;
    }

    @Implementation(minSdk=26)
    public Drawable loadDrawable(Resources wrapper, TypedValue value, int id2, int density, Resources.Theme theme) {
        Drawable drawable2 = (Drawable)Shadow.directlyOn((Object)this.realResourcesImpl, ResourcesImpl.class, (String)"loadDrawable", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Resources.class, (Object)wrapper), ReflectionHelpers.ClassParameter.from(TypedValue.class, (Object)value), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)id2), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)density), ReflectionHelpers.ClassParameter.from(Resources.Theme.class, (Object)theme)});
        ShadowResources.setCreatedFromResId(wrapper, id2, drawable2);
        return drawable2;
    }
}

