/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.database.sqlite.SQLiteAbortException;
import android.database.sqlite.SQLiteAccessPermException;
import android.database.sqlite.SQLiteBindOrColumnIndexOutOfRangeException;
import android.database.sqlite.SQLiteBlobTooBigException;
import android.database.sqlite.SQLiteCantOpenDatabaseException;
import android.database.sqlite.SQLiteConnection;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteCustomFunction;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteDatatypeMismatchException;
import android.database.sqlite.SQLiteDiskIOException;
import android.database.sqlite.SQLiteDoneException;
import android.database.sqlite.SQLiteFullException;
import android.database.sqlite.SQLiteMisuseException;
import android.database.sqlite.SQLiteOutOfMemoryException;
import android.database.sqlite.SQLiteReadOnlyDatabaseException;
import android.database.sqlite.SQLiteTableLockedException;
import android.os.OperationCanceledException;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowCursorWindow;
import org.robolectric.shadows.util.SQLiteLibraryLoader;

@Implements(value=SQLiteConnection.class, isInAndroidSdk=false)
public class ShadowSQLiteConnection {
    private static final String IN_MEMORY_PATH = ":memory:";
    private static final Connections CONNECTIONS = new Connections();
    private static final Pattern COLLATE_LOCALIZED_UNICODE_PATTERN = Pattern.compile("\\s+COLLATE\\s+(LOCALIZED|UNICODE)", 2);
    private static final int IGNORED_REINDEX_STMT = -2;
    private static AtomicBoolean useInMemoryDatabase = new AtomicBoolean();

    public static void setUseInMemoryDatabase(boolean value) {
        useInMemoryDatabase.set(value);
    }

    @Implementation(maxSdk=26)
    public static Number nativeOpen(String path, int openFlags, String label, boolean enableTrace, boolean enableProfile) {
        SQLiteLibraryLoader.load();
        return RuntimeEnvironment.castNativePtr(CONNECTIONS.open(path));
    }

    @Implementation(minSdk=27)
    public static long nativeOpen(String path, int openFlags, String label, boolean enableTrace, boolean enableProfile, int lookasideSlotSize, int lookasideSlotCount) {
        return ShadowSQLiteConnection.nativeOpen(path, openFlags, label, enableTrace, enableProfile).longValue();
    }

    @Implementation(maxSdk=20)
    public static int nativePrepareStatement(int connectionPtr, String sql) {
        return (int)ShadowSQLiteConnection.nativePrepareStatement((long)connectionPtr, sql);
    }

    @Implementation(minSdk=21)
    public static long nativePrepareStatement(long connectionPtr, String sql) {
        String newSql = ShadowSQLiteConnection.convertSQLWithLocalizedUnicodeCollator(sql);
        return CONNECTIONS.prepareStatement(connectionPtr, newSql);
    }

    static String convertSQLWithLocalizedUnicodeCollator(String sql) {
        Matcher matcher = COLLATE_LOCALIZED_UNICODE_PATTERN.matcher(sql);
        return matcher.replaceAll(" COLLATE NOCASE");
    }

    @Resetter
    public static void reset() {
        CONNECTIONS.reset();
        useInMemoryDatabase.set(false);
    }

    @Implementation(maxSdk=20)
    public static void nativeClose(int connectionPtr) {
        ShadowSQLiteConnection.nativeClose((long)connectionPtr);
    }

    @Implementation(minSdk=21)
    public static void nativeClose(long connectionPtr) {
        CONNECTIONS.close(connectionPtr);
    }

    @Implementation(maxSdk=20)
    public static void nativeFinalizeStatement(int connectionPtr, int statementPtr) {
        ShadowSQLiteConnection.nativeFinalizeStatement((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static void nativeFinalizeStatement(long connectionPtr, long statementPtr) {
        CONNECTIONS.finalizeStmt(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=20)
    public static int nativeGetParameterCount(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeGetParameterCount((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static int nativeGetParameterCount(long connectionPtr, long statementPtr) {
        return CONNECTIONS.getParameterCount(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=20)
    public static boolean nativeIsReadOnly(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeIsReadOnly((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static boolean nativeIsReadOnly(long connectionPtr, long statementPtr) {
        return CONNECTIONS.isReadOnly(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=20)
    public static long nativeExecuteForLong(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeExecuteForLong((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static long nativeExecuteForLong(long connectionPtr, long statementPtr) {
        return CONNECTIONS.executeForLong(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=20)
    public static void nativeExecute(int connectionPtr, int statementPtr) {
        ShadowSQLiteConnection.nativeExecute((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static void nativeExecute(long connectionPtr, long statementPtr) {
        CONNECTIONS.executeStatement(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=20)
    public static String nativeExecuteForString(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeExecuteForString((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static String nativeExecuteForString(long connectionPtr, long statementPtr) {
        return CONNECTIONS.executeForString(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=20)
    public static int nativeGetColumnCount(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeGetColumnCount((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static int nativeGetColumnCount(long connectionPtr, long statementPtr) {
        return CONNECTIONS.getColumnCount(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=20)
    public static String nativeGetColumnName(int connectionPtr, int statementPtr, int index) {
        return ShadowSQLiteConnection.nativeGetColumnName((long)connectionPtr, (long)statementPtr, index);
    }

    @Implementation(minSdk=21)
    public static String nativeGetColumnName(long connectionPtr, long statementPtr, int index) {
        return CONNECTIONS.getColumnName(connectionPtr, statementPtr, index);
    }

    @Implementation(maxSdk=20)
    public static void nativeBindNull(int connectionPtr, int statementPtr, int index) {
        ShadowSQLiteConnection.nativeBindNull((long)connectionPtr, (long)statementPtr, index);
    }

    @Implementation(minSdk=21)
    public static void nativeBindNull(long connectionPtr, long statementPtr, int index) {
        CONNECTIONS.bindNull(connectionPtr, statementPtr, index);
    }

    @Implementation(maxSdk=20)
    public static void nativeBindLong(int connectionPtr, int statementPtr, int index, long value) {
        ShadowSQLiteConnection.nativeBindLong((long)connectionPtr, (long)statementPtr, index, value);
    }

    @Implementation(minSdk=21)
    public static void nativeBindLong(long connectionPtr, long statementPtr, int index, long value) {
        CONNECTIONS.bindLong(connectionPtr, statementPtr, index, value);
    }

    @Implementation(maxSdk=20)
    public static void nativeBindDouble(int connectionPtr, int statementPtr, int index, double value) {
        ShadowSQLiteConnection.nativeBindDouble((long)connectionPtr, (long)statementPtr, index, value);
    }

    @Implementation(minSdk=21)
    public static void nativeBindDouble(long connectionPtr, long statementPtr, int index, double value) {
        CONNECTIONS.bindDouble(connectionPtr, statementPtr, index, value);
    }

    @Implementation(maxSdk=20)
    public static void nativeBindString(int connectionPtr, int statementPtr, int index, String value) {
        ShadowSQLiteConnection.nativeBindString((long)connectionPtr, (long)statementPtr, index, value);
    }

    @Implementation(minSdk=21)
    public static void nativeBindString(long connectionPtr, long statementPtr, int index, String value) {
        CONNECTIONS.bindString(connectionPtr, statementPtr, index, value);
    }

    @Implementation(maxSdk=20)
    public static void nativeBindBlob(int connectionPtr, int statementPtr, int index, byte[] value) {
        ShadowSQLiteConnection.nativeBindBlob((long)connectionPtr, (long)statementPtr, index, value);
    }

    @Implementation(minSdk=21)
    public static void nativeBindBlob(long connectionPtr, long statementPtr, int index, byte[] value) {
        CONNECTIONS.bindBlob(connectionPtr, statementPtr, index, value);
    }

    @Implementation(maxSdk=20)
    public static void nativeRegisterLocalizedCollators(int connectionPtr, String locale) {
        ShadowSQLiteConnection.nativeRegisterLocalizedCollators((long)connectionPtr, locale);
    }

    @Implementation(minSdk=21)
    public static void nativeRegisterLocalizedCollators(long connectionPtr, String locale) {
    }

    @Implementation(maxSdk=20)
    public static int nativeExecuteForChangedRowCount(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeExecuteForChangedRowCount((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static int nativeExecuteForChangedRowCount(long connectionPtr, long statementPtr) {
        return CONNECTIONS.executeForChangedRowCount(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=20)
    public static long nativeExecuteForLastInsertedRowId(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeExecuteForLastInsertedRowId((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static long nativeExecuteForLastInsertedRowId(long connectionPtr, long statementPtr) {
        return CONNECTIONS.executeForLastInsertedRowId(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=20)
    public static long nativeExecuteForCursorWindow(int connectionPtr, int statementPtr, int windowPtr, int startPos, int requiredPos, boolean countAllRows) {
        return ShadowSQLiteConnection.nativeExecuteForCursorWindow((long)connectionPtr, (long)statementPtr, (long)windowPtr, startPos, requiredPos, countAllRows);
    }

    @Implementation(minSdk=21)
    public static long nativeExecuteForCursorWindow(long connectionPtr, long statementPtr, long windowPtr, int startPos, int requiredPos, boolean countAllRows) {
        return CONNECTIONS.executeForCursorWindow(connectionPtr, statementPtr, windowPtr);
    }

    @Implementation(maxSdk=20)
    public static void nativeResetStatementAndClearBindings(int connectionPtr, int statementPtr) {
        ShadowSQLiteConnection.nativeResetStatementAndClearBindings((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static void nativeResetStatementAndClearBindings(long connectionPtr, long statementPtr) {
        CONNECTIONS.resetStatementAndClearBindings(connectionPtr, statementPtr);
    }

    @Implementation(maxSdk=20)
    public static void nativeCancel(int connectionPtr) {
        ShadowSQLiteConnection.nativeCancel((long)connectionPtr);
    }

    @Implementation(minSdk=21)
    public static void nativeCancel(long connectionPtr) {
        CONNECTIONS.cancel(connectionPtr);
    }

    @Implementation(maxSdk=20)
    public static void nativeResetCancel(int connectionPtr, boolean cancelable) {
        ShadowSQLiteConnection.nativeResetCancel((long)connectionPtr, cancelable);
    }

    @Implementation(minSdk=21)
    public static void nativeResetCancel(long connectionPtr, boolean cancelable) {
    }

    @Implementation(maxSdk=20)
    public static void nativeRegisterCustomFunction(int connectionPtr, SQLiteCustomFunction function) {
        ShadowSQLiteConnection.nativeRegisterCustomFunction((long)connectionPtr, function);
    }

    @Implementation(minSdk=21)
    public static void nativeRegisterCustomFunction(long connectionPtr, SQLiteCustomFunction function) {
    }

    @Implementation(maxSdk=20)
    public static int nativeExecuteForBlobFileDescriptor(int connectionPtr, int statementPtr) {
        return ShadowSQLiteConnection.nativeExecuteForBlobFileDescriptor((long)connectionPtr, (long)statementPtr);
    }

    @Implementation(minSdk=21)
    public static int nativeExecuteForBlobFileDescriptor(long connectionPtr, long statementPtr) {
        return -1;
    }

    @Implementation(maxSdk=20)
    public static int nativeGetDbLookaside(int connectionPtr) {
        return ShadowSQLiteConnection.nativeGetDbLookaside((long)connectionPtr);
    }

    @Implementation(minSdk=21)
    public static int nativeGetDbLookaside(long connectionPtr) {
        return 0;
    }

    static class Connections {
        private final Object lock = new Object();
        private final AtomicLong pointerCounter = new AtomicLong(0L);
        private final Map<Long, SQLiteStatement> statementsMap = new HashMap<Long, SQLiteStatement>();
        private final Map<Long, com.almworks.sqlite4java.SQLiteConnection> connectionsMap = new HashMap<Long, com.almworks.sqlite4java.SQLiteConnection>();
        private final Map<Long, List<Long>> statementPtrsForConnection = new HashMap<Long, List<Long>>();
        private ExecutorService dbExecutor = Executors.newSingleThreadExecutor();

        Connections() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        com.almworks.sqlite4java.SQLiteConnection getConnection(long connectionPtr) {
            Object object = this.lock;
            synchronized (object) {
                com.almworks.sqlite4java.SQLiteConnection connection = this.connectionsMap.get(connectionPtr);
                if (connection == null) {
                    throw new IllegalStateException("Illegal connection pointer " + connectionPtr + ". Current pointers for thread " + Thread.currentThread() + " " + this.connectionsMap.keySet());
                }
                return connection;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SQLiteStatement getStatement(long connectionPtr, long statementPtr) {
            Object object = this.lock;
            synchronized (object) {
                this.getConnection(connectionPtr);
                SQLiteStatement statement = this.statementsMap.get(statementPtr);
                if (statement == null) {
                    throw new IllegalArgumentException("Invalid prepared statement pointer: " + statementPtr + ". Current pointers: " + this.statementsMap.keySet());
                }
                if (statement.isDisposed()) {
                    throw new IllegalStateException("Statement " + statementPtr + " " + statement + " is disposed");
                }
                return statement;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long open(final String path) {
            Object object = this.lock;
            synchronized (object) {
                com.almworks.sqlite4java.SQLiteConnection dbConnection = this.execute("open SQLite connection", new Callable<com.almworks.sqlite4java.SQLiteConnection>(){

                    @Override
                    public com.almworks.sqlite4java.SQLiteConnection call() throws Exception {
                        com.almworks.sqlite4java.SQLiteConnection connection = useInMemoryDatabase.get() || ShadowSQLiteConnection.IN_MEMORY_PATH.equals(path) ? new com.almworks.sqlite4java.SQLiteConnection() : new com.almworks.sqlite4java.SQLiteConnection(new File(path));
                        connection.open();
                        return connection;
                    }
                });
                long connectionPtr = this.pointerCounter.incrementAndGet();
                this.connectionsMap.put(connectionPtr, dbConnection);
                this.statementPtrsForConnection.put(connectionPtr, new ArrayList());
                return connectionPtr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long prepareStatement(long connectionPtr, final String sql) {
            if ("REINDEX LOCALIZED".equals(sql)) {
                return -2L;
            }
            Object object = this.lock;
            synchronized (object) {
                final com.almworks.sqlite4java.SQLiteConnection connection = this.getConnection(connectionPtr);
                SQLiteStatement statement = this.execute("prepare statement", new Callable<SQLiteStatement>(){

                    @Override
                    public SQLiteStatement call() throws Exception {
                        return connection.prepare(sql);
                    }
                });
                long statementPtr = this.pointerCounter.incrementAndGet();
                this.statementsMap.put(statementPtr, statement);
                this.statementPtrsForConnection.get(connectionPtr).add(statementPtr);
                return statementPtr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(long connectionPtr) {
            Object object = this.lock;
            synchronized (object) {
                final com.almworks.sqlite4java.SQLiteConnection connection = this.getConnection(connectionPtr);
                this.execute("close connection", new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        connection.dispose();
                        return null;
                    }
                });
                this.connectionsMap.remove(connectionPtr);
                this.statementPtrsForConnection.remove(connectionPtr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            ArrayList<com.almworks.sqlite4java.SQLiteConnection> openConnections;
            ExecutorService oldDbExecutor;
            Object object = this.lock;
            synchronized (object) {
                oldDbExecutor = this.dbExecutor;
                openConnections = new ArrayList<com.almworks.sqlite4java.SQLiteConnection>(this.connectionsMap.values());
                this.dbExecutor = Executors.newSingleThreadExecutor();
                this.connectionsMap.clear();
                this.statementsMap.clear();
                this.statementPtrsForConnection.clear();
            }
            Connections.shutdownDbExecutor(oldDbExecutor, openConnections);
        }

        private static void shutdownDbExecutor(ExecutorService executorService, Collection<com.almworks.sqlite4java.SQLiteConnection> connections) {
            for (final com.almworks.sqlite4java.SQLiteConnection connection : connections) {
                Connections.getFuture("close connection on reset", executorService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        connection.dispose();
                        return null;
                    }
                }));
            }
            executorService.shutdown();
            try {
                executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finalizeStmt(long connectionPtr, long statementPtr) {
            if (statementPtr == -2L) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                final SQLiteStatement statement = this.getStatement(connectionPtr, statementPtr);
                this.statementsMap.remove(statementPtr);
                this.execute("finalize statement", new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        statement.dispose();
                        return null;
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancel(long connectionPtr) {
            Object object = this.lock;
            synchronized (object) {
                this.getConnection(connectionPtr);
                for (Long statementPtr : this.statementPtrsForConnection.get(connectionPtr)) {
                    final SQLiteStatement statement = this.statementsMap.get(statementPtr);
                    if (statement == null) continue;
                    this.execute("cancel", new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            statement.cancel();
                            return null;
                        }
                    });
                }
            }
        }

        int getParameterCount(long connectionPtr, long statementPtr) {
            if (statementPtr == -2L) {
                return 0;
            }
            return this.executeStatementOperation(connectionPtr, statementPtr, "get parameters count in prepared statement", new StatementOperation<Integer>(){

                @Override
                public Integer call(SQLiteStatement statement) throws Exception {
                    return statement.getBindParameterCount();
                }
            });
        }

        boolean isReadOnly(long connectionPtr, long statementPtr) {
            if (statementPtr == -2L) {
                return true;
            }
            return this.executeStatementOperation(connectionPtr, statementPtr, "call isReadOnly", new StatementOperation<Boolean>(){

                @Override
                public Boolean call(SQLiteStatement statement) throws Exception {
                    return statement.isReadOnly();
                }
            });
        }

        long executeForLong(long connectionPtr, long statementPtr) {
            return this.executeStatementOperation(connectionPtr, statementPtr, "execute for long", new StatementOperation<Long>(){

                @Override
                public Long call(SQLiteStatement statement) throws Exception {
                    if (!statement.step()) {
                        throw new SQLiteException(101, "No rows returned from query");
                    }
                    return statement.columnLong(0);
                }
            });
        }

        void executeStatement(long connectionPtr, long statementPtr) {
            if (statementPtr == -2L) {
                return;
            }
            this.executeStatementOperation(connectionPtr, statementPtr, "execute", new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.stepThrough();
                    return null;
                }
            });
        }

        String executeForString(long connectionPtr, long statementPtr) {
            return this.executeStatementOperation(connectionPtr, statementPtr, "execute for string", new StatementOperation<String>(){

                @Override
                public String call(SQLiteStatement statement) throws Exception {
                    if (!statement.step()) {
                        throw new SQLiteException(101, "No rows returned from query");
                    }
                    return statement.columnString(0);
                }
            });
        }

        int getColumnCount(long connectionPtr, long statementPtr) {
            return this.executeStatementOperation(connectionPtr, statementPtr, "get columns count", new StatementOperation<Integer>(){

                @Override
                public Integer call(SQLiteStatement statement) throws Exception {
                    return statement.columnCount();
                }
            });
        }

        String getColumnName(long connectionPtr, long statementPtr, final int index) {
            return this.executeStatementOperation(connectionPtr, statementPtr, "get column name at index " + index, new StatementOperation<String>(){

                @Override
                public String call(SQLiteStatement statement) throws Exception {
                    return statement.getColumnName(index);
                }
            });
        }

        void bindNull(long connectionPtr, long statementPtr, final int index) {
            this.executeStatementOperation(connectionPtr, statementPtr, "bind null at index " + index, new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.bindNull(index);
                    return null;
                }
            });
        }

        void bindLong(long connectionPtr, long statementPtr, final int index, final long value) {
            this.executeStatementOperation(connectionPtr, statementPtr, "bind long at index " + index + " with value " + value, new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.bind(index, value);
                    return null;
                }
            });
        }

        void bindDouble(long connectionPtr, long statementPtr, final int index, final double value) {
            this.executeStatementOperation(connectionPtr, statementPtr, "bind double at index " + index + " with value " + value, new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.bind(index, value);
                    return null;
                }
            });
        }

        void bindString(long connectionPtr, long statementPtr, final int index, final String value) {
            this.executeStatementOperation(connectionPtr, statementPtr, "bind string at index " + index, new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.bind(index, value);
                    return null;
                }
            });
        }

        void bindBlob(long connectionPtr, long statementPtr, final int index, final byte[] value) {
            this.executeStatementOperation(connectionPtr, statementPtr, "bind blob at index " + index, new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.bind(index, value);
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int executeForChangedRowCount(long connectionPtr, long statementPtr) {
            Object object = this.lock;
            synchronized (object) {
                final com.almworks.sqlite4java.SQLiteConnection connection = this.getConnection(connectionPtr);
                final SQLiteStatement statement = this.getStatement(connectionPtr, statementPtr);
                return this.execute("execute for changed row count", new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        statement.stepThrough();
                        return connection.getChanges();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long executeForLastInsertedRowId(long connectionPtr, long statementPtr) {
            Object object = this.lock;
            synchronized (object) {
                final com.almworks.sqlite4java.SQLiteConnection connection = this.getConnection(connectionPtr);
                final SQLiteStatement statement = this.getStatement(connectionPtr, statementPtr);
                return this.execute("execute for last inserted row ID", new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        statement.stepThrough();
                        return connection.getLastInsertId();
                    }
                });
            }
        }

        long executeForCursorWindow(long connectionPtr, long statementPtr, final long windowPtr) {
            return this.executeStatementOperation(connectionPtr, statementPtr, "execute for cursor window", new StatementOperation<Integer>(){

                @Override
                public Integer call(SQLiteStatement statement) throws Exception {
                    return ShadowCursorWindow.setData(windowPtr, statement);
                }
            }).intValue();
        }

        void resetStatementAndClearBindings(long connectionPtr, long statementPtr) {
            this.executeStatementOperation(connectionPtr, statementPtr, "reset statement", new StatementOperation<Void>(){

                @Override
                public Void call(SQLiteStatement statement) throws Exception {
                    statement.reset(true);
                    return null;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T executeStatementOperation(long connectionPtr, long statementPtr, String comment, final StatementOperation<T> statementOperation) {
            Object object = this.lock;
            synchronized (object) {
                final SQLiteStatement statement = this.getStatement(connectionPtr, statementPtr);
                return this.execute(comment, new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        return statementOperation.call(statement);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T execute(String comment, Callable<T> work) {
            Object object = this.lock;
            synchronized (object) {
                return Connections.getFuture(comment, this.dbExecutor.submit(work));
            }
        }

        private static <T> T getFuture(String comment, Future<T> future) {
            try {
                return (T)Uninterruptibles.getUninterruptibly(future);
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t instanceof SQLiteException) {
                    RuntimeException sqlException = Connections.getSqliteException("Cannot " + comment, ((SQLiteException)t).getBaseErrorCode());
                    sqlException.initCause(e);
                    throw sqlException;
                }
                throw new RuntimeException(e);
            }
        }

        private static RuntimeException getSqliteException(String message, int baseErrorCode) {
            switch (baseErrorCode) {
                case 4: {
                    return new SQLiteAbortException(message);
                }
                case 3: {
                    return new SQLiteAccessPermException(message);
                }
                case 25: {
                    return new SQLiteBindOrColumnIndexOutOfRangeException(message);
                }
                case 18: {
                    return new SQLiteBlobTooBigException(message);
                }
                case 14: {
                    return new SQLiteCantOpenDatabaseException(message);
                }
                case 19: {
                    return new SQLiteConstraintException(message);
                }
                case 11: 
                case 26: {
                    return new SQLiteDatabaseCorruptException(message);
                }
                case 5: {
                    return new SQLiteDatabaseLockedException(message);
                }
                case 20: {
                    return new SQLiteDatatypeMismatchException(message);
                }
                case 10: {
                    return new SQLiteDiskIOException(message);
                }
                case 101: {
                    return new SQLiteDoneException(message);
                }
                case 13: {
                    return new SQLiteFullException(message);
                }
                case 21: {
                    return new SQLiteMisuseException(message);
                }
                case 7: {
                    return new SQLiteOutOfMemoryException(message);
                }
                case 8: {
                    return new SQLiteReadOnlyDatabaseException(message);
                }
                case 6: {
                    return new SQLiteTableLockedException(message);
                }
                case 9: {
                    return new OperationCanceledException(message);
                }
            }
            return new android.database.sqlite.SQLiteException(message + ", base error code: " + baseErrorCode);
        }

        static interface StatementOperation<T> {
            public T call(SQLiteStatement var1) throws Exception;
        }
    }
}

