/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import libcore.io.Linux;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.OsConstantsValues;

@Implements(value=Linux.class, minSdk=26, isInAndroidSdk=false)
public class ShadowLinux {
    @Implementation
    public void mkdir(String path, int mode) throws ErrnoException {
        new File(path).mkdirs();
    }

    @Implementation
    public StructStat stat(String path) throws ErrnoException {
        return new StructStat(0L, 0L, OsConstantsValues.getMode(path), 0L, 0, 0, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
    }

    @Implementation
    protected StructStat lstat(String path) throws ErrnoException {
        return this.stat(path);
    }

    @Implementation(maxSdk=25)
    protected StructStat fstat(String path) throws ErrnoException {
        return this.stat(path);
    }

    @Implementation
    protected StructStat fstat(FileDescriptor fd) throws ErrnoException {
        return this.stat(null);
    }

    @Implementation
    protected FileDescriptor open(String path, int flags, int mode) throws ErrnoException {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(path, ShadowLinux.modeToString(mode));
            return randomAccessFile.getFD();
        }
        catch (IOException e) {
            Log.e((String)"ShadowLinux", (String)("open failed for " + path), (Throwable)e);
            throw new ErrnoException("open", OsConstants.EIO);
        }
    }

    private static String modeToString(int mode) {
        if (mode == OsConstants.O_RDONLY) {
            return "r";
        }
        return "rw";
    }
}

