/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.ToneGenerator;
import com.android.internal.annotations.VisibleForTesting;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Deque;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.AutoValue_ShadowToneGenerator_Tone;

@Implements(value=ToneGenerator.class)
public class ShadowToneGenerator {
    @VisibleForTesting
    static final int MAXIMUM_STORED_TONES = 2000;
    private static final Deque<Tone> playedTones = new ArrayDeque<Tone>();

    @Implementation
    protected boolean startTone(int toneType, int durationMs) {
        playedTones.add(Tone.create(toneType, Duration.ofMillis(durationMs)));
        if (playedTones.size() > 2000) {
            playedTones.removeFirst();
        }
        return true;
    }

    public static ImmutableList<Tone> getPlayedTones() {
        return ImmutableList.copyOf(playedTones);
    }

    @Resetter
    public static void reset() {
        playedTones.clear();
    }

    @AutoValue
    public static abstract class Tone {
        public abstract int type();

        public abstract Duration duration();

        static Tone create(int type, Duration duration) {
            return new AutoValue_ShadowToneGenerator_Tone(type, duration);
        }
    }
}

