/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric;

import android.app.Application;
import android.app.ResourcesManager;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.util.DisplayMetrics;
import com.google.common.base.Supplier;
import java.nio.file.Path;
import org.robolectric.android.Bootstrap;
import org.robolectric.android.ConfigurationV25;
import org.robolectric.annotation.LooperMode;
import org.robolectric.shadows.ShadowDisplayManager;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.Scheduler;
import org.robolectric.util.TempDirectory;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

public class RuntimeEnvironment {
    @Deprecated
    public static Context systemContext;
    @Deprecated
    public static volatile Application application;
    private static volatile Thread mainThread;
    private static volatile Object activityThread;
    private static int apiLevel;
    private static Scheduler masterScheduler;
    private static TempDirectory tempDirectory;
    private static Path androidFrameworkJar;
    private static Supplier<Application> applicationSupplier;
    private static final Object supplierLock;
    private static Supplier<Path> compileTimeSystemResourcesSupplier;
    private static Class<? extends Application> applicationClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Application getApplication() {
        if (application == null) {
            Object object = supplierLock;
            synchronized (object) {
                if (applicationSupplier != null) {
                    ShadowInstrumentation.runOnMainSyncNoIdle(() -> {
                        application = (Application)applicationSupplier.get();
                    });
                }
            }
        }
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setApplicationSupplier(Supplier<Application> applicationSupplier) {
        Object object = supplierLock;
        synchronized (object) {
            RuntimeEnvironment.applicationSupplier = applicationSupplier;
        }
    }

    public static Class<? extends Application> getConfiguredApplicationClass() {
        return applicationClass;
    }

    public static void setConfiguredApplicationClass(Class<? extends Application> clazz) {
        applicationClass = clazz;
    }

    public static boolean isMainThread(Thread thread) {
        ShadowLooper.assertLooperMode(LooperMode.Mode.LEGACY);
        return thread == mainThread;
    }

    public static boolean isMainThread() {
        ShadowLooper.assertLooperMode(LooperMode.Mode.LEGACY);
        return RuntimeEnvironment.isMainThread(Thread.currentThread());
    }

    public static Thread getMainThread() {
        ShadowLooper.assertLooperMode(LooperMode.Mode.LEGACY);
        return mainThread;
    }

    public static void setMainThread(Thread newMainThread) {
        ShadowLooper.assertLooperMode(LooperMode.Mode.LEGACY);
        mainThread = newMainThread;
    }

    public static Object getActivityThread() {
        return activityThread;
    }

    public static void setActivityThread(Object newActivityThread) {
        activityThread = newActivityThread;
    }

    public static String getQualifiers() {
        Resources systemResources = Resources.getSystem();
        return RuntimeEnvironment.getQualifiers(systemResources.getConfiguration(), systemResources.getDisplayMetrics());
    }

    public static String getQualifiers(Configuration configuration, DisplayMetrics displayMetrics) {
        return ConfigurationV25.resourceQualifierString(configuration, displayMetrics);
    }

    public static void setQualifiers(String newQualifiers) {
        Configuration configuration;
        ShadowDisplayManager.changeDisplay(0, newQualifiers);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        if (newQualifiers.startsWith("+")) {
            configuration = new Configuration(Resources.getSystem().getConfiguration());
            displayMetrics.setTo(Resources.getSystem().getDisplayMetrics());
        } else {
            configuration = new Configuration();
        }
        Bootstrap.applyQualifiers(newQualifiers, RuntimeEnvironment.getApiLevel(), configuration, displayMetrics);
        if (ShadowView.useRealGraphics()) {
            Bitmap.setDefaultDensity((int)displayMetrics.densityDpi);
        }
        RuntimeEnvironment.updateConfiguration(configuration, displayMetrics);
    }

    public static void setFontScale(float fontScale) {
        Resources systemResources = RuntimeEnvironment.getApplication().getResources();
        DisplayMetrics displayMetrics = systemResources.getDisplayMetrics();
        Configuration configuration = systemResources.getConfiguration();
        displayMetrics.scaledDensity = displayMetrics.density * fontScale;
        configuration.fontScale = fontScale;
        RuntimeEnvironment.updateConfiguration(configuration, displayMetrics);
    }

    public static float getFontScale() {
        Resources systemResources = RuntimeEnvironment.getApplication().getResources();
        return systemResources.getConfiguration().fontScale;
    }

    private static void updateConfiguration(Configuration configuration, DisplayMetrics displayMetrics) {
        if (ResourcesManager.getInstance().getConfiguration() != null) {
            if (System.getProperty("robolectric.configurationChangeFix", "true").equals("true")) {
                if (RuntimeEnvironment.getApiLevel() <= 29) {
                    ((ResourcesManagerReflector)Reflector.reflector(ResourcesManagerReflector.class, (Object)ResourcesManager.getInstance())).applyConfigurationToResourcesLocked(configuration, null);
                } else {
                    ResourcesManager.getInstance().applyConfigurationToResources(configuration, null);
                }
            } else {
                ResourcesManager.getInstance().getConfiguration().updateFrom(configuration);
            }
        }
        Resources.getSystem().updateConfiguration(configuration, displayMetrics);
        if (application != null) {
            RuntimeEnvironment.getApplication().getResources().updateConfiguration(configuration, displayMetrics);
        } else {
            Bootstrap.updateDisplayResources(configuration, displayMetrics);
        }
    }

    public static int getApiLevel() {
        return apiLevel;
    }

    @Deprecated
    public static Scheduler getMasterScheduler() {
        return masterScheduler;
    }

    @Deprecated
    public static void setMasterScheduler(Scheduler masterScheduler) {
        RuntimeEnvironment.masterScheduler = masterScheduler;
    }

    public static void setTempDirectory(TempDirectory tempDirectory) {
        RuntimeEnvironment.tempDirectory = tempDirectory;
    }

    public static TempDirectory getTempDirectory() {
        return tempDirectory;
    }

    public static void setAndroidFrameworkJarPath(Path localArtifactPath) {
        androidFrameworkJar = localArtifactPath;
    }

    public static Path getAndroidFrameworkJarPath() {
        return androidFrameworkJar;
    }

    public static void setCompileTimeSystemResources(Supplier<Path> compileTimeSystemResourcesSupplier) {
        RuntimeEnvironment.compileTimeSystemResourcesSupplier = compileTimeSystemResourcesSupplier;
    }

    @Deprecated
    public static Path getCompileTimeSystemResourcesPath() {
        return (Path)compileTimeSystemResourcesSupplier.get();
    }

    static {
        tempDirectory = new TempDirectory("no-test-yet");
        supplierLock = new Object();
    }

    @ForType(value=ResourcesManager.class)
    static interface ResourcesManagerReflector {
        public boolean applyConfigurationToResourcesLocked(Configuration var1, CompatibilityInfo var2);
    }
}

