/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.Sensor;
import android.hardware.SensorDirectChannel;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorEventListener2;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.Looper;
import android.os.MemoryFile;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.robolectric.annotation.ClassName;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowSensor;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SensorManager.class)
public class ShadowSensorManager {
    private static final AtomicBoolean forceListenersToFail = new AtomicBoolean();
    private static final Multimap<Integer, Sensor> sensorMap = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private static final Multimap<SensorEventListener, Sensor> listeners = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    @RealObject
    private SensorManager realObject;

    @Resetter
    public static void reset() {
        sensorMap.clear();
        listeners.clear();
        forceListenersToFail.set(false);
    }

    @Deprecated
    public void addSensor(int sensorType, Sensor sensor) {
        Objects.requireNonNull(sensor);
        sensorMap.put((Object)sensorType, (Object)sensor);
    }

    public void addSensor(Sensor sensor) {
        Objects.requireNonNull(sensor);
        sensorMap.put((Object)sensor.getType(), (Object)sensor);
    }

    public void removeSensor(Sensor sensor) {
        Objects.requireNonNull(sensor);
        sensorMap.get((Object)sensor.getType()).remove(sensor);
    }

    @Implementation
    protected Sensor getDefaultSensor(int type) {
        Collection sensorsForType = sensorMap.get((Object)type);
        if (sensorsForType.isEmpty()) {
            return null;
        }
        return (Sensor)sensorsForType.toArray()[0];
    }

    @Implementation
    public List<Sensor> getSensorList(int type) {
        if (type == -1) {
            return ImmutableList.copyOf((Collection)sensorMap.values());
        }
        return ImmutableList.copyOf((Collection)sensorMap.get((Object)type));
    }

    @Implementation
    protected boolean registerListener(SensorEventListener listener, Sensor sensor, int rate, Handler handler) {
        return this.registerListener(listener, sensor, rate);
    }

    @Implementation
    protected boolean registerListener(SensorEventListener listener, Sensor sensor, int rate, int maxLatency) {
        return this.registerListener(listener, sensor, rate);
    }

    @Implementation
    protected boolean registerListener(SensorEventListener listener, Sensor sensor, int rate, int maxLatency, Handler handler) {
        return this.registerListener(listener, sensor, rate);
    }

    public void setForceListenersToFail(boolean forceListenersToFail) {
        ShadowSensorManager.forceListenersToFail.set(forceListenersToFail);
    }

    @Implementation
    protected boolean registerListener(SensorEventListener listener, Sensor sensor, int rate) {
        if (forceListenersToFail.get()) {
            return false;
        }
        listeners.put((Object)listener, (Object)sensor);
        return true;
    }

    @Implementation
    protected void unregisterListener(SensorEventListener listener, Sensor sensor) {
        listeners.remove((Object)listener, (Object)sensor);
    }

    @Implementation
    protected void unregisterListener(SensorEventListener listener) {
        listeners.removeAll((Object)listener);
    }

    public boolean hasListener(SensorEventListener listener) {
        return listeners.containsKey((Object)listener);
    }

    public boolean hasListener(SensorEventListener listener, Sensor sensor) {
        return listeners.containsEntry((Object)listener, (Object)sensor);
    }

    public List<SensorEventListener> getListeners() {
        return ImmutableList.copyOf((Collection)listeners.keySet());
    }

    public void sendSensorEventToListeners(SensorEvent event) {
        for (SensorEventListener listener : this.getListeners()) {
            listener.onSensorChanged(event);
        }
    }

    public void sendSensorEventToListeners(SensorEvent event, Sensor sensor) {
        List listenersRegisteredToSensor = listeners.entries().stream().filter(entry -> entry.getValue() == sensor).map(Map.Entry::getKey).collect(Collectors.toList());
        for (SensorEventListener listener : listenersRegisteredToSensor) {
            listener.onSensorChanged(event);
        }
    }

    @Implementation
    protected boolean flush(SensorEventListener listener) {
        new Handler(Looper.getMainLooper()).post(() -> {
            for (Sensor sensor : listeners.get((Object)listener)) {
                for (SensorEventListener registeredListener : this.getListeners()) {
                    if (!(registeredListener instanceof SensorEventListener2) || !listeners.containsEntry((Object)registeredListener, (Object)sensor)) continue;
                    ((SensorEventListener2)registeredListener).onFlushCompleted(sensor);
                }
            }
        });
        return listeners.containsKey((Object)listener);
    }

    @Deprecated
    public SensorEvent createSensorEvent() {
        return (SensorEvent)ReflectionHelpers.callConstructor(SensorEvent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Deprecated
    public static SensorEvent createSensorEvent(int valueArraySize) {
        return ShadowSensorManager.createSensorEvent(valueArraySize, 9);
    }

    @Deprecated
    public static SensorEvent createSensorEvent(int valueArraySize, int sensorType) {
        Preconditions.checkArgument((valueArraySize > 0 ? 1 : 0) != 0);
        ReflectionHelpers.ClassParameter valueArraySizeParam = new ReflectionHelpers.ClassParameter(Integer.TYPE, (Object)valueArraySize);
        SensorEvent sensorEvent = (SensorEvent)ReflectionHelpers.callConstructor(SensorEvent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{valueArraySizeParam});
        sensorEvent.sensor = ShadowSensor.newInstance(sensorType);
        return sensorEvent;
    }

    @Implementation(minSdk=26)
    protected @ClassName(value="android.hardware.SensorDirectChannel") Object createDirectChannel(MemoryFile mem) {
        return ReflectionHelpers.callConstructor(SensorDirectChannel.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(SensorManager.class, (Object)this.realObject), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)1), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)mem.length())});
    }
}

