/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SystemClock;
import java.time.DateTimeException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowSystemClock;

@Implements(value=SystemClock.class, isInAndroidSdk=false, shadowPicker=ShadowSystemClock.Picker.class)
public class ShadowPausedSystemClock
extends ShadowSystemClock {
    static final int MILLIS_PER_NANO = 1000000;
    private static final int MILLIS_PER_MICRO = 1000;
    private static final long INITIAL_TIME_NS = 100000000L;
    @GuardedBy(value="ShadowPausedSystemClock.class")
    private static long currentUptimeNs = 100000000L;
    @GuardedBy(value="ShadowPausedSystemClock.class")
    private static long currentRealtimeNs = 100000000L;
    private static final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private static final List<Listener> staticListeners = new CopyOnWriteArrayList<Listener>();

    static void addListener(Listener listener) {
        listeners.add(listener);
    }

    static void removeListener(Listener listener) {
        listeners.remove(listener);
        staticListeners.remove(listener);
    }

    static void addStaticListener(Listener listener) {
        staticListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static void sleep(long millis) {
        Class<ShadowPausedSystemClock> clazz = ShadowPausedSystemClock.class;
        synchronized (ShadowPausedSystemClock.class) {
            currentUptimeNs += millis * 1000000L;
            currentRealtimeNs += millis * 1000000L;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ShadowPausedSystemClock.informListeners();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void deepSleep(long millis) {
        Class<ShadowPausedSystemClock> clazz = ShadowPausedSystemClock.class;
        synchronized (ShadowPausedSystemClock.class) {
            currentRealtimeNs += millis * 1000000L;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            ShadowPausedSystemClock.informListeners();
            return;
        }
    }

    private static void informListeners() {
        for (Listener listener : listeners) {
            listener.onClockAdvanced();
        }
        for (Listener listener : staticListeners) {
            listener.onClockAdvanced();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static boolean setCurrentTimeMillis(long millis) {
        long newTimeNs = millis * 1000000L;
        Class<ShadowPausedSystemClock> clazz = ShadowPausedSystemClock.class;
        synchronized (ShadowPausedSystemClock.class) {
            if (currentUptimeNs > newTimeNs) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return false;
            }
            if (currentUptimeNs == newTimeNs) {
                // ** MonitorExit[var4_2] (shouldn't be in output)
                return true;
            }
            currentUptimeNs = newTimeNs;
            currentRealtimeNs = newTimeNs;
            // ** MonitorExit[var4_2] (shouldn't be in output)
            ShadowPausedSystemClock.informListeners();
            return true;
        }
    }

    @Implementation
    protected static long uptimeMillis() {
        return ShadowPausedSystemClock.uptimeNanos() / 1000000L;
    }

    @Implementation(minSdk=31)
    protected static synchronized long uptimeNanos() {
        return currentUptimeNs;
    }

    @Implementation
    protected static long elapsedRealtime() {
        return ShadowPausedSystemClock.elapsedRealtimeNanos() / 1000000L;
    }

    @Implementation
    protected static synchronized long elapsedRealtimeNanos() {
        return currentRealtimeNs;
    }

    @Implementation
    protected static long currentThreadTimeMillis() {
        return ShadowPausedSystemClock.uptimeMillis();
    }

    @HiddenApi
    @Implementation
    protected static long currentThreadTimeMicro() {
        return ShadowPausedSystemClock.uptimeNanos() / 1000L;
    }

    @HiddenApi
    @Implementation
    protected static long currentTimeMicro() {
        return ShadowPausedSystemClock.currentThreadTimeMicro();
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected static synchronized long currentNetworkTimeMillis() {
        if (networkTimeAvailable) {
            return ShadowPausedSystemClock.uptimeMillis();
        }
        throw new DateTimeException("Network time not available");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void internalAdvanceBy(Duration duration) {
        if (duration.toNanos() <= 0L) {
            return;
        }
        Class<ShadowPausedSystemClock> clazz = ShadowPausedSystemClock.class;
        synchronized (ShadowPausedSystemClock.class) {
            currentUptimeNs += duration.toNanos();
            currentRealtimeNs += duration.toNanos();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ShadowPausedSystemClock.informListeners();
            return;
        }
    }

    @Resetter
    public static synchronized void reset() {
        currentUptimeNs = 100000000L;
        currentRealtimeNs = 100000000L;
        ShadowSystemClock.reset();
        listeners.clear();
    }

    static interface Listener {
        public void onClockAdvanced();
    }
}

