/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaDataSource;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.PersistableBundle;
import java.io.FileDescriptor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.util.DataSource;

@Implements(value=MediaExtractor.class)
public class ShadowMediaExtractor {
    private static final Map<DataSource, List<TrackInfo>> tracksMap = new HashMap<DataSource, List<TrackInfo>>();
    private static final Map<DataSource, PersistableBundle> metricsMap = new HashMap<DataSource, PersistableBundle>();
    private List<TrackInfo> tracks;
    private PersistableBundle metrics;
    private int[] trackSampleReadPositions;
    private int[] trackLastReadSize;
    private int selectedTrackIndex = -1;

    public static void addTrack(DataSource dataSource, MediaFormat format, byte[] sampleData) {
        TrackInfo trackInfo = new TrackInfo();
        trackInfo.format = format;
        trackInfo.sampleData = sampleData;
        tracksMap.putIfAbsent(dataSource, new ArrayList());
        List<TrackInfo> tracks = tracksMap.get(dataSource);
        tracks.add(trackInfo);
    }

    public static void setMetrics(DataSource dataSource, PersistableBundle metrics) {
        metricsMap.put(dataSource, metrics);
    }

    private void setDataSource(DataSource dataSource) {
        this.tracks = tracksMap.containsKey(dataSource) ? tracksMap.get(dataSource) : new ArrayList<TrackInfo>();
        this.trackSampleReadPositions = new int[this.tracks.size()];
        Arrays.fill(this.trackSampleReadPositions, 0);
        this.trackLastReadSize = new int[this.tracks.size()];
        Arrays.fill(this.trackLastReadSize, 0);
        this.metrics = metricsMap.get(dataSource);
    }

    @Implementation(minSdk=24)
    protected void setDataSource(AssetFileDescriptor assetFileDescriptor) {
        this.setDataSource(DataSource.toDataSource(assetFileDescriptor));
    }

    @Implementation
    protected void setDataSource(Context context, Uri uri, Map<String, String> headers) {
        this.setDataSource(DataSource.toDataSource(context, uri, headers));
    }

    @Implementation
    protected void setDataSource(FileDescriptor fileDescriptor) {
        this.setDataSource(DataSource.toDataSource(fileDescriptor));
    }

    @Implementation(minSdk=23)
    protected void setDataSource(MediaDataSource mediaDataSource) {
        this.setDataSource(DataSource.toDataSource(mediaDataSource));
    }

    @Implementation
    protected void setDataSource(FileDescriptor fileDescriptor, long offset, long length) {
        this.setDataSource(DataSource.toDataSource(fileDescriptor, offset, length));
    }

    @Implementation
    protected void setDataSource(String path) {
        this.setDataSource(DataSource.toDataSource(path));
    }

    @Implementation
    protected void setDataSource(String path, Map<String, String> headers) {
        this.setDataSource(DataSource.toDataSource(path));
    }

    @Implementation
    protected boolean advance() {
        if (this.selectedTrackIndex == -1) {
            throw new IllegalStateException("Called advance() with no selected track");
        }
        int readPosition = this.trackSampleReadPositions[this.selectedTrackIndex];
        int trackDataLength = this.tracks.get((int)this.selectedTrackIndex).sampleData.length;
        if (readPosition >= trackDataLength) {
            return false;
        }
        int n = this.selectedTrackIndex;
        this.trackSampleReadPositions[n] = this.trackSampleReadPositions[n] + this.trackLastReadSize[this.selectedTrackIndex];
        return true;
    }

    @Implementation
    protected int getSampleTrackIndex() {
        return this.selectedTrackIndex;
    }

    @Implementation
    protected int getTrackCount() {
        return this.tracks.size();
    }

    @Implementation
    protected MediaFormat getTrackFormat(int index) {
        if (index >= this.tracks.size()) {
            throw new ArrayIndexOutOfBoundsException("Called getTrackFormat() with index:" + index + ", beyond number of tracks:" + this.tracks.size());
        }
        return this.tracks.get((int)index).format;
    }

    @Implementation
    protected int readSampleData(ByteBuffer byteBuf, int offset) {
        if (this.selectedTrackIndex == -1) {
            return 0;
        }
        int currentReadPosition = this.trackSampleReadPositions[this.selectedTrackIndex];
        TrackInfo trackInfo = this.tracks.get(this.selectedTrackIndex);
        int trackDataLength = trackInfo.sampleData.length;
        if (currentReadPosition >= trackDataLength) {
            return -1;
        }
        int length = Math.min(byteBuf.capacity(), trackDataLength - currentReadPosition);
        byteBuf.put(trackInfo.sampleData, currentReadPosition, length);
        this.trackLastReadSize[this.selectedTrackIndex] = length;
        return length;
    }

    @Implementation
    protected void selectTrack(int index) {
        if (this.selectedTrackIndex != -1) {
            throw new IllegalStateException("Called selectTrack() when there is already a track selected; call unselectTrack() first. ShadowMediaExtractor does not support multiple track selection.");
        }
        if (index >= this.tracks.size()) {
            throw new ArrayIndexOutOfBoundsException("Called selectTrack() with index:" + index + ", beyond number of tracks:" + this.tracks.size());
        }
        this.selectedTrackIndex = index;
    }

    @Implementation
    protected void unselectTrack(int index) {
        if (this.selectedTrackIndex != index) {
            throw new IllegalStateException("Called unselectTrack() on a track other than the single selected track. ShadowMediaExtractor does not support multiple track selection.");
        }
        this.selectedTrackIndex = -1;
    }

    @Implementation(minSdk=26)
    protected PersistableBundle getMetrics() {
        return this.metrics;
    }

    @Resetter
    public static void reset() {
        tracksMap.clear();
        metricsMap.clear();
        DataSource.reset();
    }

    private static class TrackInfo {
        MediaFormat format;
        byte[] sampleData;

        private TrackInfo() {
        }
    }
}

