/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowInputEvent;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=KeyEvent.class)
public class ShadowKeyEvent
extends ShadowInputEvent {
    private static final Map<String, Integer> keyCodeMap = new HashMap<String, Integer>();

    @Implementation(minSdk=21)
    protected static int nativeKeyCodeFromString(String keyCode) {
        return keyCodeMap.getOrDefault(keyCode, 0);
    }

    static {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            String keyCodeConstantPrefix = ((KeyEventReflector)Reflector.reflector(KeyEventReflector.class)).getLabelPrefix();
            for (Field field : KeyEvent.class.getDeclaredFields()) {
                if (!field.getName().startsWith(keyCodeConstantPrefix) || !Modifier.isStatic(field.getModifiers())) continue;
                String keyCodeString = field.getName().substring(keyCodeConstantPrefix.length());
                try {
                    keyCodeMap.put(keyCodeString, field.getInt(null));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("unable to get reflectively get value for " + keyCodeString, e);
                }
            }
        }
    }

    @ForType(value=KeyEvent.class)
    private static interface KeyEventReflector {
        @Accessor(value="LABEL_PREFIX")
        public String getLabelPrefix();
    }
}

