/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.InsetsSource;
import android.view.InsetsState;
import android.view.WindowInsets;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.ReflectorObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=InsetsState.class, minSdk=29, isInAndroidSdk=false)
public class ShadowInsetsState {
    static final int STATUS_BARS = 0;
    static final int NAVIGATION_BARS = 1;
    @RealObject
    private InsetsState realInsetsState;
    @ReflectorObject
    private InsetsStateReflector insetsStateReflector;

    InsetsSource getOrCreateSource(int id2) {
        return RuntimeEnvironment.getApiLevel() < 34 ? this.insetsStateReflector.getSource(id2) : this.realInsetsState.getOrCreateSource(id2, ShadowInsetsState.getType(id2));
    }

    int getSourceSize() {
        if (RuntimeEnvironment.getApiLevel() >= 34) {
            return this.realInsetsState.sourceSize();
        }
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            return ((InsetsStateReflector)Reflector.reflector(InsetsStateReflector.class)).getLastType() + 1;
        }
        return this.insetsStateReflector.getSourcesCount();
    }

    private static int getType(int id2) {
        switch (id2) {
            case 0: {
                return RuntimeEnvironment.getApiLevel() < 29 ? ((WindowInsetsTypeReflector)Reflector.reflector(WindowInsetsTypeReflector.class)).topBar() : WindowInsets.Type.statusBars();
            }
            case 1: {
                return RuntimeEnvironment.getApiLevel() < 29 ? ((WindowInsetsTypeReflector)Reflector.reflector(WindowInsetsTypeReflector.class)).sideBars() : WindowInsets.Type.navigationBars();
            }
        }
        throw new IllegalArgumentException();
    }

    @ForType(value=InsetsState.class)
    static interface InsetsStateReflector {
        public InsetsSource getSource(int var1);

        @Accessor(value="ITYPE_IME")
        @Static
        public int getImeType();

        @Accessor(value="LAST_TYPE")
        @Static
        public int getLastType();

        public int getSourcesCount();
    }

    @ForType(value=WindowInsets.Type.class)
    static interface WindowInsetsTypeReflector {
        @Static
        public int topBar();

        @Static
        public int sideBars();
    }
}

