/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.CountDownTimer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=CountDownTimer.class)
public class ShadowCountDownTimer {
    static final String PROPERTY_USE_REAL_IMPL = "robolectric.useRealCountDownTimer";
    private boolean started;
    @RealObject
    private CountDownTimer realCountDownTimer;

    @Implementation
    protected synchronized CountDownTimer start() {
        this.started = true;
        if (ShadowCountDownTimer.useRealCountDownTimer()) {
            return ((CountDownTimerReflector)Reflector.reflector(CountDownTimerReflector.class, (Object)this.realCountDownTimer)).start();
        }
        return this.realCountDownTimer;
    }

    @Implementation
    protected synchronized void cancel() {
        this.started = false;
        ((CountDownTimerReflector)Reflector.reflector(CountDownTimerReflector.class, (Object)this.realCountDownTimer)).cancel();
    }

    public void invokeTick(long millisUntilFinished) {
        this.realCountDownTimer.onTick(millisUntilFinished);
    }

    public void invokeFinish() {
        this.realCountDownTimer.onFinish();
    }

    public boolean hasStarted() {
        return this.started;
    }

    public boolean isCancelled() {
        return ((CountDownTimerReflector)Reflector.reflector(CountDownTimerReflector.class, (Object)this.realCountDownTimer)).getCancelled();
    }

    public long getCountDownInterval() {
        return ((CountDownTimerReflector)Reflector.reflector(CountDownTimerReflector.class, (Object)this.realCountDownTimer)).getCountDownInterval();
    }

    public long getMillisInFuture() {
        return ((CountDownTimerReflector)Reflector.reflector(CountDownTimerReflector.class, (Object)this.realCountDownTimer)).getMillisInFuture();
    }

    private static boolean useRealCountDownTimer() {
        return Boolean.parseBoolean(System.getProperty(PROPERTY_USE_REAL_IMPL, "true"));
    }

    @ForType(value=CountDownTimer.class)
    static interface CountDownTimerReflector {
        @Direct
        public CountDownTimer start();

        @Direct
        public void cancel();

        @Accessor(value="mCancelled")
        public boolean getCancelled();

        @Accessor(value="mCountdownInterval")
        public long getCountDownInterval();

        @Accessor(value="mMillisInFuture")
        public long getMillisInFuture();
    }
}

