/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ClipboardManager;
import android.os.SystemClock;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ClipboardManager.class)
public class ShadowClipboardManager {
    private static final Collection<ClipboardManager.OnPrimaryClipChangedListener> listeners = new CopyOnWriteArrayList<ClipboardManager.OnPrimaryClipChangedListener>();
    private static ClipData clip;
    @RealObject
    private ClipboardManager realClipboardManager;

    @Resetter
    public static void reset() {
        clip = null;
        listeners.clear();
    }

    @Implementation(minSdk=28)
    protected void clearPrimaryClip() {
        this.setPrimaryClip(null);
    }

    @Implementation
    protected ClipData getPrimaryClip() {
        return clip;
    }

    @Implementation
    protected void setPrimaryClip(ClipData clip) {
        ClipDescription description;
        if (RuntimeEnvironment.getApiLevel() >= 26 && clip != null && (description = clip.getDescription()) != null) {
            long currentTimeMillis = SystemClock.uptimeMillis();
            ReflectionHelpers.callInstanceMethod(ClipDescription.class, (Object)description, (String)"setTimestamp", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)currentTimeMillis)});
        }
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            if (clip != null) {
                clip.prepareToLeaveProcess(true);
            }
        } else if (clip != null) {
            ReflectionHelpers.callInstanceMethod(ClipData.class, (Object)clip, (String)"prepareToLeaveProcess", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
        ShadowClipboardManager.clip = clip;
        for (ClipboardManager.OnPrimaryClipChangedListener listener : listeners) {
            listener.onPrimaryClipChanged();
        }
    }

    @Implementation
    protected ClipDescription getPrimaryClipDescription() {
        return clip == null ? null : clip.getDescription();
    }

    @Implementation
    protected boolean hasPrimaryClip() {
        return clip != null;
    }

    @Implementation
    protected void addPrimaryClipChangedListener(ClipboardManager.OnPrimaryClipChangedListener listener) {
        listeners.add(listener);
    }

    @Implementation
    protected void removePrimaryClipChangedListener(ClipboardManager.OnPrimaryClipChangedListener listener) {
        listeners.remove(listener);
    }

    @Implementation
    protected void setText(CharSequence text) {
        this.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)text));
    }

    @Implementation
    protected boolean hasText() {
        CharSequence text = ((ClipboardManagerReflector)Reflector.reflector(ClipboardManagerReflector.class, (Object)this.realClipboardManager)).getText();
        return text != null && text.length() > 0;
    }

    @ForType(value=ClipboardManager.class)
    static interface ClipboardManagerReflector {
        public CharSequence getText();
    }
}

