/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import android.view.Choreographer;
import android.view.ThreadedRenderer;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.annotation.RealObject;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(className="com.android.internal.policy.BackdropFrameRenderer", minSdk=31, maxSdk=34, isInAndroidSdk=false)
public class ShadowBackdropFrameRenderer {
    @RealObject
    private final Object realBackdropFrameRenderer = null;
    private Looper looper;
    private static final List<Object> activeRenderers = new CopyOnWriteArrayList<Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void run() {
        Object object;
        try {
            Looper.prepare();
            activeRenderers.add(this.realBackdropFrameRenderer);
            this.looper = Looper.myLooper();
            object = this.realBackdropFrameRenderer;
            synchronized (object) {
                block11: {
                    ThreadedRenderer renderer = ((BackdropFrameRendererReflector)Reflector.reflector(BackdropFrameRendererReflector.class, (Object)this.realBackdropFrameRenderer)).getRenderer();
                    if (renderer != null) break block11;
                    return;
                }
                ((BackdropFrameRendererReflector)Reflector.reflector(BackdropFrameRendererReflector.class, (Object)this.realBackdropFrameRenderer)).setChoreographer(Choreographer.getInstance());
            }
            Looper.loop();
        }
        finally {
            ((BackdropFrameRendererReflector)Reflector.reflector(BackdropFrameRendererReflector.class, (Object)this.realBackdropFrameRenderer)).releaseRenderer();
        }
        object = this.realBackdropFrameRenderer;
        synchronized (object) {
            ((BackdropFrameRendererReflector)Reflector.reflector(BackdropFrameRendererReflector.class, (Object)this.realBackdropFrameRenderer)).setChoreographer(null);
            Choreographer.releaseInstance();
        }
    }

    static void reset() {
        for (Object renderer : activeRenderers) {
            ((BackdropFrameRendererReflector)Reflector.reflector(BackdropFrameRendererReflector.class, (Object)renderer)).releaseRenderer();
            if (ConfigurationRegistry.get(LooperMode.Mode.class) == LooperMode.Mode.LEGACY) {
                ShadowBackdropFrameRenderer shadowBackdropFrameRenderer = (ShadowBackdropFrameRenderer)Shadow.extract((Object)renderer);
                shadowBackdropFrameRenderer.looper.quit();
            }
            Uninterruptibles.joinUninterruptibly((Thread)((Thread)renderer));
            activeRenderers.remove(renderer);
        }
    }

    @ForType(className="com.android.internal.policy.BackdropFrameRenderer")
    static interface BackdropFrameRendererReflector {
        public void releaseRenderer();

        @Accessor(value="mRenderer")
        public ThreadedRenderer getRenderer();

        @Accessor(value="mChoreographer")
        public void setChoreographer(Choreographer var1);

        @Accessor(value="mChoreographer")
        public Choreographer getChoreographer();
    }
}

