/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telephony.CellSignalStrengthLte;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

public class CellSignalStrengthLteBuilder {
    private int rssi = Integer.MAX_VALUE;
    private int rsrp = Integer.MAX_VALUE;
    private int rsrq = Integer.MAX_VALUE;
    private int rssnr = Integer.MAX_VALUE;
    private int cqiTableIndex = Integer.MAX_VALUE;
    private int cqi = Integer.MAX_VALUE;
    private int timingAdvance = Integer.MAX_VALUE;

    private CellSignalStrengthLteBuilder() {
    }

    public static CellSignalStrengthLteBuilder newBuilder() {
        return new CellSignalStrengthLteBuilder();
    }

    protected static CellSignalStrengthLte getDefaultInstance() {
        return ((CellSignalStrengthLteReflector)Reflector.reflector(CellSignalStrengthLteReflector.class)).newCellSignalStrength();
    }

    public CellSignalStrengthLteBuilder setRssi(int rssi) {
        this.rssi = rssi;
        return this;
    }

    public CellSignalStrengthLteBuilder setRsrp(int rsrp) {
        this.rsrp = rsrp;
        return this;
    }

    public CellSignalStrengthLteBuilder setRsrq(int rsrq) {
        this.rsrq = rsrq;
        return this;
    }

    public CellSignalStrengthLteBuilder setRssnr(int rssnr) {
        this.rssnr = rssnr;
        return this;
    }

    public CellSignalStrengthLteBuilder setCqiTableIndex(int cqiTableIndex) {
        this.cqiTableIndex = cqiTableIndex;
        return this;
    }

    public CellSignalStrengthLteBuilder setCqi(int cqi) {
        this.cqi = cqi;
        return this;
    }

    public CellSignalStrengthLteBuilder setTimingAdvance(int timingAdvance) {
        this.timingAdvance = timingAdvance;
        return this;
    }

    public CellSignalStrengthLte build() {
        CellSignalStrengthLteReflector cellSignalStrengthReflector = (CellSignalStrengthLteReflector)Reflector.reflector(CellSignalStrengthLteReflector.class);
        if (RuntimeEnvironment.getApiLevel() < 31) {
            return cellSignalStrengthReflector.newCellSignalStrength(this.rssi, this.rsrp, this.rsrq, this.rssnr, this.cqi, this.timingAdvance);
        }
        return cellSignalStrengthReflector.newCellSignalStrength(this.rssi, this.rsrp, this.rsrq, this.rssnr, this.cqiTableIndex, this.cqi, this.timingAdvance);
    }

    @ForType(value=CellSignalStrengthLte.class)
    private static interface CellSignalStrengthLteReflector {
        @Constructor
        public CellSignalStrengthLte newCellSignalStrength();

        @Constructor
        public CellSignalStrengthLte newCellSignalStrength(int var1, int var2, int var3, int var4, int var5, int var6);

        @Constructor
        public CellSignalStrengthLte newCellSignalStrength(int var1, int var2, int var3, int var4, int var5, int var6, int var7);
    }
}

