/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telephony.CellIdentityLte;
import android.telephony.CellInfo;
import android.telephony.CellInfoLte;
import android.telephony.CellSignalStrengthLte;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.shadows.CellIdentityLteBuilder;
import org.robolectric.shadows.CellSignalStrengthLteBuilder;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Constructor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.WithType;

public class CellInfoLteBuilder {
    private boolean isRegistered = false;
    private long timeStamp = 0L;
    private int cellConnectionStatus = 0;
    private CellIdentityLte cellIdentity;
    private CellSignalStrengthLte cellSignalStrength;

    private CellInfoLteBuilder() {
    }

    public static CellInfoLteBuilder newBuilder() {
        return new CellInfoLteBuilder();
    }

    public CellInfoLteBuilder setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
        return this;
    }

    public CellInfoLteBuilder setTimeStampNanos(long timeStamp) {
        this.timeStamp = timeStamp;
        return this;
    }

    public CellInfoLteBuilder setCellConnectionStatus(int cellConnectionStatus) {
        this.cellConnectionStatus = cellConnectionStatus;
        return this;
    }

    public CellInfoLteBuilder setCellIdentity(CellIdentityLte cellIdentity) {
        this.cellIdentity = cellIdentity;
        return this;
    }

    public CellInfoLteBuilder setCellSignalStrength(CellSignalStrengthLte cellSignalStrength) {
        this.cellSignalStrength = cellSignalStrength;
        return this;
    }

    public CellInfoLte build() {
        int apiLevel = RuntimeEnvironment.getApiLevel();
        if (this.cellIdentity == null) {
            this.cellIdentity = apiLevel > 29 ? CellIdentityLteBuilder.getDefaultInstance() : CellIdentityLteBuilder.newBuilder().build();
        }
        if (this.cellSignalStrength == null) {
            this.cellSignalStrength = CellSignalStrengthLteBuilder.getDefaultInstance();
        }
        CellInfoLteReflector cellInfoLteReflector = (CellInfoLteReflector)Reflector.reflector(CellInfoLteReflector.class);
        if (apiLevel < 33) {
            CellInfoLte cellInfo = cellInfoLteReflector.newCellInfoLte();
            cellInfoLteReflector = (CellInfoLteReflector)Reflector.reflector(CellInfoLteReflector.class, (Object)cellInfo);
            cellInfoLteReflector.setCellIdentity(this.cellIdentity);
            cellInfoLteReflector.setCellSignalStrength(this.cellSignalStrength);
            CellInfoReflector cellInfoReflector = (CellInfoReflector)Reflector.reflector(CellInfoReflector.class, (Object)cellInfo);
            cellInfoReflector.setTimeStamp(this.timeStamp);
            cellInfoReflector.setRegistered(this.isRegistered);
            if (apiLevel > 27) {
                cellInfoReflector.setCellConnectionStatus(this.cellConnectionStatus);
            }
            return cellInfo;
        }
        try {
            Class<?> cellConfigLteClass = Class.forName("android.telephony.CellConfigLte");
            return cellInfoLteReflector.newCellInfoLte(this.cellConnectionStatus, this.isRegistered, this.timeStamp, this.cellIdentity, this.cellSignalStrength, ReflectionHelpers.callConstructor(cellConfigLteClass, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @ForType(value=CellInfoLte.class)
    private static interface CellInfoLteReflector {
        @Constructor
        public CellInfoLte newCellInfoLte();

        @Constructor
        public CellInfoLte newCellInfoLte(int var1, boolean var2, long var3, CellIdentityLte var5, CellSignalStrengthLte var6, @WithType(value="android.telephony.CellConfigLte") Object var7);

        @Accessor(value="mCellIdentityLte")
        public void setCellIdentity(CellIdentityLte var1);

        @Accessor(value="mCellSignalStrengthLte")
        public void setCellSignalStrength(CellSignalStrengthLte var1);
    }

    @ForType(value=CellInfo.class)
    private static interface CellInfoReflector {
        @Accessor(value="mRegistered")
        public void setRegistered(boolean var1);

        @Accessor(value="mTimeStamp")
        public void setTimeStamp(long var1);

        @Accessor(value="mCellConnectionStatus")
        public void setCellConnectionStatus(int var1);
    }
}

