package org.robolectric.shadows;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GnssStatusBuilder_GnssSatelliteInfo extends GnssStatusBuilder.GnssSatelliteInfo {

  private final int constellation;

  private final int svid;

  private final float cn0DbHz;

  private final float elevation;

  private final float azimuth;

  private final boolean hasEphemeris;

  private final boolean hasAlmanac;

  private final boolean usedInFix;

  @Nullable
  private final Float carrierFrequencyHz;

  private AutoValue_GnssStatusBuilder_GnssSatelliteInfo(
      int constellation,
      int svid,
      float cn0DbHz,
      float elevation,
      float azimuth,
      boolean hasEphemeris,
      boolean hasAlmanac,
      boolean usedInFix,
      @Nullable Float carrierFrequencyHz) {
    this.constellation = constellation;
    this.svid = svid;
    this.cn0DbHz = cn0DbHz;
    this.elevation = elevation;
    this.azimuth = azimuth;
    this.hasEphemeris = hasEphemeris;
    this.hasAlmanac = hasAlmanac;
    this.usedInFix = usedInFix;
    this.carrierFrequencyHz = carrierFrequencyHz;
  }

  @Override
  public int getConstellation() {
    return constellation;
  }

  @Override
  public int getSvid() {
    return svid;
  }

  @Override
  public float getCn0DbHz() {
    return cn0DbHz;
  }

  @Override
  public float getElevation() {
    return elevation;
  }

  @Override
  public float getAzimuth() {
    return azimuth;
  }

  @Override
  public boolean getHasEphemeris() {
    return hasEphemeris;
  }

  @Override
  public boolean getHasAlmanac() {
    return hasAlmanac;
  }

  @Override
  public boolean isUsedInFix() {
    return usedInFix;
  }

  @Nullable
  @Override
  public Float getCarrierFrequencyHz() {
    return carrierFrequencyHz;
  }

  @Override
  public String toString() {
    return "GnssSatelliteInfo{"
        + "constellation=" + constellation + ", "
        + "svid=" + svid + ", "
        + "cn0DbHz=" + cn0DbHz + ", "
        + "elevation=" + elevation + ", "
        + "azimuth=" + azimuth + ", "
        + "hasEphemeris=" + hasEphemeris + ", "
        + "hasAlmanac=" + hasAlmanac + ", "
        + "usedInFix=" + usedInFix + ", "
        + "carrierFrequencyHz=" + carrierFrequencyHz
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GnssStatusBuilder.GnssSatelliteInfo) {
      GnssStatusBuilder.GnssSatelliteInfo that = (GnssStatusBuilder.GnssSatelliteInfo) o;
      return this.constellation == that.getConstellation()
          && this.svid == that.getSvid()
          && Float.floatToIntBits(this.cn0DbHz) == Float.floatToIntBits(that.getCn0DbHz())
          && Float.floatToIntBits(this.elevation) == Float.floatToIntBits(that.getElevation())
          && Float.floatToIntBits(this.azimuth) == Float.floatToIntBits(that.getAzimuth())
          && this.hasEphemeris == that.getHasEphemeris()
          && this.hasAlmanac == that.getHasAlmanac()
          && this.usedInFix == that.isUsedInFix()
          && (this.carrierFrequencyHz == null ? that.getCarrierFrequencyHz() == null : this.carrierFrequencyHz.equals(that.getCarrierFrequencyHz()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= constellation;
    h$ *= 1000003;
    h$ ^= svid;
    h$ *= 1000003;
    h$ ^= Float.floatToIntBits(cn0DbHz);
    h$ *= 1000003;
    h$ ^= Float.floatToIntBits(elevation);
    h$ *= 1000003;
    h$ ^= Float.floatToIntBits(azimuth);
    h$ *= 1000003;
    h$ ^= hasEphemeris ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= hasAlmanac ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= usedInFix ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (carrierFrequencyHz == null) ? 0 : carrierFrequencyHz.hashCode();
    return h$;
  }

  static final class Builder extends GnssStatusBuilder.GnssSatelliteInfo.Builder {
    private int constellation;
    private int svid;
    private float cn0DbHz;
    private float elevation;
    private float azimuth;
    private boolean hasEphemeris;
    private boolean hasAlmanac;
    private boolean usedInFix;
    private Float carrierFrequencyHz;
    private byte set$0;
    Builder() {
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setConstellation(int constellation) {
      this.constellation = constellation;
      set$0 |= (byte) 1;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setSvid(int svid) {
      this.svid = svid;
      set$0 |= (byte) 2;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setCn0DbHz(float cn0DbHz) {
      this.cn0DbHz = cn0DbHz;
      set$0 |= (byte) 4;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setElevation(float elevation) {
      this.elevation = elevation;
      set$0 |= (byte) 8;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setAzimuth(float azimuth) {
      this.azimuth = azimuth;
      set$0 |= (byte) 0x10;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setHasEphemeris(boolean hasEphemeris) {
      this.hasEphemeris = hasEphemeris;
      set$0 |= (byte) 0x20;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setHasAlmanac(boolean hasAlmanac) {
      this.hasAlmanac = hasAlmanac;
      set$0 |= (byte) 0x40;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setUsedInFix(boolean usedInFix) {
      this.usedInFix = usedInFix;
      set$0 |= (byte) 0x80;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo.Builder setCarrierFrequencyHz(@Nullable Float carrierFrequencyHz) {
      this.carrierFrequencyHz = carrierFrequencyHz;
      return this;
    }
    @Override
    public GnssStatusBuilder.GnssSatelliteInfo build() {
      if (set$0 != -1) {
        StringBuilder missing = new StringBuilder();
        if ((set$0 & 1) == 0) {
          missing.append(" constellation");
        }
        if ((set$0 & 2) == 0) {
          missing.append(" svid");
        }
        if ((set$0 & 4) == 0) {
          missing.append(" cn0DbHz");
        }
        if ((set$0 & 8) == 0) {
          missing.append(" elevation");
        }
        if ((set$0 & 0x10) == 0) {
          missing.append(" azimuth");
        }
        if ((set$0 & 0x20) == 0) {
          missing.append(" hasEphemeris");
        }
        if ((set$0 & 0x40) == 0) {
          missing.append(" hasAlmanac");
        }
        if ((set$0 & 0x80) == 0) {
          missing.append(" usedInFix");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GnssStatusBuilder_GnssSatelliteInfo(
          this.constellation,
          this.svid,
          this.cn0DbHz,
          this.elevation,
          this.azimuth,
          this.hasEphemeris,
          this.hasAlmanac,
          this.usedInFix,
          this.carrierFrequencyHz);
    }
  }

}
