/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Intent;
import android.net.PlatformVpnProfile;
import android.net.VpnManager;
import android.net.VpnProfileState;
import java.util.UUID;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=VpnManager.class, minSdk=30, isInAndroidSdk=false)
public class ShadowVpnManager {
    private VpnProfileState vpnProfileState;
    private Intent provisionVpnProfileIntent;

    @Implementation
    protected void deleteProvisionedVpnProfile() {
        this.vpnProfileState = null;
    }

    @Implementation(minSdk=33)
    protected VpnProfileState getProvisionedVpnProfileState() {
        return this.vpnProfileState;
    }

    @Implementation
    protected Intent provisionVpnProfile(PlatformVpnProfile profile) {
        if (RuntimeEnvironment.getApiLevel() >= 33) {
            this.vpnProfileState = new VpnProfileState(0, null, false, false);
        }
        return this.provisionVpnProfileIntent;
    }

    public void setProvisionVpnProfileResult(Intent intent) {
        this.provisionVpnProfileIntent = intent;
    }

    @Implementation
    protected void startProvisionedVpnProfile() {
        this.startProvisionedVpnProfileSession();
    }

    @Implementation(minSdk=33)
    protected String startProvisionedVpnProfileSession() {
        String sessionKey = UUID.randomUUID().toString();
        if (RuntimeEnvironment.getApiLevel() >= 33) {
            this.vpnProfileState = new VpnProfileState(2, sessionKey, false, false);
        }
        return sessionKey;
    }

    @Implementation
    protected void stopProvisionedVpnProfile() {
        if (RuntimeEnvironment.getApiLevel() >= 33) {
            this.vpnProfileState = new VpnProfileState(0, null, false, false);
        }
    }
}

