/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.WorkSource;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=PowerManager.class, looseSignatures=true)
public class ShadowPowerManager {
    @RealObject
    private PowerManager realPowerManager;
    private boolean isInteractive = true;
    private boolean isPowerSaveMode = false;
    private boolean isDeviceIdleMode = false;
    private boolean isLightDeviceIdleMode = false;
    private Duration batteryDischargePrediction = null;
    private boolean isBatteryDischargePredictionPersonalized = false;
    private int locationMode = 2;
    private final List<String> rebootReasons = new ArrayList<String>();
    private final Map<String, Boolean> ignoringBatteryOptimizations = new HashMap<String, Boolean>();
    private int thermalStatus = 0;
    private final Set<Object> thermalListeners = new HashSet<Object>();
    private final Set<String> ambientDisplaySuppressionTokens = Collections.synchronizedSet(new HashSet());
    private volatile boolean isAmbientDisplayAvailable = true;
    private volatile boolean isRebootingUserspaceSupported = false;
    private volatile boolean adaptivePowerSaveEnabled = false;
    private static PowerManager.WakeLock latestWakeLock;
    private boolean lowPowerStandbyEnabled = false;
    private boolean lowPowerStandbySupported = false;
    private boolean exemptFromLowPowerStandby = false;
    private final Set<String> allowedFeatures = new HashSet<String>();
    private Map<Integer, Boolean> supportedWakeLockLevels = new HashMap<Integer, Boolean>();

    @Implementation
    protected PowerManager.WakeLock newWakeLock(int flags, String tag) {
        PowerManager.WakeLock wl = (PowerManager.WakeLock)Shadow.newInstanceOf(PowerManager.WakeLock.class);
        ((ShadowWakeLock)Shadow.extract((Object)wl)).setTag(tag);
        latestWakeLock = wl;
        return wl;
    }

    @Implementation
    protected boolean isScreenOn() {
        return this.isInteractive;
    }

    @Deprecated
    public void setIsScreenOn(boolean screenOn) {
        this.setIsInteractive(screenOn);
    }

    @Implementation
    protected boolean isInteractive() {
        return this.isInteractive;
    }

    @Deprecated
    public void setIsInteractive(boolean interactive) {
        this.isInteractive = interactive;
    }

    public void turnScreenOn(boolean screenOn) {
        if (this.isInteractive != screenOn) {
            this.isInteractive = screenOn;
            this.getContext().sendBroadcast(new Intent(screenOn ? "android.intent.action.SCREEN_ON" : "android.intent.action.SCREEN_OFF"));
        }
    }

    @Implementation
    protected boolean isPowerSaveMode() {
        return this.isPowerSaveMode;
    }

    public void setIsPowerSaveMode(boolean powerSaveMode) {
        this.isPowerSaveMode = powerSaveMode;
    }

    @Implementation
    protected boolean isWakeLockLevelSupported(int level) {
        return this.supportedWakeLockLevels.containsKey(level) ? this.supportedWakeLockLevels.get(level) : false;
    }

    public void setIsWakeLockLevelSupported(int level, boolean supported) {
        this.supportedWakeLockLevels.put(level, supported);
    }

    @Implementation(minSdk=23)
    protected boolean isDeviceIdleMode() {
        return this.isDeviceIdleMode;
    }

    public void setIsDeviceIdleMode(boolean isDeviceIdleMode) {
        this.isDeviceIdleMode = isDeviceIdleMode;
    }

    @Implementation(minSdk=24)
    protected boolean isLightDeviceIdleMode() {
        return this.isLightDeviceIdleMode;
    }

    public void setIsLightDeviceIdleMode(boolean lightDeviceIdleMode) {
        this.isLightDeviceIdleMode = lightDeviceIdleMode;
    }

    @Implementation(minSdk=33)
    protected boolean isDeviceLightIdleMode() {
        return this.isLightDeviceIdleMode();
    }

    public void setIsDeviceLightIdleMode(boolean lightDeviceIdleMode) {
        this.setIsLightDeviceIdleMode(lightDeviceIdleMode);
    }

    @Implementation(minSdk=28)
    protected int getLocationPowerSaveMode() {
        if (!this.isPowerSaveMode()) {
            return 0;
        }
        return this.locationMode;
    }

    public void setLocationPowerSaveMode(int locationMode) {
        Preconditions.checkState((locationMode >= 0 ? 1 : 0) != 0, (Object)"Location Power Save Mode must be at least 0");
        Preconditions.checkState((locationMode <= 4 ? 1 : 0) != 0, (Object)"Location Power Save Mode must be no more than 4");
        this.locationMode = locationMode;
    }

    @Implementation(minSdk=29)
    protected int getCurrentThermalStatus() {
        return this.thermalStatus;
    }

    @Implementation(minSdk=29)
    protected void addThermalStatusListener(Object listener) {
        Preconditions.checkState((boolean)(listener instanceof PowerManager.OnThermalStatusChangedListener), (Object)"Listener must implement PowerManager.OnThermalStatusChangedListener");
        this.thermalListeners.add(listener);
    }

    public ImmutableSet<Object> getThermalStatusListeners() {
        return ImmutableSet.copyOf(this.thermalListeners);
    }

    @Implementation(minSdk=29)
    protected void removeThermalStatusListener(Object listener) {
        Preconditions.checkState((boolean)(listener instanceof PowerManager.OnThermalStatusChangedListener), (Object)"Listener must implement PowerManager.OnThermalStatusChangedListener");
        this.thermalListeners.remove(listener);
    }

    public void setCurrentThermalStatus(int thermalStatus) {
        Preconditions.checkState((thermalStatus >= 0 ? 1 : 0) != 0, (Object)"Thermal status must be at least 0");
        Preconditions.checkState((thermalStatus <= 6 ? 1 : 0) != 0, (Object)"Thermal status must be no more than 6");
        this.thermalStatus = thermalStatus;
        for (Object listener : this.thermalListeners) {
            ((PowerManager.OnThermalStatusChangedListener)listener).onThermalStatusChanged(thermalStatus);
        }
    }

    @Resetter
    public static void reset() {
        ShadowPowerManager.clearWakeLocks();
    }

    public static PowerManager.WakeLock getLatestWakeLock() {
        return latestWakeLock;
    }

    public static void clearWakeLocks() {
        latestWakeLock = null;
    }

    @Deprecated
    static void addWakeLock(PowerManager.WakeLock wl) {
        latestWakeLock = wl;
    }

    @Implementation(minSdk=23)
    protected boolean isIgnoringBatteryOptimizations(String packageName) {
        Boolean result = this.ignoringBatteryOptimizations.get(packageName);
        return result == null ? false : result;
    }

    public void setIgnoringBatteryOptimizations(String packageName, boolean value) {
        this.ignoringBatteryOptimizations.put(packageName, value);
    }

    @SystemApi
    @Implementation(minSdk=31)
    @RequiresPermission(value="android.permission.DEVICE_POWER")
    protected void setBatteryDischargePrediction(Duration timeRemaining, boolean isPersonalized) {
        this.batteryDischargePrediction = timeRemaining;
        this.isBatteryDischargePredictionPersonalized = isPersonalized;
    }

    @Implementation(minSdk=31)
    protected Duration getBatteryDischargePrediction() {
        return this.batteryDischargePrediction;
    }

    @Implementation(minSdk=31)
    protected boolean isBatteryDischargePredictionPersonalized() {
        return this.isBatteryDischargePredictionPersonalized;
    }

    @Implementation
    protected void reboot(String reason) {
        if (RuntimeEnvironment.getApiLevel() >= 30 && "userspace".equals(reason) && !this.isRebootingUserspaceSupported()) {
            throw new UnsupportedOperationException("Attempted userspace reboot on a device that doesn't support it");
        }
        this.rebootReasons.add(reason);
    }

    public int getTimesRebooted() {
        return this.rebootReasons.size();
    }

    public List<String> getRebootReasons() {
        return new ArrayList<String>(this.rebootReasons);
    }

    public void setAmbientDisplayAvailable(boolean available) {
        this.isAmbientDisplayAvailable = available;
    }

    public void setIsRebootingUserspaceSupported(boolean supported) {
        this.isRebootingUserspaceSupported = supported;
    }

    @Implementation(minSdk=30)
    protected boolean isAmbientDisplayAvailable() {
        return this.isAmbientDisplayAvailable;
    }

    @Implementation(minSdk=30)
    protected void suppressAmbientDisplay(String token, boolean suppress) {
        String suppressionToken = Binder.getCallingUid() + "_" + token;
        if (suppress) {
            this.ambientDisplaySuppressionTokens.add(suppressionToken);
        } else {
            this.ambientDisplaySuppressionTokens.remove(suppressionToken);
        }
    }

    @Implementation(minSdk=30)
    protected boolean isAmbientDisplaySuppressed() {
        return !this.ambientDisplaySuppressionTokens.isEmpty();
    }

    @Implementation(minSdk=30)
    protected boolean isRebootingUserspaceSupported() {
        return this.isRebootingUserspaceSupported;
    }

    @Implementation(minSdk=29)
    @SystemApi
    protected boolean setAdaptivePowerSaveEnabled(boolean enabled) {
        boolean changed = this.adaptivePowerSaveEnabled != enabled;
        this.adaptivePowerSaveEnabled = enabled;
        return changed;
    }

    public boolean getAdaptivePowerSaveEnabled() {
        return this.adaptivePowerSaveEnabled;
    }

    private Context getContext() {
        return ((ReflectorPowerManager)Reflector.reflector(ReflectorPowerManager.class, (Object)this.realPowerManager)).getContext();
    }

    @Implementation(minSdk=33)
    protected boolean isLowPowerStandbySupported() {
        return this.lowPowerStandbySupported;
    }

    @TargetApi(value=33)
    public void setLowPowerStandbySupported(boolean lowPowerStandbySupported) {
        this.lowPowerStandbySupported = lowPowerStandbySupported;
    }

    @Implementation(minSdk=33)
    protected boolean isLowPowerStandbyEnabled() {
        return this.lowPowerStandbySupported && this.lowPowerStandbyEnabled;
    }

    @Implementation(minSdk=33)
    protected void setLowPowerStandbyEnabled(boolean lowPowerStandbyEnabled) {
        this.lowPowerStandbyEnabled = lowPowerStandbyEnabled;
    }

    @Implementation(minSdk=34)
    protected boolean isAllowedInLowPowerStandby(String feature) {
        if (!this.lowPowerStandbySupported) {
            return true;
        }
        return this.allowedFeatures.contains(feature);
    }

    @TargetApi(value=34)
    public void addAllowedInLowPowerStandby(String feature) {
        this.allowedFeatures.add(feature);
    }

    @Implementation(minSdk=34)
    protected boolean isExemptFromLowPowerStandby() {
        if (!this.lowPowerStandbySupported) {
            return true;
        }
        return this.exemptFromLowPowerStandby;
    }

    @TargetApi(value=34)
    public void setExemptFromLowPowerStandby(boolean exemptFromLowPowerStandby) {
        this.exemptFromLowPowerStandby = exemptFromLowPowerStandby;
    }

    @Implementation(minSdk=34)
    protected Object newLowPowerStandbyPortsLock(List<PowerManager.LowPowerStandbyPortDescription> ports) {
        PowerManager.LowPowerStandbyPortsLock lock = (PowerManager.LowPowerStandbyPortsLock)Shadow.newInstanceOf(PowerManager.LowPowerStandbyPortsLock.class);
        ((ShadowLowPowerStandbyPortsLock)Shadow.extract((Object)lock)).setPorts(ports);
        return lock;
    }

    @Implements(value=PowerManager.WakeLock.class)
    public static class ShadowWakeLock {
        private boolean refCounted = true;
        private WorkSource workSource = null;
        private int timesHeld = 0;
        private String tag = null;
        private List<Optional<Long>> timeoutTimestampList = new ArrayList<Optional<Long>>();

        private void acquireInternal(Optional<Long> timeoutOptional) {
            ++this.timesHeld;
            this.timeoutTimestampList.add(timeoutOptional);
        }

        private void refreshTimeoutTimestampList() {
            this.timeoutTimestampList = this.timeoutTimestampList.stream().filter(o -> !o.isPresent() || (Long)o.get() >= SystemClock.elapsedRealtime()).collect(Collectors.toCollection(ArrayList::new));
        }

        @Implementation
        protected void acquire() {
            this.acquireInternal(Optional.empty());
        }

        @Implementation
        protected synchronized void acquire(long timeout) {
            Long timeoutMillis = timeout + SystemClock.elapsedRealtime();
            if (timeoutMillis > 0L) {
                this.acquireInternal(Optional.of(timeoutMillis));
            } else {
                this.acquireInternal(Optional.empty());
            }
        }

        @Implementation
        protected synchronized void release(int flags) {
            this.refreshTimeoutTimestampList();
            Optional<Optional> wakeLockOptional = this.timeoutTimestampList.stream().min(Comparator.comparing(arg -> arg.orElse(Long.MAX_VALUE), (leftProperty, rightProperty) -> leftProperty - rightProperty > 0L ? 1 : -1));
            if (wakeLockOptional.isEmpty()) {
                if (this.refCounted) {
                    throw new RuntimeException("WakeLock under-locked");
                }
                return;
            }
            Optional wakeLock = wakeLockOptional.get();
            if (this.refCounted) {
                this.timeoutTimestampList.remove(wakeLock);
            } else {
                this.timeoutTimestampList = new ArrayList<Optional<Long>>();
            }
        }

        @Implementation
        protected synchronized boolean isHeld() {
            this.refreshTimeoutTimestampList();
            return !this.timeoutTimestampList.isEmpty();
        }

        public boolean isReferenceCounted() {
            return this.refCounted;
        }

        @Implementation
        protected void setReferenceCounted(boolean value) {
            this.refCounted = value;
        }

        @Implementation
        protected synchronized void setWorkSource(WorkSource ws) {
            this.workSource = ws;
        }

        public synchronized WorkSource getWorkSource() {
            return this.workSource;
        }

        public int getTimesHeld() {
            return this.timesHeld;
        }

        @HiddenApi
        @Implementation(minSdk=26)
        public String getTag() {
            return this.tag;
        }

        @Implementation(minSdk=22)
        protected void setTag(String tag) {
            this.tag = tag;
        }
    }

    @ForType(value=PowerManager.class)
    private static interface ReflectorPowerManager {
        @Accessor(value="mContext")
        public Context getContext();
    }

    @Implements(value=PowerManager.LowPowerStandbyPortsLock.class, minSdk=34, isInAndroidSdk=false)
    public static class ShadowLowPowerStandbyPortsLock {
        private List<PowerManager.LowPowerStandbyPortDescription> ports;
        private boolean isAcquired = false;
        private int acquireCount = 0;

        @Implementation(minSdk=34)
        protected void acquire() {
            this.isAcquired = true;
            ++this.acquireCount;
        }

        @Implementation(minSdk=34)
        protected void release() {
            this.isAcquired = false;
        }

        public boolean isAcquired() {
            return this.isAcquired;
        }

        public int getAcquireCount() {
            return this.acquireCount;
        }

        public void setPorts(List<PowerManager.LowPowerStandbyPortDescription> ports) {
            this.ports = ports;
        }

        public List<PowerManager.LowPowerStandbyPortDescription> getPorts() {
            return this.ports;
        }
    }
}

