/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.IntentFilter;
import android.nfc.NdefMessage;
import android.nfc.NfcAdapter;
import android.nfc.NfcAntennaInfo;
import android.nfc.Tag;
import android.os.Bundle;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=NfcAdapter.class, looseSignatures=true)
public class ShadowNfcAdapter {
    @RealObject
    NfcAdapter nfcAdapter;
    @GuardedBy(value="ShadowNfcAdapter.class")
    private static boolean hardwareExists = true;
    @GuardedBy(value="this")
    private boolean enabled;
    @GuardedBy(value="this")
    private boolean secureNfcSupported;
    @GuardedBy(value="this")
    private boolean secureNfcEnabled;
    @GuardedBy(value="this")
    private Activity enabledActivity;
    @GuardedBy(value="this")
    private PendingIntent intent;
    @GuardedBy(value="this")
    private IntentFilter[] filters;
    @GuardedBy(value="this")
    private String[][] techLists;
    @GuardedBy(value="this")
    private Activity disabledActivity;
    @GuardedBy(value="this")
    private NdefMessage ndefPushMessage;
    @GuardedBy(value="this")
    private boolean ndefPushMessageSet;
    @GuardedBy(value="this")
    private NfcAdapter.CreateNdefMessageCallback ndefPushMessageCallback;
    @GuardedBy(value="this")
    private NfcAdapter.OnNdefPushCompleteCallback onNdefPushCompleteCallback;
    @GuardedBy(value="this")
    private NfcAdapter.ReaderCallback readerCallback;
    @GuardedBy(value="this")
    private NfcAntennaInfo nfcAntennaInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static NfcAdapter getDefaultAdapter(Context context) {
        Class<ShadowNfcAdapter> clazz = ShadowNfcAdapter.class;
        synchronized (ShadowNfcAdapter.class) {
            if (!hardwareExists) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ((NfcAdapterReflector)Reflector.reflector(NfcAdapterReflector.class)).getDefaultAdapter(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static NfcAdapter getNfcAdapter(Context context) {
        Class<ShadowNfcAdapter> clazz = ShadowNfcAdapter.class;
        synchronized (ShadowNfcAdapter.class) {
            if (!hardwareExists) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ((NfcAdapterReflector)Reflector.reflector(NfcAdapterReflector.class)).getNfcAdapter(context);
        }
    }

    public static Tag createMockTag() {
        if (RuntimeEnvironment.getApiLevel() <= 33) {
            return (Tag)ReflectionHelpers.callStaticMethod(Tag.class, (String)"createMockTag", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(byte[].class, (Object)new byte[0]), ReflectionHelpers.ClassParameter.from(int[].class, (Object)new int[0]), ReflectionHelpers.ClassParameter.from(Bundle[].class, (Object)new Bundle[0])});
        }
        return (Tag)ReflectionHelpers.callStaticMethod(Tag.class, (String)"createMockTag", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(byte[].class, (Object)new byte[0]), ReflectionHelpers.ClassParameter.from(int[].class, (Object)new int[0]), ReflectionHelpers.ClassParameter.from(Bundle[].class, (Object)new Bundle[0]), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void enableForegroundDispatch(Activity activity, PendingIntent intent, IntentFilter[] filters, String[][] techLists) {
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            this.enabledActivity = activity;
            this.intent = intent;
            this.filters = filters;
            this.techLists = techLists;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void disableForegroundDispatch(Activity activity) {
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            this.disabledActivity = activity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void enableReaderMode(Activity activity, NfcAdapter.ReaderCallback callback, int flags, Bundle extras) {
        if (!RuntimeEnvironment.getApplication().getPackageManager().hasSystemFeature("android.hardware.nfc")) {
            throw new UnsupportedOperationException();
        }
        if (callback == null) {
            throw new NullPointerException("ReaderCallback is null");
        }
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            this.readerCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void disableReaderMode(Activity activity) {
        if (!RuntimeEnvironment.getApplication().getPackageManager().hasSystemFeature("android.hardware.nfc")) {
            throw new UnsupportedOperationException();
        }
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            this.readerCallback = null;
        }
    }

    public synchronized boolean isInReaderMode() {
        return this.readerCallback != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchTagDiscovered(Tag tag) {
        NfcAdapter.ReaderCallback callback;
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            callback = this.readerCallback;
        }
        if (callback != null) {
            callback.onTagDiscovered(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void setNdefPushMessage(NdefMessage message, Activity activity, Activity ... activities) {
        if (activity == null) {
            throw new NullPointerException("activity cannot be null");
        }
        for (Activity a : activities) {
            if (a != null) continue;
            throw new NullPointerException("activities cannot contain null");
        }
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            this.ndefPushMessage = message;
            this.ndefPushMessageSet = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void setNdefPushMessageCallback(NfcAdapter.CreateNdefMessageCallback callback, Activity activity, Activity ... activities) {
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            this.ndefPushMessageCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void setOnNdefPushCompleteCallback(NfcAdapter.OnNdefPushCompleteCallback callback, Activity activity, Activity ... activities) {
        if (activity == null) {
            throw new NullPointerException("activity cannot be null");
        }
        for (Activity a : activities) {
            if (a != null) continue;
            throw new NullPointerException("activities cannot contain null");
        }
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            this.onNdefPushCompleteCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected boolean isEnabled() {
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected boolean enable() {
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            this.enabled = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected boolean disable() {
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            this.enabled = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=29)
    protected boolean isSecureNfcSupported() {
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            return this.secureNfcSupported;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=29)
    protected boolean isSecureNfcEnabled() {
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            return this.secureNfcEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=29)
    protected boolean enableSecureNfc(boolean enableSecureNfc) {
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            this.secureNfcEnabled = enableSecureNfc;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=34)
    protected Object getNfcAntennaInfo() {
        ShadowNfcAdapter shadowNfcAdapter = this;
        synchronized (shadowNfcAdapter) {
            return this.nfcAntennaInfo;
        }
    }

    public static synchronized void setNfcHardwareExists(boolean hardwareExists) {
        ShadowNfcAdapter.hardwareExists = hardwareExists;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public synchronized void setSecureNfcSupported(boolean secureNfcSupported) {
        this.secureNfcSupported = secureNfcSupported;
    }

    public synchronized Activity getEnabledActivity() {
        return this.enabledActivity;
    }

    public synchronized PendingIntent getIntent() {
        return this.intent;
    }

    public synchronized IntentFilter[] getFilters() {
        return this.filters;
    }

    public synchronized String[][] getTechLists() {
        return this.techLists;
    }

    public synchronized Activity getDisabledActivity() {
        return this.disabledActivity;
    }

    public synchronized NfcAdapter.CreateNdefMessageCallback getNdefPushMessageCallback() {
        return this.ndefPushMessageCallback;
    }

    public synchronized NfcAdapter.OnNdefPushCompleteCallback getOnNdefPushCompleteCallback() {
        return this.onNdefPushCompleteCallback;
    }

    public synchronized NdefMessage getNdefPushMessage() {
        if (!this.ndefPushMessageSet) {
            throw new IllegalStateException();
        }
        return this.ndefPushMessage;
    }

    public synchronized void setNfcAntennaInfo(Object nfcAntennaInfo) {
        this.nfcAntennaInfo = (NfcAntennaInfo)nfcAntennaInfo;
    }

    @Resetter
    public static synchronized void reset() {
        hardwareExists = true;
        NfcAdapterReflector nfcAdapterReflector = (NfcAdapterReflector)Reflector.reflector(NfcAdapterReflector.class);
        nfcAdapterReflector.setIsInitialized(false);
        Map<Context, NfcAdapter> adapters = nfcAdapterReflector.getNfcAdapters();
        if (adapters != null) {
            adapters.clear();
        }
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            nfcAdapterReflector.setHasNfcFeature(false);
            if (RuntimeEnvironment.getApiLevel() <= 33) {
                nfcAdapterReflector.setHasBeamFeature(false);
            }
        }
    }

    @ForType(value=NfcAdapter.class)
    static interface NfcAdapterReflector {
        @Static
        @Accessor(value="sIsInitialized")
        public void setIsInitialized(boolean var1);

        @Static
        @Accessor(value="sHasNfcFeature")
        public void setHasNfcFeature(boolean var1);

        @Static
        @Accessor(value="sHasBeamFeature")
        public void setHasBeamFeature(boolean var1);

        @Static
        @Accessor(value="sNfcAdapters")
        public Map<Context, NfcAdapter> getNfcAdapters();

        @Direct
        @Static
        public NfcAdapter getNfcAdapter(Context var1);

        @Direct
        @Static
        public NfcAdapter getDefaultAdapter(Context var1);
    }

    @ForType(value=Tag.class)
    static interface TagReflector {
        public Tag createMockTag(byte[] var1, int[] var2, Bundle[] var3, long var4);
    }
}

