/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Canvas;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.nativeruntime.DefaultNativeRuntimeLoader;
import org.robolectric.nativeruntime.RenderNodeNatives;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowNativeRecordingCanvas;
import org.robolectric.shadows.ShadowRenderNode;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(className="android.view.RenderNode", minSdk=26, maxSdk=28, looseSignatures=true, shadowPicker=Picker.class)
public class ShadowNativeRenderNodeOP {
    @RealObject
    Object realRenderNode;

    @Implementation
    protected static long nCreate(String name) {
        DefaultNativeRuntimeLoader.injectAndLoad();
        return RenderNodeNatives.nCreate((String)name);
    }

    @Implementation
    protected static long nGetNativeFinalizer() {
        return RenderNodeNatives.nGetNativeFinalizer();
    }

    @Implementation
    protected static void nOutput(long renderNode) {
        RenderNodeNatives.nOutput((long)renderNode);
    }

    @Implementation
    protected static void nAddAnimator(long renderNode, long animatorPtr) {
        RenderNodeNatives.nAddAnimator((long)renderNode, (long)animatorPtr);
    }

    @Implementation
    protected static void nEndAllAnimators(long renderNode) {
        RenderNodeNatives.nEndAllAnimators((long)renderNode);
    }

    @Implementation
    protected static boolean nIsValid(long renderNode) {
        return RenderNodeNatives.nIsValid((long)renderNode);
    }

    @Implementation
    protected static void nGetTransformMatrix(long renderNode, long nativeMatrix) {
        RenderNodeNatives.nGetTransformMatrix((long)renderNode, (long)nativeMatrix);
    }

    @Implementation
    protected static void nGetInverseTransformMatrix(long renderNode, long nativeMatrix) {
        RenderNodeNatives.nGetInverseTransformMatrix((long)renderNode, (long)nativeMatrix);
    }

    @Implementation
    protected static boolean nHasIdentityMatrix(long renderNode) {
        return RenderNodeNatives.nHasIdentityMatrix((long)renderNode);
    }

    @Implementation
    protected static boolean nOffsetTopAndBottom(long renderNode, int offset) {
        return RenderNodeNatives.nOffsetTopAndBottom((long)renderNode, (int)offset);
    }

    @Implementation
    protected static boolean nOffsetLeftAndRight(long renderNode, int offset) {
        return RenderNodeNatives.nOffsetLeftAndRight((long)renderNode, (int)offset);
    }

    @Implementation
    protected static boolean nSetLeftTopRightBottom(long renderNode, int left, int top, int right, int bottom) {
        return RenderNodeNatives.nSetLeftTopRightBottom((long)renderNode, (int)left, (int)top, (int)right, (int)bottom);
    }

    @Implementation
    protected static boolean nSetLeft(long renderNode, int left) {
        return RenderNodeNatives.nSetLeft((long)renderNode, (int)left);
    }

    @Implementation
    protected static boolean nSetTop(long renderNode, int top) {
        return RenderNodeNatives.nSetTop((long)renderNode, (int)top);
    }

    @Implementation
    protected static boolean nSetRight(long renderNode, int right) {
        return RenderNodeNatives.nSetRight((long)renderNode, (int)right);
    }

    @Implementation
    protected static boolean nSetBottom(long renderNode, int bottom) {
        return RenderNodeNatives.nSetBottom((long)renderNode, (int)bottom);
    }

    @Implementation
    protected static boolean nSetCameraDistance(long renderNode, float distance) {
        return RenderNodeNatives.nSetCameraDistance((long)renderNode, (float)distance);
    }

    @Implementation
    protected static boolean nSetPivotY(long renderNode, float pivotY) {
        return RenderNodeNatives.nSetPivotY((long)renderNode, (float)pivotY);
    }

    @Implementation
    protected static boolean nSetPivotX(long renderNode, float pivotX) {
        return RenderNodeNatives.nSetPivotX((long)renderNode, (float)pivotX);
    }

    @Implementation(minSdk=28)
    protected static boolean nResetPivot(long renderNode) {
        return RenderNodeNatives.nResetPivot((long)renderNode);
    }

    @Implementation
    protected static boolean nSetLayerType(long renderNode, int layerType) {
        return RenderNodeNatives.nSetLayerType((long)renderNode, (int)layerType);
    }

    @Implementation
    protected static boolean nSetLayerPaint(long renderNode, long paint) {
        return RenderNodeNatives.nSetLayerPaint((long)renderNode, (long)paint);
    }

    @Implementation
    protected static boolean nSetClipToBounds(long renderNode, boolean clipToBounds) {
        return RenderNodeNatives.nSetClipToBounds((long)renderNode, (boolean)clipToBounds);
    }

    @Implementation
    protected static boolean nSetClipBounds(long renderNode, int left, int top, int right, int bottom) {
        return RenderNodeNatives.nSetClipBounds((long)renderNode, (int)left, (int)top, (int)right, (int)bottom);
    }

    @Implementation
    protected static boolean nSetClipBoundsEmpty(long renderNode) {
        return RenderNodeNatives.nSetClipBoundsEmpty((long)renderNode);
    }

    @Implementation
    protected static boolean nSetProjectBackwards(long renderNode, boolean shouldProject) {
        return RenderNodeNatives.nSetProjectBackwards((long)renderNode, (boolean)shouldProject);
    }

    @Implementation
    protected static boolean nSetProjectionReceiver(long renderNode, boolean shouldReceive) {
        return RenderNodeNatives.nSetProjectionReceiver((long)renderNode, (boolean)shouldReceive);
    }

    @Implementation
    protected static boolean nSetOutlineRoundRect(long renderNode, int left, int top, int right, int bottom, float radius, float alpha) {
        return RenderNodeNatives.nSetOutlineRoundRect((long)renderNode, (int)left, (int)top, (int)right, (int)bottom, (float)radius, (float)alpha);
    }

    @Implementation
    protected static boolean nSetOutlineEmpty(long renderNode) {
        return RenderNodeNatives.nSetOutlineEmpty((long)renderNode);
    }

    @Implementation
    protected static boolean nSetOutlineNone(long renderNode) {
        return RenderNodeNatives.nSetOutlineNone((long)renderNode);
    }

    @Implementation
    protected static boolean nHasShadow(long renderNode) {
        return RenderNodeNatives.nHasShadow((long)renderNode);
    }

    @Implementation(minSdk=28)
    protected static boolean nSetSpotShadowColor(long renderNode, int color) {
        return RenderNodeNatives.nSetSpotShadowColor((long)renderNode, (int)color);
    }

    @Implementation(minSdk=28)
    protected static boolean nSetAmbientShadowColor(long renderNode, int color) {
        return RenderNodeNatives.nSetAmbientShadowColor((long)renderNode, (int)color);
    }

    @Implementation(minSdk=28)
    protected static int nGetSpotShadowColor(long renderNode) {
        return RenderNodeNatives.nGetSpotShadowColor((long)renderNode);
    }

    @Implementation(minSdk=28)
    protected static int nGetAmbientShadowColor(long renderNode) {
        return RenderNodeNatives.nGetAmbientShadowColor((long)renderNode);
    }

    @Implementation
    protected static boolean nSetClipToOutline(long renderNode, boolean clipToOutline) {
        return RenderNodeNatives.nSetClipToOutline((long)renderNode, (boolean)clipToOutline);
    }

    @Implementation
    protected static boolean nSetRevealClip(long renderNode, boolean shouldClip, float x, float y, float radius) {
        return RenderNodeNatives.nSetRevealClip((long)renderNode, (boolean)shouldClip, (float)x, (float)y, (float)radius);
    }

    @Implementation
    protected static boolean nSetAlpha(long renderNode, float alpha) {
        return RenderNodeNatives.nSetAlpha((long)renderNode, (float)alpha);
    }

    @Implementation
    protected static boolean nSetHasOverlappingRendering(long renderNode, boolean hasOverlappingRendering) {
        return RenderNodeNatives.nSetHasOverlappingRendering((long)renderNode, (boolean)hasOverlappingRendering);
    }

    protected static void nSetUsageHint(long renderNode, int usageHint) {
        RenderNodeNatives.nSetUsageHint((long)renderNode, (int)usageHint);
    }

    @Implementation
    protected static boolean nSetElevation(long renderNode, float lift) {
        return RenderNodeNatives.nSetElevation((long)renderNode, (float)lift);
    }

    @Implementation
    protected static boolean nSetTranslationX(long renderNode, float translationX) {
        return RenderNodeNatives.nSetTranslationX((long)renderNode, (float)translationX);
    }

    @Implementation
    protected static boolean nSetTranslationY(long renderNode, float translationY) {
        return RenderNodeNatives.nSetTranslationY((long)renderNode, (float)translationY);
    }

    @Implementation
    protected static boolean nSetTranslationZ(long renderNode, float translationZ) {
        return RenderNodeNatives.nSetTranslationZ((long)renderNode, (float)translationZ);
    }

    @Implementation
    protected static boolean nSetRotation(long renderNode, float rotation) {
        return RenderNodeNatives.nSetRotation((long)renderNode, (float)rotation);
    }

    @Implementation
    protected static boolean nSetRotationX(long renderNode, float rotationX) {
        return RenderNodeNatives.nSetRotationX((long)renderNode, (float)rotationX);
    }

    @Implementation
    protected static boolean nSetRotationY(long renderNode, float rotationY) {
        return RenderNodeNatives.nSetRotationY((long)renderNode, (float)rotationY);
    }

    @Implementation
    protected static boolean nSetScaleX(long renderNode, float scaleX) {
        return RenderNodeNatives.nSetScaleX((long)renderNode, (float)scaleX);
    }

    @Implementation
    protected static boolean nSetScaleY(long renderNode, float scaleY) {
        return RenderNodeNatives.nSetScaleY((long)renderNode, (float)scaleY);
    }

    @Implementation
    protected static boolean nSetStaticMatrix(long renderNode, long nativeMatrix) {
        return RenderNodeNatives.nSetStaticMatrix((long)renderNode, (long)nativeMatrix);
    }

    @Implementation
    protected static boolean nSetAnimationMatrix(long renderNode, long animationMatrix) {
        return RenderNodeNatives.nSetAnimationMatrix((long)renderNode, (long)animationMatrix);
    }

    @Implementation
    protected static boolean nHasOverlappingRendering(long renderNode) {
        return RenderNodeNatives.nHasOverlappingRendering((long)renderNode);
    }

    @Implementation
    protected static boolean nGetClipToOutline(long renderNode) {
        return RenderNodeNatives.nGetClipToOutline((long)renderNode);
    }

    @Implementation
    protected static float nGetAlpha(long renderNode) {
        return RenderNodeNatives.nGetAlpha((long)renderNode);
    }

    @Implementation
    protected static float nGetCameraDistance(long renderNode) {
        return RenderNodeNatives.nGetCameraDistance((long)renderNode);
    }

    @Implementation
    protected static float nGetScaleX(long renderNode) {
        return RenderNodeNatives.nGetScaleX((long)renderNode);
    }

    @Implementation
    protected static float nGetScaleY(long renderNode) {
        return RenderNodeNatives.nGetScaleY((long)renderNode);
    }

    @Implementation
    protected static float nGetElevation(long renderNode) {
        return RenderNodeNatives.nGetElevation((long)renderNode);
    }

    @Implementation
    protected static float nGetTranslationX(long renderNode) {
        return RenderNodeNatives.nGetTranslationX((long)renderNode);
    }

    @Implementation
    protected static float nGetTranslationY(long renderNode) {
        return RenderNodeNatives.nGetTranslationY((long)renderNode);
    }

    @Implementation
    protected static float nGetTranslationZ(long renderNode) {
        return RenderNodeNatives.nGetTranslationZ((long)renderNode);
    }

    @Implementation
    protected static float nGetRotation(long renderNode) {
        return RenderNodeNatives.nGetRotation((long)renderNode);
    }

    @Implementation
    protected static float nGetRotationX(long renderNode) {
        return RenderNodeNatives.nGetRotationX((long)renderNode);
    }

    @Implementation
    protected static float nGetRotationY(long renderNode) {
        return RenderNodeNatives.nGetRotationY((long)renderNode);
    }

    @Implementation
    protected static boolean nIsPivotExplicitlySet(long renderNode) {
        return RenderNodeNatives.nIsPivotExplicitlySet((long)renderNode);
    }

    @Implementation
    protected static float nGetPivotX(long renderNode) {
        return RenderNodeNatives.nGetPivotX((long)renderNode);
    }

    @Implementation
    protected static float nGetPivotY(long renderNode) {
        return RenderNodeNatives.nGetPivotY((long)renderNode);
    }

    @Implementation
    protected void end(Object canvas) {
        long nativeRenderNode = ((RenderNodeOpReflector)Reflector.reflector(RenderNodeOpReflector.class, (Object)this.realRenderNode)).getNativeRenderNode();
        long nativeCanvasWrapper = ((CanvasReflector)Reflector.reflector(CanvasReflector.class, (Object)canvas)).getNativeCanvasWrapper();
        ShadowNativeRecordingCanvas.nFinishRecording(nativeCanvasWrapper, nativeRenderNode);
        ((DisplayListCanvasReflector)Reflector.reflector(DisplayListCanvasReflector.class, (Object)canvas)).recycle();
    }

    @ForType(className="android.view.RenderNode")
    static interface RenderNodeOpReflector {
        @Accessor(value="mNativeRenderNode")
        public long getNativeRenderNode();
    }

    @ForType(value=Canvas.class)
    static interface CanvasReflector {
        public long getNativeCanvasWrapper();
    }

    @ForType(className="android.view.DisplayListCanvas")
    static interface DisplayListCanvasReflector {
        public void recycle();
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowRenderNode.class, ShadowNativeRenderNodeOP.class);
        }
    }
}

